/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xml.xstream.converters;

import com.streamscape.omf.xml.XSerializerRuntimeException;
import com.streamscape.omf.xml.xstream.converters.ErrorWriter;
import com.streamscape.omf.xml.xstream.core.util.OrderRetainingMap;
import java.util.Iterator;
import java.util.Map;

public class ConversionException
extends XSerializerRuntimeException
implements ErrorWriter {
    private static final String SEPARATOR = "\n-------------------------------";
    private transient Map stuff = new OrderRetainingMap();

    public ConversionException(String msg, Throwable cause) {
        super(msg, cause);
        if (msg != null) {
            this.add("message", msg);
        }
        if (cause != null) {
            this.add("cause-exception", cause.getClass().getName());
            this.add("cause-message", cause.getMessage());
        }
    }

    public ConversionException(String msg) {
        super(msg);
    }

    public ConversionException(Throwable cause) {
        this(cause.getMessage(), cause);
    }

    @Override
    public String get(String errorKey) {
        return (String)this.stuff.get(errorKey);
    }

    @Override
    public void add(String name, String information) {
        Object key = name;
        int i = 0;
        while (this.stuff.containsKey(key)) {
            String value = (String)this.stuff.get(key);
            if (information.equals(value)) {
                return;
            }
            key = name + "[" + ++i + "]";
        }
        this.stuff.put(key, information);
    }

    @Override
    public void set(String name, String information) {
        Object key = name;
        int i = 0;
        this.stuff.put(key, information);
        while (this.stuff.containsKey(key)) {
            if (i != 0) {
                this.stuff.remove(key);
            }
            key = name + "[" + ++i + "]";
        }
    }

    @Override
    public Iterator keys() {
        return this.stuff.keySet().iterator();
    }

    public String geDebugMessage() {
        StringBuffer result = new StringBuffer();
        if (super.getMessage() != null) {
            result.append(super.getMessage());
        }
        if (!result.toString().endsWith(SEPARATOR)) {
            result.append("\n---- Debugging information ----");
        }
        Iterator iterator = this.keys();
        while (iterator.hasNext()) {
            String k = (String)iterator.next();
            String v = this.get(k);
            result.append('\n').append(k);
            result.append("                    ".substring(Math.min(20, k.length())));
            result.append(": ").append(v);
        }
        result.append(SEPARATOR);
        return result.toString();
    }

    @Override
    public String getMessage() {
        return super.getMessage();
    }

    @Override
    public String toString() {
        return "Conversion Exception: " + this.getMessage() + (String)(this.getCause() != null && this.getCause().getMessage() != null ? " Cause: " + this.getCause().getMessage() : "");
    }
}

