/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xml;

import com.streamscape.Trace;
import com.streamscape.cli.ClientContext;
import com.streamscape.cli.ClientState;
import com.streamscape.lib.utils.JVM;
import com.streamscape.omf.FactoryManagerException;
import com.streamscape.omf.mf.admin.ObjectMediationAliasManager;
import com.streamscape.omf.serializer.AbstractSerializerFactory;
import com.streamscape.omf.serializer.AliasManager;
import com.streamscape.omf.serializer.SerializerFactory;
import com.streamscape.omf.serializer.SerializerUtils;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.omf.xml.xstream.converters.ConverterLookup;
import com.streamscape.omf.xml.xstream.converters.ConverterRegistry;
import com.streamscape.omf.xml.xstream.converters.reflection.ReflectionProvider;
import com.streamscape.omf.xml.xstream.io.HierarchicalStreamDriver;
import com.streamscape.omf.xml.xstream.io.xml.XmlFriendlyNameCoder;
import com.streamscape.omf.xml.xstream.mapper.Mapper;
import com.streamscape.repository.types.Prototype;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.RuntimeState;
import com.streamscape.sdo.ErrorMessages;
import com.streamscape.sdo.mf.admin.DatagramPrototypeCache;
import com.streamscape.sef.dispatcher.AbstractOMFManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XSerializerFactory
extends AbstractSerializerFactory
implements SerializerFactory,
AliasManager {
    private static final String FACTORY_NAME = "XSerializer";
    private static XSerializerFactory instance = null;
    private transient Map<String, XSerializer> serializers = new HashMap<String, XSerializer>();
    private transient Map<String, String> xProtoRegistry = new HashMap<String, String>();

    public static XSerializerFactory getInstance() {
        XSerializerFactory.init(null, null);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void init(AbstractOMFManager omfManager, ObjectMediationAliasManager manager) {
        if (instance != null) return;
        Class<XSerializerFactory> clazz = XSerializerFactory.class;
        synchronized (XSerializerFactory.class) {
            if (instance != null) return;
            instance = new XSerializerFactory(omfManager, manager);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private XSerializerFactory(AbstractOMFManager omfManager, ObjectMediationAliasManager manager) {
        super(omfManager, manager);
        try {
            SerializerUtils.addSysAliases(this.aliasManager);
            SerializerUtils.addSysTypeAliases(this.aliasManager);
        }
        catch (Throwable exception) {
            throw new RuntimeException("Initialization of XSerializerFactory failed.", exception);
        }
        XSerializer serializer = new XSerializer(null, (ClassLoader)null, this.aliasManager);
        serializer.setName("sys$serializer");
        serializer.mapAttribute("SemanticType", "class");
        this.serializers.put("sys$serializer", serializer);
        Trace.logInfo(XSerializerFactory.class, "XSerializer Factory initialized.");
    }

    @Override
    public XSerializer createSerializer(String name) {
        return this.putSerializer(new XSerializer(null, (ClassLoader)null, this.aliasManager), name);
    }

    public XSerializer createSerializer(String name, XmlFriendlyNameCoder encoder) {
        return this.putSerializer(new XSerializer(encoder, null, this.aliasManager), name);
    }

    @Override
    public XSerializer createSerializer(String name, ObjectMediationAliasManager aliasMgr) {
        return this.putSerializer(new XSerializer(null, (ClassLoader)null, aliasMgr), name);
    }

    public XSerializer createSerializer(String name, ClassLoader loader) {
        return this.putSerializer(new XSerializer(null, loader, this.aliasManager), name);
    }

    public XSerializer createSerializer(String name, XmlFriendlyNameCoder encoder, ClassLoader loader, ObjectMediationAliasManager aliasMgr) {
        return this.putSerializer(new XSerializer(encoder, loader, aliasMgr), name);
    }

    public XSerializer createSerializer(String name, ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoader classLoader, ObjectMediationAliasManager aliasMgr) {
        return this.putSerializer(new XSerializer(reflectionProvider, driver, classLoader, null, aliasMgr), name);
    }

    public XSerializer createSerializer(String name, ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoader classLoader, Mapper mapper, ConverterLookup converterLookup, ConverterRegistry converterRegistry, ObjectMediationAliasManager aliasMgr) {
        return this.putSerializer(new XSerializer(reflectionProvider, driver, classLoader, mapper, converterLookup, converterRegistry, aliasMgr), name);
    }

    private synchronized XSerializer putSerializer(XSerializer serializer, String name) {
        if (JVM.is1_7()) {
            serializer.omitField(Throwable.class, "suppressedExceptions");
        }
        serializer.setName(name);
        this.serializers.put(name, serializer);
        return serializer;
    }

    @Override
    public XSerializer getDefaultSerializer() {
        return this.lookupSerializer("sys$serializer");
    }

    @Override
    public synchronized void discardSerializer(String name) throws FactoryManagerException {
        XSerializer serializer = this.serializers.remove(name);
        if (serializer == null) {
            throw new FactoryManagerException(3040, "XML serializer '" + name + "' does not exist.");
        }
        serializer.destroy();
    }

    public synchronized void registerXMLEvent(String eventId, String serializerName) throws FactoryManagerException {
        XSerializerFactory.checkContext();
        if (eventId == null || eventId.isEmpty()) {
            throw new FactoryManagerException(3004, "Event id is null or empty.");
        }
        if (serializerName == null || serializerName.isEmpty()) {
            throw new FactoryManagerException(3004, "Serializer name is null or empty.");
        }
        if (!this.serializers.containsKey(serializerName)) {
            throw new FactoryManagerException(3040, "XML serializer '" + serializerName + "' does not exist.");
        }
        if (this.xProtoRegistry.containsKey(eventId)) {
            throw new FactoryManagerException(3041, "XML Event [" + eventId + "] already registered.");
        }
        DatagramPrototypeCache prototypeCache = null;
        if (RuntimeState.isActive()) {
            prototypeCache = RuntimeContext.getInstance().getDatagramPrototypeCache();
        } else if (ClientState.isActive()) {
            prototypeCache = ClientContext.getInstance().getDatagramPrototypeCache();
        }
        if (prototypeCache != null) {
            Prototype proto = prototypeCache.lookupPrototype(eventId);
            if (proto == null) {
                throw new FactoryManagerException(5031, ErrorMessages.format("Event prototype [%1$s] already exists.", eventId));
            }
            if (!proto.getModelName().equals("XMLEvent")) {
                throw new FactoryManagerException(5029, ErrorMessages.format("Event prototype model '%1$s' is invalid.", proto.getModelName()));
            }
        }
        this.xProtoRegistry.put(eventId, serializerName);
    }

    public synchronized void unregisterXMLEvent(String eventId) throws FactoryManagerException {
        if (eventId == null || eventId.isEmpty()) {
            throw new FactoryManagerException(3004, "Event id is null or empty.");
        }
        if (!this.xProtoRegistry.containsKey(eventId)) {
            throw new FactoryManagerException(3042, "XML Event [" + eventId + "] is not registered.");
        }
        this.xProtoRegistry.remove(eventId);
    }

    public synchronized boolean isXMLEventRegistered(String eventId) {
        return this.xProtoRegistry.containsKey(eventId);
    }

    public synchronized XSerializer getXMLEventSerializer(String eventId) throws FactoryManagerException {
        if (eventId == null || eventId.isEmpty()) {
            throw new FactoryManagerException(3004, "Event id is null or empty.");
        }
        if (this.xProtoRegistry.containsKey(eventId)) {
            String serializerName = this.xProtoRegistry.get(eventId);
            if (this.serializers.containsKey(serializerName)) {
                return this.serializers.get(serializerName);
            }
            throw new FactoryManagerException(3040, "XML serializer '" + serializerName + "' does not exist.");
        }
        return this.getDefaultSerializer();
    }

    @Override
    public void alias(SemanticType type) throws FactoryManagerException {
        if (this.aliasManager != null) {
            this.aliasManager.alias(type);
        }
    }

    @Override
    public void alias(String alias, Class type) throws FactoryManagerException {
        if (this.aliasManager != null) {
            this.aliasManager.alias(alias, type);
        }
    }

    @Override
    public void aliasImmutableType(SemanticType type) throws FactoryManagerException {
        if (this.aliasManager != null) {
            this.aliasManager.aliasImmutableType(type);
        }
    }

    @Override
    public void aliasImmutableType(Class type) {
        if (this.aliasManager != null) {
            this.aliasManager.aliasImmutableType(type);
        }
    }

    @Override
    public boolean isImmutableTypeAliased(Class type) {
        return this.aliasManager != null && this.aliasManager.isImmutableTypeAliased(type);
    }

    @Override
    public void unalias(SemanticType type) throws FactoryManagerException {
        if (this.aliasManager != null) {
            this.aliasManager.unalias(type);
        }
    }

    @Override
    public void unalias(String alias) throws FactoryManagerException {
        if (this.aliasManager != null) {
            this.aliasManager.unalias(alias);
        }
    }

    @Override
    public List<String> listAliases() {
        if (this.aliasManager != null) {
            return this.aliasManager.listAliases();
        }
        return new ArrayList<String>();
    }

    @Override
    public String lookup(Class clazz) {
        if (this.aliasManager != null) {
            return this.aliasManager.lookup(clazz);
        }
        return null;
    }

    @Override
    public String lookup(String typeName) {
        if (this.aliasManager != null) {
            return this.aliasManager.lookup(typeName);
        }
        return null;
    }

    @Override
    public synchronized XSerializer lookupSerializer(String name) {
        if (this.serializers != null) {
            return this.serializers.get(name);
        }
        return null;
    }

    @Override
    public SemanticType lookupSemanticType(String aliasName) {
        if (this.aliasManager != null) {
            return this.aliasManager.lookupSemanticType(aliasName);
        }
        return null;
    }

    @Override
    public String resolveClass(String className) {
        if (this.aliasManager != null) {
            return this.aliasManager.resolveClass(className);
        }
        return null;
    }

    @Override
    public synchronized void destroy() {
        for (String serializer : new ArrayList<String>(this.serializers.keySet())) {
            try {
                this.discardSerializer(serializer);
            }
            catch (FactoryManagerException exception) {
                Trace.logException(this, exception, true);
            }
        }
        this.serializers = null;
        instance = null;
    }

    @Override
    public String getName() {
        return FACTORY_NAME;
    }

    @Override
    public synchronized List<String> listSerializers() {
        return new ArrayList<String>(this.serializers.keySet());
    }

    @Override
    public boolean isAliased(String alias) {
        return this.aliasManager != null && this.aliasManager.isAliased(alias);
    }

    @Override
    public boolean isAliased(Class type) {
        return this.aliasManager != null && this.aliasManager.isAliased(type);
    }

    @Override
    public boolean isClassAliased(String className) {
        return this.aliasManager.isClassAliased(className);
    }
}

