/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xml;

import com.streamscape.Trace;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.JVM;
import com.streamscape.omf.mf.admin.ObjectMediationAliasManager;
import com.streamscape.omf.serializer.AbstractSerializer;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.omf.serializer.TextSerializer;
import com.streamscape.omf.xml.EscapeStrategy;
import com.streamscape.omf.xml.XSerializerException;
import com.streamscape.omf.xml.xstream.InitializationException;
import com.streamscape.omf.xml.xstream.MarshallingStrategy;
import com.streamscape.omf.xml.xstream.converters.ByteArrayConverter;
import com.streamscape.omf.xml.xstream.converters.ConversionException;
import com.streamscape.omf.xml.xstream.converters.Converter;
import com.streamscape.omf.xml.xstream.converters.ConverterLookup;
import com.streamscape.omf.xml.xstream.converters.ConverterRegistry;
import com.streamscape.omf.xml.xstream.converters.DataHolder;
import com.streamscape.omf.xml.xstream.converters.SingleValueConverter;
import com.streamscape.omf.xml.xstream.converters.SingleValueConverterWrapper;
import com.streamscape.omf.xml.xstream.converters.basic.BigDecimalConverter;
import com.streamscape.omf.xml.xstream.converters.basic.BigIntegerConverter;
import com.streamscape.omf.xml.xstream.converters.basic.BooleanConverter;
import com.streamscape.omf.xml.xstream.converters.basic.ByteConverter;
import com.streamscape.omf.xml.xstream.converters.basic.CIStringConverter;
import com.streamscape.omf.xml.xstream.converters.basic.CharConverter;
import com.streamscape.omf.xml.xstream.converters.basic.DateConverter;
import com.streamscape.omf.xml.xstream.converters.basic.DoubleConverter;
import com.streamscape.omf.xml.xstream.converters.basic.FloatConverter;
import com.streamscape.omf.xml.xstream.converters.basic.IntConverter;
import com.streamscape.omf.xml.xstream.converters.basic.LongConverter;
import com.streamscape.omf.xml.xstream.converters.basic.NullConverter;
import com.streamscape.omf.xml.xstream.converters.basic.ShortConverter;
import com.streamscape.omf.xml.xstream.converters.basic.StringBufferConverter;
import com.streamscape.omf.xml.xstream.converters.basic.StringBuilderConverter;
import com.streamscape.omf.xml.xstream.converters.basic.StringConverter;
import com.streamscape.omf.xml.xstream.converters.basic.URLConverter;
import com.streamscape.omf.xml.xstream.converters.basic.UUIDConverter;
import com.streamscape.omf.xml.xstream.converters.collections.ArrayConverter;
import com.streamscape.omf.xml.xstream.converters.collections.BitSetConverter;
import com.streamscape.omf.xml.xstream.converters.collections.CharArrayConverter;
import com.streamscape.omf.xml.xstream.converters.collections.CollectionConverter;
import com.streamscape.omf.xml.xstream.converters.collections.MapConverter;
import com.streamscape.omf.xml.xstream.converters.collections.OrderedMapConverter;
import com.streamscape.omf.xml.xstream.converters.collections.PropertiesConverter;
import com.streamscape.omf.xml.xstream.converters.collections.TreeMapConverter;
import com.streamscape.omf.xml.xstream.converters.collections.TreeSetConverter;
import com.streamscape.omf.xml.xstream.converters.enums.EnumConverter;
import com.streamscape.omf.xml.xstream.converters.enums.EnumMapConverter;
import com.streamscape.omf.xml.xstream.converters.enums.EnumSetConverter;
import com.streamscape.omf.xml.xstream.converters.extended.CharsetConverter;
import com.streamscape.omf.xml.xstream.converters.extended.ColorConverter;
import com.streamscape.omf.xml.xstream.converters.extended.CurrencyConverter;
import com.streamscape.omf.xml.xstream.converters.extended.DurationConverter;
import com.streamscape.omf.xml.xstream.converters.extended.DynamicProxyConverter;
import com.streamscape.omf.xml.xstream.converters.extended.EncodedByteArrayConverter;
import com.streamscape.omf.xml.xstream.converters.extended.FileConverter;
import com.streamscape.omf.xml.xstream.converters.extended.FontConverter;
import com.streamscape.omf.xml.xstream.converters.extended.GregorianCalendarConverter;
import com.streamscape.omf.xml.xstream.converters.extended.JavaClassConverter;
import com.streamscape.omf.xml.xstream.converters.extended.JavaFieldConverter;
import com.streamscape.omf.xml.xstream.converters.extended.JavaMethodConverter;
import com.streamscape.omf.xml.xstream.converters.extended.LocaleConverter;
import com.streamscape.omf.xml.xstream.converters.extended.LookAndFeelConverter;
import com.streamscape.omf.xml.xstream.converters.extended.RegexPatternConverter;
import com.streamscape.omf.xml.xstream.converters.extended.SqlDateConverter;
import com.streamscape.omf.xml.xstream.converters.extended.SqlTimeConverter;
import com.streamscape.omf.xml.xstream.converters.extended.SqlTimestampConverter;
import com.streamscape.omf.xml.xstream.converters.extended.StackTraceElementConverter;
import com.streamscape.omf.xml.xstream.converters.extended.SubjectConverter;
import com.streamscape.omf.xml.xstream.converters.extended.TextAttributeConverter;
import com.streamscape.omf.xml.xstream.converters.extended.ThrowableConverter;
import com.streamscape.omf.xml.xstream.converters.extended.XMLGregorianCalendarConverter;
import com.streamscape.omf.xml.xstream.converters.reflection.ExternalizableConverter;
import com.streamscape.omf.xml.xstream.converters.reflection.FabricDefaultsProvider;
import com.streamscape.omf.xml.xstream.converters.reflection.FabricReflectionConverter;
import com.streamscape.omf.xml.xstream.converters.reflection.ReflectionConverter;
import com.streamscape.omf.xml.xstream.converters.reflection.ReflectionProvider;
import com.streamscape.omf.xml.xstream.converters.reflection.SelfStreamingInstanceChecker;
import com.streamscape.omf.xml.xstream.converters.reflection.SerializableConverter;
import com.streamscape.omf.xml.xstream.core.DefaultConverterLookup;
import com.streamscape.omf.xml.xstream.core.MapBackedDataHolder;
import com.streamscape.omf.xml.xstream.core.ReferenceByIdMarshallingStrategy;
import com.streamscape.omf.xml.xstream.core.ReferenceByXPathMarshallingStrategy;
import com.streamscape.omf.xml.xstream.core.TreeMarshallingStrategy;
import com.streamscape.omf.xml.xstream.core.util.CustomObjectInputStream;
import com.streamscape.omf.xml.xstream.core.util.CustomObjectOutputStream;
import com.streamscape.omf.xml.xstream.io.HierarchicalStreamDriver;
import com.streamscape.omf.xml.xstream.io.HierarchicalStreamReader;
import com.streamscape.omf.xml.xstream.io.HierarchicalStreamWriter;
import com.streamscape.omf.xml.xstream.io.StatefulWriter;
import com.streamscape.omf.xml.xstream.io.StreamException;
import com.streamscape.omf.xml.xstream.io.xml.StaxDriver;
import com.streamscape.omf.xml.xstream.io.xml.XmlFriendlyNameCoder;
import com.streamscape.omf.xml.xstream.io.xml.XppDriver;
import com.streamscape.omf.xml.xstream.mapper.AnnotationConfiguration;
import com.streamscape.omf.xml.xstream.mapper.AnnotationMapper;
import com.streamscape.omf.xml.xstream.mapper.ArrayMapper;
import com.streamscape.omf.xml.xstream.mapper.AttributeAliasingMapper;
import com.streamscape.omf.xml.xstream.mapper.AttributeMapper;
import com.streamscape.omf.xml.xstream.mapper.ClassAliasingMapper;
import com.streamscape.omf.xml.xstream.mapper.DefaultImplementationsMapper;
import com.streamscape.omf.xml.xstream.mapper.DefaultMapper;
import com.streamscape.omf.xml.xstream.mapper.DynamicProxyMapper;
import com.streamscape.omf.xml.xstream.mapper.EnumMapper;
import com.streamscape.omf.xml.xstream.mapper.FieldAliasingMapper;
import com.streamscape.omf.xml.xstream.mapper.ImmutableTypesMapper;
import com.streamscape.omf.xml.xstream.mapper.ImplicitCollectionMapper;
import com.streamscape.omf.xml.xstream.mapper.LocalConversionMapper;
import com.streamscape.omf.xml.xstream.mapper.Mapper;
import com.streamscape.omf.xml.xstream.mapper.MapperWrapper;
import com.streamscape.omf.xml.xstream.mapper.OuterClassMapper;
import com.streamscape.omf.xml.xstream.mapper.PackageAliasingMapper;
import com.streamscape.omf.xml.xstream.mapper.SystemAttributeAliasingMapper;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sef.moderator.FabricNodeRoleConverter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class XSerializer
extends AbstractSerializer
implements TextSerializer {
    public static final String XML_HEADER = "<?xml version=\"1.0\"?>";
    private ReflectionProvider reflectionProvider;
    private HierarchicalStreamDriver hierarchicalStreamDriver;
    private MarshallingStrategy marshallingStrategy;
    private ConverterLookup converterLookup;
    private ConverterRegistry converterRegistry;
    private Mapper serializerMapper;
    private PackageAliasingMapper packageAliasingMapper;
    private ClassAliasingMapper classAliasingMapper;
    private FieldAliasingMapper fieldAliasingMapper;
    private AttributeAliasingMapper attributeAliasingMapper;
    private SystemAttributeAliasingMapper systemAttributeAliasingMapper;
    private AttributeMapper attributeMapper;
    private DefaultImplementationsMapper defaultImplementationsMapper;
    private ImmutableTypesMapper immutableTypesMapper;
    private ImplicitCollectionMapper implicitCollectionMapper;
    private LocalConversionMapper localConversionMapper;
    private AnnotationConfiguration annotationConfiguration;
    private transient JVM jvm = new JVM();
    private String name = "xser";
    private transient FabricReflectionConverter fabricConverter = null;
    private transient FabricDefaultsProvider defaultsProvider = new FabricDefaultsProvider();
    private transient boolean xfragmentWriter = false;
    private EscapeStrategy escapeStrategy = EscapeStrategy.ESCAPE_SYSTEM;
    public static final int NO_REFERENCES = 1001;
    public static final int ID_REFERENCES = 1002;
    public static final int XPATH_RELATIVE_REFERENCES = 1003;
    public static final int XPATH_ABSOLUTE_REFERENCES = 1004;
    public static final int SINGLE_NODE_XPATH_RELATIVE_REFERENCES = 1005;
    public static final int SINGLE_NODE_XPATH_ABSOLUTE_REFERENCES = 1006;
    public static final int PRIORITY_VERY_HIGH = 10000;
    public static final int PRIORITY_NORMAL = 0;
    public static final int PRIORITY_LOW = -10;
    public static final int PRIORITY_VERY_LOW = -20;
    private static final String ANNOTATION_MAPPER_TYPE = AnnotationMapper.class.getName();

    protected XSerializer() {
        this(null, new XppDriver(), null);
    }

    protected XSerializer(XmlFriendlyNameCoder encoder, ClassLoader classLoader, ObjectMediationAliasManager aliasManager) {
        this(null, encoder == null ? new XppDriver() : new XppDriver(encoder), classLoader, null, aliasManager);
    }

    protected XSerializer(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ObjectMediationAliasManager aliasManager) {
        this(reflectionProvider, driver, null, null, aliasManager);
    }

    protected XSerializer(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoader classLoader, ObjectMediationAliasManager aliasManager) {
        this(reflectionProvider, driver, classLoader, null, aliasManager);
    }

    protected XSerializer(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoader classLoader, Mapper mapper, ObjectMediationAliasManager aliasManager) {
        this(reflectionProvider, driver, classLoader, mapper, new DefaultConverterLookup(), null, aliasManager);
    }

    protected XSerializer(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoader classLoader, Mapper mapper, ConverterLookup converterLookup, ConverterRegistry converterRegistry, ObjectMediationAliasManager aliasManager) {
        super(aliasManager);
        this.setClassLoader(classLoader);
        this.jvm = new JVM();
        if (reflectionProvider == null) {
            reflectionProvider = this.jvm.bestReflectionProvider();
        }
        this.reflectionProvider = reflectionProvider;
        this.hierarchicalStreamDriver = driver;
        this.converterLookup = converterLookup;
        this.converterRegistry = converterRegistry != null ? converterRegistry : (converterLookup instanceof ConverterRegistry ? (ConverterRegistry)((Object)converterLookup) : null);
        this.serializerMapper = mapper == null ? this.buildMapper() : mapper;
        this.setupMappers();
        this.setupDefaultImplementations();
        this.setupConverters();
        this.setupImmutableTypes();
        this.setMode(1003);
        this.fabricConverter = new FabricReflectionConverter(this.getMapper(), this.getReflectionProvider(), this.defaultsProvider, this.getConverterLookup());
        this.fabricConverter.setProcessSerializableAndExternalizable(false);
        this.registerConverter(this.fabricConverter, -9);
        this.registerConverter(new ByteArrayConverter(), 1);
    }

    public boolean isEnforcedXSerializer() {
        return this.fabricConverter.isProcessSerializableAndExternalizable();
    }

    public void setEnforceXSerializer(boolean enforce) {
        this.fabricConverter.setProcessSerializableAndExternalizable(enforce);
    }

    public void setXFragment(boolean fragment) {
        this.xfragmentWriter = fragment;
    }

    public boolean isXFragment() {
        return this.xfragmentWriter;
    }

    public FabricDefaultsProvider getDefaultsProvider() {
        return this.defaultsProvider;
    }

    protected void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object deserialize(DataInputStream buffer) throws SerializerException {
        return this.deserialize(new InputStreamReader(buffer));
    }

    @Override
    public Object deserialize(String semanticType, DataInputStream buffer) throws SerializerException {
        return this.deserialize(semanticType, new InputStreamReader(buffer));
    }

    @Override
    public Object deserialize(byte[] buffer) throws SerializerException {
        if (buffer == null || buffer.length == 0) {
            throw new XSerializerException(3004, "Object buffer is null or empty.");
        }
        return this.deserialize(new String(buffer));
    }

    public void addFieldAliases(String typeName) {
        try {
            SemanticType rootType = this.aliasManager.lookupSemanticType(typeName);
            if (this.isAnnotated(ClassUtils.loadClass(rootType.getClassName(), this.getClassLoader()))) {
                return;
            }
            LinkedList<String> deps = new LinkedList<String>();
            deps.add(typeName);
            deps.addAll(this.aliasManager.listComponentSemanticTypes(typeName));
            LinkedList<Class> cls = new LinkedList<Class>();
            if (deps != null) {
                for (String dep : deps) {
                    SemanticType type = this.aliasManager.lookupSemanticType(dep);
                    if (type.isSystem()) continue;
                    cls.add(ClassUtils.loadClass(type.getClassName(), this.getClassLoader()));
                }
                this.processAnnotations(cls.toArray(new Class[0]));
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Processing of aliases for '" + typeName + "' type failed.");
        }
    }

    public Object deserialize(String semanticType, byte[] buffer, boolean useAliases) throws SerializerException {
        if (useAliases) {
            this.addFieldAliases(semanticType);
        }
        return this.deserialize(semanticType, new String(buffer));
    }

    @Override
    public Object deserialize(String semanticType, byte[] buffer) throws SerializerException {
        if (buffer == null || buffer.length == 0) {
            throw new XSerializerException(3004, "Object buffer is null or empty.");
        }
        return this.deserialize(semanticType, new String(buffer));
    }

    @Override
    public Object deserialize(Reader reader) throws SerializerException {
        return this.doDeserialize(null, reader);
    }

    @Override
    public <T> T deserialize(Class<T> objectClass, String buffer) throws SerializerException {
        SemanticType semanticType = this.lookupSemanticClass(objectClass);
        if (semanticType == null) {
            throw new XSerializerException(3027, "Class " + String.valueOf(objectClass) + " not aliased.");
        }
        return (T)this.deserialize(semanticType.getTypeName(), buffer);
    }

    @Override
    public Object deserialize(String semanticType, Reader reader) throws SerializerException {
        return this.doDeserialize(semanticType, reader);
    }

    @Override
    public Object deserialize(String buffer) throws SerializerException {
        if (buffer == null || buffer.length() == 0) {
            throw new XSerializerException(3004, "Object buffer is null or empty.");
        }
        return this.doDeserialize(null, new StringReader(buffer));
    }

    public Object deserialize(String semanticType, String buffer, boolean useAliases) throws SerializerException {
        if (useAliases) {
            this.addFieldAliases(semanticType);
        }
        return this.doDeserialize(semanticType, new StringReader(buffer));
    }

    @Override
    public Object deserialize(String semanticType, String buffer) throws SerializerException {
        if (buffer == null || buffer.length() == 0) {
            throw new XSerializerException(3004, "Object buffer is null or empty.");
        }
        return this.doDeserialize(semanticType, new StringReader(buffer));
    }

    private Object doDeserialize(String semanticType, Reader reader) throws SerializerException {
        SemanticType type = null;
        if (semanticType != null) {
            type = this.getSemanticType(semanticType);
        }
        try {
            Object obj = this.fromXML(reader);
            if (type != null) {
                this.checkSemanticTypeMatch(type, obj, "deserializing");
            } else if (!(this.hierarchicalStreamDriver instanceof StaxDriver)) {
                this.checkSemanticType(obj);
            }
            return obj;
        }
        catch (ConversionException exception) {
            throw new XSerializerException(3015, "Resolving of element '" + exception.get("path") + "' failed.", exception);
        }
        catch (StreamException exception) {
            throw new XSerializerException(3015, (Throwable)exception);
        }
    }

    @Override
    public String serialize(String semanticType, Object obj) throws SerializerException {
        if (semanticType == null || semanticType.length() == 0) {
            throw new XSerializerException(3004, "Semantic type is null or empty.");
        }
        return this.doSerialize(semanticType, obj);
    }

    @Override
    public String serialize(Object obj) throws SerializerException {
        return this.doSerialize(null, obj);
    }

    @Override
    public void serialize(String semanticType, Object obj, Writer writer) throws SerializerException {
        if (semanticType == null || semanticType.length() == 0) {
            throw new XSerializerException(3004, "Semantic type is null or empty.");
        }
        this.doSerialize(null, obj, writer);
    }

    @Override
    public void serialize(Object obj, Writer writer) throws SerializerException {
        this.doSerialize(null, obj, writer);
    }

    @Override
    public void serialize(Object obj, DataOutputStream buffer) throws SerializerException {
        this.serialize(obj, new OutputStreamWriter(buffer));
    }

    @Override
    public void serialize(String semanticType, Object obj, DataOutputStream buffer) throws SerializerException {
        this.serialize(semanticType, obj, new OutputStreamWriter(buffer));
    }

    public String serializeAtRoot(Object obj, String xmlRoot) throws XSerializerException {
        if (obj == null) {
            return "<XFactoryError>Object is NULL.</XFactoryError>";
        }
        if (xmlRoot == null) {
            return "<XFactoryError>XML Root is NULL.</XFactoryError>";
        }
        try {
            return this.toXML(obj);
        }
        catch (Exception exception) {
            throw new XSerializerException(3014, (Throwable)exception);
        }
    }

    private String doSerialize(String semanticType, Object obj) throws SerializerException {
        StringWriter writer = new StringWriter();
        this.doSerialize(semanticType, obj, writer);
        return ((Object)writer).toString();
    }

    private void doSerialize(String semanticType, Object obj, Writer writer) throws SerializerException {
        if (obj == null) {
            throw new XSerializerException(3003, "Object is null.");
        }
        if (semanticType != null) {
            this.checkSemanticTypeMatch(this.getSemanticType(semanticType), obj, "serializing");
        } else if (!(this.hierarchicalStreamDriver instanceof StaxDriver)) {
            this.checkSemanticType(obj);
        }
        try {
            if (!this.xfragmentWriter) {
                writer.write("<?xml version=\"1.0\"?>\n");
            }
            this.toXML(obj, writer);
            writer.flush();
        }
        catch (ConversionException exception) {
            throw new XSerializerException(3014, "Resolving of element '" + exception.get("path") + "' failed.", exception);
        }
        catch (Exception exception) {
            throw new XSerializerException(3014, (Throwable)exception);
        }
    }

    private Mapper buildMapper() {
        Mapper mapper = new DefaultMapper(this.classLoader);
        mapper = new DynamicProxyMapper(mapper);
        mapper = new PackageAliasingMapper(mapper);
        mapper = new ClassAliasingMapper(mapper, this.aliasManager);
        mapper = new FieldAliasingMapper(mapper);
        mapper = new AttributeAliasingMapper(mapper);
        mapper = new SystemAttributeAliasingMapper(mapper);
        mapper = new ImplicitCollectionMapper(mapper);
        mapper = new OuterClassMapper(mapper);
        mapper = new ArrayMapper(mapper);
        mapper = new DefaultImplementationsMapper(mapper);
        mapper = new AttributeMapper(mapper, this.converterLookup);
        if (JVM.is1_5()) {
            mapper = this.buildMapperDynamically(EnumMapper.class.getName(), new Class[]{Mapper.class}, new Object[]{mapper});
        }
        mapper = new LocalConversionMapper(mapper);
        mapper = new ImmutableTypesMapper(mapper, this.aliasManager);
        if (JVM.is1_5()) {
            mapper = this.buildMapperDynamically(ANNOTATION_MAPPER_TYPE, new Class[]{Mapper.class, ConverterRegistry.class, ClassLoader.class, ReflectionProvider.class, JVM.class}, new Object[]{mapper, this.converterLookup, this.classLoader, this.reflectionProvider, this.jvm});
        }
        mapper = this.wrapMapper((MapperWrapper)mapper);
        return mapper;
    }

    private Mapper buildMapperDynamically(String className, Class[] constructorParamTypes, Object[] constructorParamValues) {
        try {
            Class type = ClassUtils.loadClass(className, this.classLoader);
            Constructor constructor = type.getConstructor(constructorParamTypes);
            return (Mapper)constructor.newInstance(constructorParamValues);
        }
        catch (Exception exception) {
            throw new InitializationException("Could not instantiate mapper '" + className + "'.", exception);
        }
    }

    protected MapperWrapper wrapMapper(MapperWrapper next) {
        return next;
    }

    private void setupMappers() {
        this.packageAliasingMapper = (PackageAliasingMapper)this.serializerMapper.lookupMapperOfType(PackageAliasingMapper.class);
        this.classAliasingMapper = (ClassAliasingMapper)this.serializerMapper.lookupMapperOfType(ClassAliasingMapper.class);
        this.fieldAliasingMapper = (FieldAliasingMapper)this.serializerMapper.lookupMapperOfType(FieldAliasingMapper.class);
        this.attributeMapper = (AttributeMapper)this.serializerMapper.lookupMapperOfType(AttributeMapper.class);
        this.attributeAliasingMapper = (AttributeAliasingMapper)this.serializerMapper.lookupMapperOfType(AttributeAliasingMapper.class);
        this.systemAttributeAliasingMapper = (SystemAttributeAliasingMapper)this.serializerMapper.lookupMapperOfType(SystemAttributeAliasingMapper.class);
        this.implicitCollectionMapper = (ImplicitCollectionMapper)this.serializerMapper.lookupMapperOfType(ImplicitCollectionMapper.class);
        this.defaultImplementationsMapper = (DefaultImplementationsMapper)this.serializerMapper.lookupMapperOfType(DefaultImplementationsMapper.class);
        this.immutableTypesMapper = (ImmutableTypesMapper)this.serializerMapper.lookupMapperOfType(ImmutableTypesMapper.class);
        this.localConversionMapper = (LocalConversionMapper)this.serializerMapper.lookupMapperOfType(LocalConversionMapper.class);
        this.annotationConfiguration = (AnnotationConfiguration)((Object)this.serializerMapper.lookupMapperOfType(AnnotationConfiguration.class));
    }

    protected void setupDefaultImplementations() {
        if (this.defaultImplementationsMapper == null) {
            return;
        }
        this.addDefaultImplementationDeserializationOnly(HashMap.class, Map.class);
        this.addDefaultImplementationDeserializationOnly(ArrayList.class, List.class);
        this.addDefaultImplementationDeserializationOnly(HashSet.class, Set.class);
        this.addDefaultImplementation(GregorianCalendar.class, Calendar.class);
    }

    protected void setupConverters() {
        ReflectionConverter reflectionConverter = new ReflectionConverter(this.serializerMapper, this.reflectionProvider);
        this.registerConverter(reflectionConverter, -20);
        this.registerConverter(new SerializableConverter(this.serializerMapper, this.reflectionProvider), -10);
        this.registerConverter(new ExternalizableConverter(this.serializerMapper), -10);
        this.registerConverter(new NullConverter(), 10000);
        this.registerConverter(new IntConverter(), 0);
        this.registerConverter(new FloatConverter(), 0);
        this.registerConverter(new DoubleConverter(), 0);
        this.registerConverter(new LongConverter(), 0);
        this.registerConverter(new ShortConverter(), 0);
        this.registerConverter(new CharConverter(), 0);
        this.registerConverter(new BooleanConverter(), 0);
        this.registerConverter(new ByteConverter(), 0);
        this.registerConverter(new StringConverter(), 0);
        this.registerConverter(new StringBufferConverter(), 0);
        this.registerConverter(new DateConverter(), 0);
        this.registerConverter(new BitSetConverter(), 0);
        this.registerConverter(new URLConverter(), 0);
        this.registerConverter(new BigIntegerConverter(), 0);
        this.registerConverter(new BigDecimalConverter(), 0);
        this.registerConverter(new ArrayConverter(this.serializerMapper), 0);
        this.registerConverter(new CharArrayConverter(), 0);
        this.registerConverter(new CollectionConverter(this.serializerMapper), 0);
        this.registerConverter(new MapConverter(this.serializerMapper), 0);
        this.registerConverter(new TreeMapConverter(this.serializerMapper), 0);
        this.registerConverter(new OrderedMapConverter(this.serializerMapper), 0);
        this.registerConverter(new TreeSetConverter(this.serializerMapper), 0);
        this.registerConverter(new PropertiesConverter(), 0);
        this.registerConverter(new EncodedByteArrayConverter(), 0);
        this.registerConverter(new FileConverter(), 0);
        this.registerConverter(new CIStringConverter(), 0);
        this.registerConverter(new FabricNodeRoleConverter(), 0);
        if (this.jvm.supportsSQL()) {
            this.registerConverter(new SqlTimestampConverter(), 0);
            this.registerConverter(new SqlTimeConverter(), 0);
            this.registerConverter(new SqlDateConverter(), 0);
        }
        this.registerConverter(new DynamicProxyConverter(this.serializerMapper, this.classLoader), 0);
        this.registerConverter(new JavaClassConverter(this.classLoader), 0);
        this.registerConverter(new JavaMethodConverter(this.classLoader), 0);
        this.registerConverter(new JavaFieldConverter(this.classLoader), 0);
        if (this.jvm.supportsAWT()) {
            this.registerConverter(new FontConverter(), 0);
            this.registerConverter(new ColorConverter(), 0);
            this.registerConverter(new TextAttributeConverter(), 0);
        }
        if (this.jvm.supportsSwing()) {
            this.registerConverter(new LookAndFeelConverter(this.serializerMapper, this.reflectionProvider), 0);
        }
        this.registerConverter(new LocaleConverter(), 0);
        this.registerConverter(new GregorianCalendarConverter(), 0);
        this.registerConverter(new XMLGregorianCalendarConverter(), 0);
        if (JVM.is1_4()) {
            this.dynamicallyRegisterConverter(SubjectConverter.class.getName(), 0, new Class[]{Mapper.class}, new Object[]{this.serializerMapper});
            this.dynamicallyRegisterConverter(ThrowableConverter.class.getName(), 0, new Class[]{Converter.class}, new Object[]{reflectionConverter});
            this.dynamicallyRegisterConverter(StackTraceElementConverter.class.getName(), 0, null, null);
            this.dynamicallyRegisterConverter(CurrencyConverter.class.getName(), 0, null, null);
            this.dynamicallyRegisterConverter(RegexPatternConverter.class.getName(), 0, new Class[]{Converter.class}, new Object[]{reflectionConverter});
            this.dynamicallyRegisterConverter(CharsetConverter.class.getName(), 0, null, null);
        }
        if (JVM.is1_5()) {
            this.dynamicallyRegisterConverter(DurationConverter.class.getName(), 0, null, null);
            this.dynamicallyRegisterConverter(EnumConverter.class.getName(), -10, null, null);
            this.dynamicallyRegisterConverter(EnumSetConverter.class.getName(), 0, new Class[]{Mapper.class}, new Object[]{this.serializerMapper});
            this.dynamicallyRegisterConverter(EnumMapConverter.class.getName(), 0, new Class[]{Mapper.class}, new Object[]{this.serializerMapper});
            this.dynamicallyRegisterConverter(StringBuilderConverter.class.getName(), 0, null, null);
            this.dynamicallyRegisterConverter(UUIDConverter.class.getName(), 0, null, null);
        }
        this.registerConverter(new SelfStreamingInstanceChecker(reflectionConverter, this), 0);
    }

    private void dynamicallyRegisterConverter(String className, int priority, Class[] constructorParamTypes, Object[] constructorParamValues) {
        try {
            Class type = ClassUtils.loadClass(className, this.classLoader);
            Constructor constructor = type.getConstructor(constructorParamTypes);
            Object instance = constructor.newInstance(constructorParamValues);
            if (instance instanceof Converter) {
                this.registerConverter((Converter)instance, priority);
            } else if (instance instanceof SingleValueConverter) {
                this.registerConverter((SingleValueConverter)instance, priority);
            }
        }
        catch (Exception exception) {
            throw new InitializationException("Could not instantiate converter '" + className + "'.", exception);
        }
    }

    protected void setupImmutableTypes() {
        if (this.immutableTypesMapper == null) {
            return;
        }
        this.aliasImmutableType(Boolean.TYPE);
        this.aliasImmutableType(Boolean.class);
        this.aliasImmutableType(Byte.TYPE);
        this.aliasImmutableType(Byte.class);
        this.aliasImmutableType(Character.TYPE);
        this.aliasImmutableType(Character.class);
        this.aliasImmutableType(Double.TYPE);
        this.aliasImmutableType(Double.class);
        this.aliasImmutableType(Float.TYPE);
        this.aliasImmutableType(Float.class);
        this.aliasImmutableType(Integer.TYPE);
        this.aliasImmutableType(Integer.class);
        this.aliasImmutableType(Long.TYPE);
        this.aliasImmutableType(Long.class);
        this.aliasImmutableType(Short.TYPE);
        this.aliasImmutableType(Short.class);
        this.aliasImmutableType(Mapper.Null.class);
        this.aliasImmutableType(BigDecimal.class);
        this.aliasImmutableType(BigInteger.class);
        this.aliasImmutableType(String.class);
        this.aliasImmutableType(URL.class);
        this.aliasImmutableType(File.class);
        this.aliasImmutableType(Class.class);
        if (this.jvm.supportsAWT()) {
            this.aliasImmutableType(this.jvm.loadClass("java.awt.font.TextAttribute"));
        }
        if (JVM.is1_4()) {
            Class type = this.jvm.loadClass(CharsetConverter.class.getName());
            this.aliasImmutableType(type);
        }
    }

    public void setMarshallingStrategy(MarshallingStrategy marshallingStrategy) {
        this.marshallingStrategy = marshallingStrategy;
    }

    protected String toXML(Object obj) {
        StringWriter writer = new StringWriter();
        this.toXML(obj, writer);
        return ((Object)writer).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void toXML(Object obj, Writer out) {
        HierarchicalStreamWriter writer = this.hierarchicalStreamDriver.createWriter(out);
        writer.setEscapeStrategy(this.escapeStrategy);
        try {
            this.marshal(obj, writer);
        }
        finally {
            writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void toXML(Object obj, OutputStream out) {
        HierarchicalStreamWriter writer = this.hierarchicalStreamDriver.createWriter(out);
        writer.setEscapeStrategy(this.escapeStrategy);
        try {
            this.marshal(obj, writer);
        }
        finally {
            writer.flush();
        }
    }

    public void marshal(Object obj, HierarchicalStreamWriter writer) {
        this.marshal(obj, writer, null);
    }

    protected void marshal(Object obj, HierarchicalStreamWriter writer, DataHolder dataHolder) {
        this.marshallingStrategy.marshal(writer, obj, this.converterLookup, this.serializerMapper, dataHolder);
    }

    protected Object fromXML(String xml) {
        return this.fromXML(new StringReader(xml));
    }

    protected Object fromXML(Reader xml) {
        return this.unmarshal(this.hierarchicalStreamDriver.createReader(xml), null);
    }

    public HierarchicalStreamReader createReader(Reader xml) {
        return this.hierarchicalStreamDriver.createReader(xml);
    }

    protected Object fromXML(InputStream input) {
        return this.unmarshal(this.hierarchicalStreamDriver.createReader(input), null);
    }

    protected Object fromXML(String xml, Object root) {
        return this.fromXML(new StringReader(xml), root);
    }

    protected Object fromXML(Reader xml, Object root) {
        return this.unmarshal(this.hierarchicalStreamDriver.createReader(xml), root);
    }

    protected Object fromXML(InputStream xml, Object root) {
        return this.unmarshal(this.hierarchicalStreamDriver.createReader(xml), root);
    }

    public Object unmarshal(HierarchicalStreamReader reader) {
        return this.unmarshal(reader, null, null);
    }

    protected Object unmarshal(HierarchicalStreamReader reader, Object root) {
        return this.unmarshal(reader, root, null);
    }

    protected Object unmarshal(HierarchicalStreamReader reader, Object root, DataHolder dataHolder) {
        return this.marshallingStrategy.unmarshal(root, reader, dataHolder, this.converterLookup, this.serializerMapper);
    }

    public void alias(String name, Class type) {
        if (this.classAliasingMapper == null) {
            throw new InitializationException("No " + ClassAliasingMapper.class.getName() + " available");
        }
        this.classAliasingMapper.addClassAlias(name, type);
    }

    public void mapFieldToElement(String alias, Class definedIn, String fieldName) {
        if (this.fieldAliasingMapper == null) {
            throw new InitializationException("No " + FieldAliasingMapper.class.getName() + " available");
        }
        this.fieldAliasingMapper.addFieldAlias(alias, definedIn, fieldName);
    }

    public void mapAttribute(String alias, String attributeName) {
        if (this.attributeAliasingMapper == null) {
            throw new InitializationException("No " + AttributeAliasingMapper.class.getName() + " available");
        }
        this.attributeAliasingMapper.addAliasFor(attributeName, alias);
    }

    public void mapAttribute(Class definedIn, String attributeName, String alias) {
        this.mapFieldToElement(alias, definedIn, attributeName);
        this.useAttributeFor(definedIn, attributeName);
    }

    public void useAttributeFor(String fieldName, Class type) {
        if (this.attributeMapper == null) {
            throw new InitializationException("No " + AttributeMapper.class.getName() + " available");
        }
        this.attributeMapper.addAttributeFor(fieldName, type);
    }

    public void useAttributeFor(Class definedIn, String fieldName) {
        if (this.attributeMapper == null) {
            throw new InitializationException("No " + AttributeMapper.class.getName() + " available");
        }
        this.attributeMapper.addAttributeFor(definedIn, fieldName);
    }

    public void useAttributeFor(Class type) {
        if (this.attributeMapper == null) {
            throw new InitializationException("No " + AttributeMapper.class.getName() + " available");
        }
        this.attributeMapper.addAttributeFor(type);
    }

    public void addDefaultImplementation(Class defaultImplementation, Class ofType) {
        if (this.defaultImplementationsMapper == null) {
            throw new InitializationException("No " + DefaultImplementationsMapper.class.getName() + " available");
        }
        this.defaultImplementationsMapper.addDefaultImplementation(defaultImplementation, ofType);
    }

    public void addDefaultImplementationDeserializationOnly(Class defaultImplementation, Class ofType) {
        if (this.defaultImplementationsMapper == null) {
            throw new InitializationException("No " + DefaultImplementationsMapper.class.getName() + " available");
        }
        this.defaultImplementationsMapper.addDefaultImplementationDeserializationOnly(defaultImplementation, ofType);
    }

    protected void aliasImmutableType(Class type) {
        if (this.immutableTypesMapper == null) {
            throw new InitializationException("No " + ImmutableTypesMapper.class.getName() + " available.");
        }
        this.immutableTypesMapper.aliasImmutableType(type);
    }

    public void registerConverter(Converter converter) {
        this.registerConverter(converter, 0);
    }

    public void registerConverter(Converter converter, int priority) {
        if (this.converterRegistry != null) {
            this.converterRegistry.registerConverter(converter, priority);
        }
    }

    public void registerConverter(SingleValueConverter converter) {
        this.registerConverter(converter, 0);
    }

    public void registerConverter(SingleValueConverter converter, int priority) {
        if (this.converterRegistry != null) {
            this.converterRegistry.registerConverter(new SingleValueConverterWrapper(converter), priority);
        }
    }

    public void addClassElementConverter(Class definedIn, String fieldName, Converter converter) {
        if (this.localConversionMapper == null) {
            throw new InitializationException("No " + LocalConversionMapper.class.getName() + " available");
        }
        this.localConversionMapper.registerLocalConverter(definedIn, fieldName, converter);
    }

    public void addClassElementConverter(Class definedIn, String fieldName, SingleValueConverter converter) {
        this.addClassElementConverter(definedIn, fieldName, new SingleValueConverterWrapper(converter));
    }

    public Mapper getMapper() {
        return this.serializerMapper;
    }

    public ReflectionProvider getReflectionProvider() {
        return this.reflectionProvider;
    }

    public ConverterLookup getConverterLookup() {
        return this.converterLookup;
    }

    public void setMode(int mode) {
        switch (mode) {
            case 1001: {
                this.setMarshallingStrategy(new TreeMarshallingStrategy());
                break;
            }
            case 1002: {
                this.setMarshallingStrategy(new ReferenceByIdMarshallingStrategy());
                break;
            }
            case 1003: {
                this.setMarshallingStrategy(new ReferenceByXPathMarshallingStrategy(ReferenceByXPathMarshallingStrategy.RELATIVE));
                break;
            }
            case 1004: {
                this.setMarshallingStrategy(new ReferenceByXPathMarshallingStrategy(ReferenceByXPathMarshallingStrategy.ABSOLUTE));
                break;
            }
            case 1005: {
                this.setMarshallingStrategy(new ReferenceByXPathMarshallingStrategy(ReferenceByXPathMarshallingStrategy.RELATIVE | ReferenceByXPathMarshallingStrategy.SINGLE_NODE));
                break;
            }
            case 1006: {
                this.setMarshallingStrategy(new ReferenceByXPathMarshallingStrategy(ReferenceByXPathMarshallingStrategy.ABSOLUTE | ReferenceByXPathMarshallingStrategy.SINGLE_NODE));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode : " + mode);
            }
        }
    }

    public void setEscapeStrategy(EscapeStrategy strategy) {
        this.escapeStrategy = strategy;
    }

    public void addImplicitCollection(Class ownerType, String fieldName) {
        if (this.implicitCollectionMapper == null) {
            throw new InitializationException("No " + ImplicitCollectionMapper.class.getName() + " available");
        }
        this.implicitCollectionMapper.add(ownerType, fieldName, null, null);
    }

    public void addImplicitCollection(Class ownerType, String fieldName, Class itemType) {
        if (this.implicitCollectionMapper == null) {
            throw new InitializationException("No " + ImplicitCollectionMapper.class.getName() + " available");
        }
        this.implicitCollectionMapper.add(ownerType, fieldName, null, itemType);
    }

    public void addImplicitCollection(Class ownerType, String fieldName, String itemFieldName, Class itemType) {
        if (this.implicitCollectionMapper == null) {
            throw new InitializationException("No " + ImplicitCollectionMapper.class.getName() + " available");
        }
        this.implicitCollectionMapper.add(ownerType, fieldName, itemFieldName, itemType);
    }

    protected DataHolder newDataHolder() {
        return new MapBackedDataHolder();
    }

    protected ObjectOutputStream createObjectOutputStream(Writer writer) throws IOException {
        return this.createObjectOutputStream(this.hierarchicalStreamDriver.createWriter(writer), "object-stream");
    }

    protected ObjectOutputStream createObjectOutputStream(HierarchicalStreamWriter writer) throws IOException {
        return this.createObjectOutputStream(writer, "object-stream");
    }

    protected ObjectOutputStream createObjectOutputStream(Writer writer, String rootNodeName) throws IOException {
        return this.createObjectOutputStream(this.hierarchicalStreamDriver.createWriter(writer), rootNodeName);
    }

    protected ObjectOutputStream createObjectOutputStream(OutputStream out) throws IOException {
        return this.createObjectOutputStream(this.hierarchicalStreamDriver.createWriter(out), "object-stream");
    }

    protected ObjectOutputStream createObjectOutputStream(OutputStream out, String rootNodeName) throws IOException {
        return this.createObjectOutputStream(this.hierarchicalStreamDriver.createWriter(out), rootNodeName);
    }

    protected ObjectOutputStream createObjectOutputStream(HierarchicalStreamWriter writer, String rootNodeName) throws IOException {
        final StatefulWriter statefulWriter = new StatefulWriter(writer);
        statefulWriter.startNode(rootNodeName, null);
        return new CustomObjectOutputStream(new CustomObjectOutputStream.StreamCallback(){

            @Override
            public void writeToStream(Object object) {
                XSerializer.this.marshal(object, statefulWriter);
            }

            @Override
            public void writeFieldsToStream(Map fields) throws NotActiveException {
                throw new NotActiveException("not in call to writeObject");
            }

            @Override
            public void defaultWriteObject() throws NotActiveException {
                throw new NotActiveException("not in call to writeObject");
            }

            @Override
            public void flush() {
                statefulWriter.flush();
            }

            @Override
            public void close() {
                if (statefulWriter.state() != StatefulWriter.STATE_CLOSED) {
                    statefulWriter.endNode();
                    statefulWriter.close();
                }
            }
        });
    }

    protected ObjectInputStream createObjectInputStream(Reader xmlReader) throws IOException {
        return this.createObjectInputStream(this.hierarchicalStreamDriver.createReader(xmlReader));
    }

    protected ObjectInputStream createObjectInputStream(InputStream in) throws IOException {
        return this.createObjectInputStream(this.hierarchicalStreamDriver.createReader(in));
    }

    protected ObjectInputStream createObjectInputStream(final HierarchicalStreamReader reader) throws IOException {
        return new CustomObjectInputStream(new CustomObjectInputStream.StreamCallback(){

            @Override
            public Object readFromStream() throws EOFException {
                if (!reader.hasMoreChildren()) {
                    throw new EOFException();
                }
                reader.moveDown();
                Object result = XSerializer.this.unmarshal(reader);
                reader.moveUp();
                return result;
            }

            @Override
            public Map readFieldsFromStream() throws IOException {
                throw new NotActiveException("not in call to readObject");
            }

            @Override
            public void defaultReadObject() throws NotActiveException {
                throw new NotActiveException("not in call to readObject");
            }

            @Override
            public void registerValidation(ObjectInputValidation validation, int priority) throws NotActiveException {
                throw new NotActiveException("stream inactive");
            }

            @Override
            public void close() {
                reader.close();
            }
        });
    }

    public void omitField(Class definedIn, String fieldName) {
        if (this.fieldAliasingMapper == null) {
            throw new InitializationException("No " + FieldAliasingMapper.class.getName() + " available");
        }
        this.fieldAliasingMapper.omitField(definedIn, fieldName);
    }

    protected void processAnnotations(Class[] types) {
        if (this.annotationConfiguration == null) {
            throw new InitializationException("No " + ANNOTATION_MAPPER_TYPE + " available");
        }
        this.annotationConfiguration.processAnnotations(types);
    }

    protected void processAnnotations(Class type) {
        this.processAnnotations(new Class[]{type});
    }

    protected void autodetectAnnotations(boolean mode) {
        if (this.annotationConfiguration != null) {
            this.annotationConfiguration.autodetectAnnotations(mode);
        }
    }

    public boolean isAnnotated(Class type) {
        if (this.annotationConfiguration != null) {
            return this.annotationConfiguration.isAnnotated(type);
        }
        return false;
    }

    private Object readResolve() {
        this.jvm = new JVM();
        return this;
    }

    @Override
    protected SerializerException createException(int errorCode, String message) {
        return new XSerializerException(errorCode, message);
    }

    @Override
    protected SerializerException createException(int errorCode, Throwable cause) {
        return new XSerializerException(errorCode, cause);
    }

    @Override
    protected SerializerException createException(int errorCode, String message, Throwable cause) {
        return new XSerializerException(errorCode, message, cause);
    }
}

