/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xml;

import com.streamscape.omf.xml.XSerialSAXWriter;
import com.streamscape.omf.xml.XSerializer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public class XSerialXSLTSource
extends SAXSource {
    public static final String XSTREAM_FEATURE = "http://com.thoughtworks.xstream/XStreamSource/feature";
    private XMLReader xmlReader = null;
    private XSerializer xstream = null;
    private List source = null;

    public XSerialXSLTSource() {
        super(new InputSource());
    }

    public XSerialXSLTSource(Object source) {
        super(new InputSource());
        this.setSource(source);
    }

    public XSerialXSLTSource(Object source, XSerializer xstream) {
        super(new InputSource());
        this.setSource(source);
        this.setXStream(xstream);
    }

    public XSerialXSLTSource(List source) {
        super(new InputSource());
        this.setSourceAsList(source);
    }

    public XSerialXSLTSource(List source, XSerializer xstream) {
        super(new InputSource());
        this.setSourceAsList(source);
        this.setXStream(xstream);
    }

    @Override
    public void setInputSource(InputSource inputSource) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setXMLReader(XMLReader reader) {
        this.createXMLReader(reader);
    }

    @Override
    public XMLReader getXMLReader() {
        if (this.xmlReader == null) {
            this.createXMLReader(null);
        }
        return this.xmlReader;
    }

    public void setXStream(XSerializer xstream) {
        if (xstream == null) {
            throw new IllegalArgumentException("xstream");
        }
        this.xstream = xstream;
        this.configureXMLReader();
    }

    public void setSource(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("obj");
        }
        ArrayList<Object> list = new ArrayList<Object>(1);
        list.add(obj);
        this.setSourceAsList(list);
    }

    public void setSourceAsList(List list) {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("list");
        }
        this.source = list;
        this.configureXMLReader();
    }

    private void createXMLReader(XMLReader filterChain) {
        if (filterChain == null) {
            this.xmlReader = new XSerialSAXWriter();
        } else if (filterChain instanceof XMLFilter) {
            XMLFilter filter = (XMLFilter)filterChain;
            while (filter.getParent() instanceof XMLFilter) {
                filter = (XMLFilter)filter.getParent();
            }
            if (!(filter.getParent() instanceof XSerialSAXWriter)) {
                filter.setParent(new XSerialSAXWriter());
            }
            this.xmlReader = filterChain;
        } else {
            throw new UnsupportedOperationException();
        }
        this.configureXMLReader();
    }

    private void configureXMLReader() {
        if (this.xmlReader != null) {
            try {
                if (this.xstream != null) {
                    this.xmlReader.setProperty("http://com.thoughtworks.xstream/sax/property/configured-xstream", this.xstream);
                }
                if (this.source != null) {
                    this.xmlReader.setProperty("http://com.thoughtworks.xstream/sax/property/source-object-list", this.source);
                }
            }
            catch (SAXException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }
}

