/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.serializer;

import com.streamscape.omf.FactoryManagerException;
import com.streamscape.omf.java.JSerializerFactory;
import com.streamscape.omf.java.SerialSupport;
import com.streamscape.omf.java.defaults.TimeUnitSerialSupport;
import com.streamscape.omf.serializer.AliasManager;
import com.streamscape.omf.serializer.SerializerUtils;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;

public class TimeUnitHelper {
    private static final Method ADD_SYSTEM_SERIAL_SUPPORT;

    static void addAlias(AliasManager aliasManager) throws FactoryManagerException {
        SerializerUtils.doAlias(aliasManager, TimeUnit.class);
        SerializerUtils.doFakeAlias(aliasManager, "TimeUnit$MICROSECONDS");
        SerializerUtils.doFakeAlias(aliasManager, "TimeUnit$MILLISECONDS");
        SerializerUtils.doFakeAlias(aliasManager, "TimeUnit$SECONDS");
        SerializerUtils.doFakeAlias(aliasManager, "TimeUnit$MINUTES");
        SerializerUtils.doFakeAlias(aliasManager, "TimeUnit$HOURS");
        SerializerUtils.doFakeAlias(aliasManager, "TimeUnit$DAYS");
    }

    public static void addSerialSupport(JSerializerFactory factory) throws FactoryManagerException {
        try {
            ADD_SYSTEM_SERIAL_SUPPORT.invoke((Object)factory, TimeUnit.class, new TimeUnitSerialSupport());
        }
        catch (Exception exception) {
            throw new FactoryManagerException(3000, (Throwable)exception);
        }
    }

    static {
        try {
            ADD_SYSTEM_SERIAL_SUPPORT = JSerializerFactory.class.getDeclaredMethod("addSystemSerialSupport", Class.class, SerialSupport.class);
            ADD_SYSTEM_SERIAL_SUPPORT.setAccessible(true);
        }
        catch (Exception exception) {
            throw new RuntimeException("Initialization of TimeUnitHelper failed.", exception);
        }
    }
}

