/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.serializer;

import com.streamscape.Trace;
import com.streamscape.lib.utils.JVM;
import com.streamscape.lib.utils.OrderedMap;
import com.streamscape.omf.FactoryManagerException;
import com.streamscape.omf.serializer.AbstractSerializerFactory;
import com.streamscape.omf.serializer.AliasManager;
import com.streamscape.omf.serializer.AliasManagerImpl;
import com.streamscape.omf.serializer.TimeUnitHelper;
import com.streamscape.omf.xml.xstream.converters.ConversionException;
import com.streamscape.omf.xml.xstream.mapper.Mapper;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.pkg.Package;
import com.streamscape.repository.types.Prototype;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimePackageManifest;
import com.streamscape.runtime.deploy.CtxDeploymentDescriptor;
import com.streamscape.runtime.mf.admin.cfo.ClientFactoryObject;
import com.streamscape.runtime.mf.admin.dfo.JDBCFactoryObject;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.runtime.mf.admin.tfo.TransportFactoryObject;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.EventAnnotation;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.OpaqueDatagram;
import com.streamscape.sdo.StructuredDataObject;
import com.streamscape.sdo.file.FileMetaInfo;
import com.streamscape.sdo.mf.admin.DatagramFactory;
import com.streamscape.sdo.rowset.ColumnDescriptor;
import com.streamscape.sdo.rowset.DataRow;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowArray;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.rowset.RowSetProxy;
import com.streamscape.sdo.sys.Bytes;
import com.streamscape.sdo.sys.Null;
import com.streamscape.sdo.sys.SysId;
import com.streamscape.sdo.sys.Text;
import com.streamscape.sdo.sys.Void;
import com.streamscape.sdo.utils.EventInfo;
import com.streamscape.sef.ConfigurationProperty;
import com.streamscape.sef.advisories.StateAdvisoryDefinition;
import com.streamscape.sef.dispatcher.AbstractSerializerUtils;
import com.streamscape.sef.evtrigger.EventTriggerAction;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import com.streamscape.sef.metrics.MetricDefinition;
import com.streamscape.sef.metrics.RuntimeMetric;
import com.streamscape.sef.pkg.ComponentPackageManifest;
import com.streamscape.sef.pkg.PackageDescriptor;
import com.streamscape.service.osf.config.ClientFactoryPropertyValue;
import com.streamscape.service.osf.config.JDBCFactoryPropertyValue;
import com.streamscape.service.osf.config.ObjectPropertyValue;
import com.streamscape.service.osf.config.PasswordPropertyValue;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.TransportFactoryPropertyValue;
import com.streamscape.service.osf.eim.EventIdentity;
import com.streamscape.service.osf.eim.EventIdentityPlugin;
import com.streamscape.service.osf.evh.EventHandler;
import com.streamscape.service.osf.registry.ConfigurationProperties;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javassist.CannotCompileException;
import javassist.NotFoundException;
import javax.naming.NamingException;

public class SerializerUtils
extends AbstractSerializerUtils {
    public static void addSysAliases(AliasManager aliasManager) throws FactoryManagerException {
        Trace.logDebug(SerializerUtils.class, "Adding system aliases...");
        if (aliasManager == null) {
            throw new FactoryManagerException(3003, "Alias manager is null.");
        }
        SerializerUtils.doAlias(aliasManager, "null", Mapper.Null.class);
        SerializerUtils.doAlias(aliasManager, "int", Integer.class, SemanticTypeAncestor.primitive);
        SerializerUtils.doAlias(aliasManager, "float", Float.class, SemanticTypeAncestor.primitive);
        SerializerUtils.doAlias(aliasManager, "double", Double.class, SemanticTypeAncestor.primitive);
        SerializerUtils.doAlias(aliasManager, "long", Long.class, SemanticTypeAncestor.primitive);
        SerializerUtils.doAlias(aliasManager, "short", Short.class, SemanticTypeAncestor.primitive);
        SerializerUtils.doAlias(aliasManager, "char", Character.class, SemanticTypeAncestor.primitive);
        SerializerUtils.doAlias(aliasManager, "byte", Byte.class, SemanticTypeAncestor.primitive);
        SerializerUtils.doAlias(aliasManager, "boolean", Boolean.class, SemanticTypeAncestor.primitive);
        SerializerUtils.doAlias(aliasManager, "number", Number.class);
        SerializerUtils.doAlias(aliasManager, "object", Object.class, SemanticTypeAncestor.primitive);
        SerializerUtils.doAlias(aliasManager, "bigint", BigInteger.class, SemanticTypeAncestor.primitive);
        SerializerUtils.doAlias(aliasManager, "decimal", BigDecimal.class, SemanticTypeAncestor.primitive);
        SerializerUtils.doAlias(aliasManager, "string_buffer", StringBuffer.class);
        SerializerUtils.doAlias(aliasManager, "string", String.class, SemanticTypeAncestor.primitive);
        SerializerUtils.doAlias(aliasManager, "java_class", Class.class);
        SerializerUtils.doAlias(aliasManager, "method", Method.class);
        SerializerUtils.doAlias(aliasManager, "constructor", Constructor.class);
        SerializerUtils.doAlias(aliasManager, "field", Field.class);
        SerializerUtils.doAlias(aliasManager, "date", Date.class, SemanticTypeAncestor.primitive);
        SerializerUtils.doAlias(aliasManager, "url", URL.class);
        SerializerUtils.doAlias(aliasManager, "bit_set", BitSet.class, SemanticTypeAncestor.collection);
        SerializerUtils.doAlias(aliasManager, "mapint", Map.class, SemanticTypeAncestor.collection);
        SerializerUtils.doAlias(aliasManager, "entry", Map.Entry.class, SemanticTypeAncestor.collection);
        SerializerUtils.doAlias(aliasManager, "properties", Properties.class, SemanticTypeAncestor.collection);
        SerializerUtils.doAlias(aliasManager, "listint", List.class, SemanticTypeAncestor.collection);
        SerializerUtils.doAlias(aliasManager, "setint", Set.class, SemanticTypeAncestor.collection);
        SerializerUtils.doAlias(aliasManager, "linked_list", LinkedList.class, SemanticTypeAncestor.collection);
        SerializerUtils.doAlias(aliasManager, "list", ArrayList.class, SemanticTypeAncestor.collection);
        SerializerUtils.doAlias(aliasManager, "vector", Vector.class, SemanticTypeAncestor.collection);
        SerializerUtils.doAlias(aliasManager, "sortedMap", TreeMap.class, SemanticTypeAncestor.collection);
        SerializerUtils.doAlias(aliasManager, "sortedSet", TreeSet.class, SemanticTypeAncestor.collection);
        SerializerUtils.doAlias(aliasManager, "hashtable", Hashtable.class, SemanticTypeAncestor.collection);
        SerializerUtils.doAlias(aliasManager, "set", HashSet.class, SemanticTypeAncestor.collection);
        SerializerUtils.doAlias(aliasManager, "map", HashMap.class, SemanticTypeAncestor.collection);
        SerializerUtils.doAlias(aliasManager, "concurrent_hash_map", ConcurrentHashMap.class, SemanticTypeAncestor.collection);
        SerializerUtils.doAlias(aliasManager, "linked_hash_map", LinkedHashMap.class, SemanticTypeAncestor.collection);
        SerializerUtils.doAlias(aliasManager, "file", File.class);
        SerializerUtils.doAlias(aliasManager, "locale", Locale.class);
        SerializerUtils.doAlias(aliasManager, "gregorian_calendar", Calendar.class);
        SerializerUtils.doAlias(aliasManager, "byte_array", byte[].class);
        JVM jvm = new JVM();
        if (jvm.supportsAWT()) {
            SerializerUtils.doAlias(aliasManager, "awt_color", jvm.loadClass("java.awt.Color"));
            SerializerUtils.doAlias(aliasManager, "awt_font", jvm.loadClass("java.awt.Font"));
            SerializerUtils.doAlias(aliasManager, "awt_text_attribute", jvm.loadClass("java.awt.font.TextAttribute"));
        }
        if (jvm.supportsSQL()) {
            SerializerUtils.doAlias(aliasManager, "SqlTimestamp", jvm.loadClass("java.sql.Timestamp"), SemanticTypeAncestor.primitive);
            SerializerUtils.doAlias(aliasManager, "SqlTime", jvm.loadClass("java.sql.Time"), SemanticTypeAncestor.primitive);
            SerializerUtils.doAlias(aliasManager, "SqlDate", jvm.loadClass("java.sql.Date"), SemanticTypeAncestor.primitive);
        }
        if (JVM.is1_4()) {
            SerializerUtils.doAlias(aliasManager, "auth_subject", jvm.loadClass("javax.security.auth.Subject"));
            SerializerUtils.doAlias(aliasManager, "linked_hash_map", jvm.loadClass("java.util.LinkedHashMap"));
            SerializerUtils.doAlias(aliasManager, "linked_hash_set", jvm.loadClass("java.util.LinkedHashSet"));
            SerializerUtils.doAlias(aliasManager, "trace", jvm.loadClass("java.lang.StackTraceElement"));
            SerializerUtils.doAlias(aliasManager, "currency", jvm.loadClass("java.util.Currency"));
        }
        if (JVM.is1_5()) {
            SerializerUtils.doAlias(aliasManager, "duration", jvm.loadClass("javax.xml.datatype.Duration"));
            SerializerUtils.doAlias(aliasManager, "enum_set", jvm.loadClass("java.util.EnumSet"));
            SerializerUtils.doAlias(aliasManager, "enum_map", jvm.loadClass("java.util.EnumMap"));
            SerializerUtils.doAlias(aliasManager, "string_builder", jvm.loadClass("java.lang.StringBuilder"));
            SerializerUtils.doAlias(aliasManager, "uuid", jvm.loadClass("java.util.UUID"));
        }
    }

    public static void addSysTypeAliases(AliasManager aliasManager) throws FactoryManagerException {
        Trace.logDebug(SerializerUtils.class, "Adding system Semantic Type aliases...");
        if (aliasManager == null) {
            throw new FactoryManagerException(3003, "Alias manager is null.");
        }
        SerializerUtils.doFakeAlias(aliasManager, "Wizard.PANEL");
        SerializerUtils.doAlias(aliasManager, "RuntimeContextDescriptor", CtxDeploymentDescriptor.class);
        SerializerUtils.doAlias(aliasManager, "SemanticType", SemanticType.class);
        SerializerUtils.doAlias(aliasManager, "Property", ServiceConfigurationProperty.class);
        SerializerUtils.doAlias(aliasManager, "Property.ADVANCED", ConfigurationProperty.class);
        SerializerUtils.doAlias(aliasManager, "Value.PASSWORD", PasswordPropertyValue.class);
        SerializerUtils.doAlias(aliasManager, "Value.TRANSPORT_FACTORY", TransportFactoryPropertyValue.class);
        SerializerUtils.doAlias(aliasManager, "Value.JDBC_FACTORY", JDBCFactoryPropertyValue.class);
        SerializerUtils.doAlias(aliasManager, "Value.CLIENT_FACTORY", ClientFactoryPropertyValue.class);
        SerializerUtils.doAlias(aliasManager, "Value.OBJECT", ObjectPropertyValue.class);
        SerializerUtils.doAlias(aliasManager, "Registry.PROPERTIES", ConfigurationProperties.class);
        SerializerUtils.doAlias(aliasManager, "Handler.EVENT", EventHandler.class);
        SerializerUtils.doAlias(aliasManager, "ADVISORY", StateAdvisoryDefinition.class);
        SerializerUtils.doAlias(aliasManager, Void.class);
        SerializerUtils.doAlias(aliasManager, Null.class);
        SerializerUtils.doAlias(aliasManager, Text.class, SemanticTypeAncestor.complex);
        SerializerUtils.doAlias(aliasManager, Bytes.class, SemanticTypeAncestor.complex);
        SerializerUtils.doFakeAlias(aliasManager, "Map");
        SerializerUtils.doAlias(aliasManager, "SystemId", SysId.class, "System Identifier.");
        SerializerUtils.doAlias(aliasManager, "EIMTrackingInfo", EventIdentity.class, "Event Identity Manager tracking information.");
        SerializerUtils.doAlias(aliasManager, "ServiceConfiguration", ServiceConfigurationObject.class, "Service Configuration Object.");
        SerializerUtils.doFakeAlias(aliasManager, "WizardConfiguration");
        SerializerUtils.doAlias(aliasManager, "TransportFactory", TransportFactoryObject.class, "Transport Connection Factory.");
        SerializerUtils.doAlias(aliasManager, "ClientFactory", ClientFactoryObject.class, "Client Connection Factory.");
        SerializerUtils.doAlias(aliasManager, "JDBCFactory", JDBCFactoryObject.class, "JDBC Connection Factory.");
        SerializerUtils.doAlias(aliasManager, "METRIC", MetricDefinition.class, "Metric Definition.");
        SerializerUtils.doAlias(aliasManager, Package.class, "Package.");
        SerializerUtils.doAlias(aliasManager, PackageType.class, "Package Type.");
        SerializerUtils.doAlias(aliasManager, OrderedMap.class, "Ordered Map.");
        SerializerUtils.doAlias(aliasManager, RuntimeMetric.class, "Runtime Metric.");
        SerializerUtils.doAlias(aliasManager, EventIdentityPlugin.class, "Event Identity Plugin for all plug-ins.");
        SerializerUtils.doAlias(aliasManager, EventAnnotation.class, "Event Annotation object.");
        SerializerUtils.doAlias(aliasManager, StructuredDataObject.class, "Ancestor of all Structured Data Objects.");
        SerializerUtils.doAlias(aliasManager, DatagramFactory.class, "Ancestor of all Datagram Factories.");
        SerializerUtils.doAlias(aliasManager, "event", ImmutableEventDatagram.class, "Immutable Event Datagram object type.", SemanticTypeAncestor.primitive);
        SerializerUtils.doAlias(aliasManager, Prototype.class, "Datagram Prototype Definition.");
        SerializerUtils.doAlias(aliasManager, EventTriggerDefinition.class, "Event Trigger Definition.");
        SerializerUtils.doAlias(aliasManager, DataRow.class, "Structured Data Object Row Interface.");
        SerializerUtils.doAlias(aliasManager, RowArray.class, "Structured Data Object Row Array.", SemanticTypeAncestor.complex);
        SerializerUtils.doAlias(aliasManager, RowSet.class, "Structured Data Object Row Set.", SemanticTypeAncestor.complex);
        SerializerUtils.doAlias(aliasManager, RowSetProxy.class, "Structured Data Object Row Set Proxy.");
        SerializerUtils.doAlias(aliasManager, Row.class, "Structured Data Object Row (tuple set).", SemanticTypeAncestor.complex);
        SerializerUtils.doAlias(aliasManager, RowMetaData.class, "Row Meta Data.", SemanticTypeAncestor.complex);
        SerializerUtils.doAlias(aliasManager, ColumnDescriptor.class, "Column descriptor.", SemanticTypeAncestor.complex);
        SerializerUtils.doAlias(aliasManager, FileMetaInfo.class, "Structured Data Object File State.", SemanticTypeAncestor.complex);
        SerializerUtils.doAlias(aliasManager, EventTriggerAction.class, "Ancestor for all event trigger actions.");
        SerializerUtils.doAlias(aliasManager, RuntimePackageManifest.class, "Runtime Package Manifest.");
        SerializerUtils.doAlias(aliasManager, ComponentPackageManifest.class, "Component Package Manifest.");
        SerializerUtils.doAlias(aliasManager, PackageDescriptor.class, "Package Manifest.");
        SerializerUtils.doAlias(aliasManager, EventInfo.class, "Event Info.");
        SerializerUtils.doAlias(aliasManager, "datagram", EventDatagram.class, "Event Datagram interface type.", SemanticTypeAncestor.primitive);
        SerializerUtils.doAlias(aliasManager, "advisory", AdvisoryEventDatagram.class, "Advisory Event Datagram object type.", SemanticTypeAncestor.primitive);
        SerializerUtils.doAlias(aliasManager, "exception", ExceptionEventDatagram.class, "Exception Event Datagram object type.", SemanticTypeAncestor.primitive);
        SerializerUtils.doAlias(aliasManager, "opaque", OpaqueDatagram.class, "Opaque Datagram object type.", SemanticTypeAncestor.primitive);
        SerializerUtils.doAlias(aliasManager, Throwable.class);
        SerializerUtils.doAlias(aliasManager, "jexception", Exception.class);
        SerializerUtils.doAlias(aliasManager, RuntimeException.class);
        SerializerUtils.doAlias(aliasManager, NullPointerException.class);
        SerializerUtils.doAlias(aliasManager, IllegalAccessException.class);
        SerializerUtils.doAlias(aliasManager, IllegalStateException.class);
        SerializerUtils.doAlias(aliasManager, InstantiationException.class);
        SerializerUtils.doAlias(aliasManager, IndexOutOfBoundsException.class);
        SerializerUtils.doAlias(aliasManager, SecurityException.class);
        SerializerUtils.doAlias(aliasManager, IOException.class);
        SerializerUtils.doAlias(aliasManager, CannotCompileException.class);
        SerializerUtils.doAlias(aliasManager, NotFoundException.class);
        SerializerUtils.doAlias(aliasManager, ConversionException.class);
        SerializerUtils.doAlias(aliasManager, NoSuchMethodException.class);
        SerializerUtils.doAlias(aliasManager, OutOfMemoryError.class);
        SerializerUtils.doAlias(aliasManager, IllegalArgumentException.class);
        SerializerUtils.doAlias(aliasManager, NamingException.class);
        SerializerUtils.doAlias(aliasManager, ClassCastException.class);
        SerializerUtils.doAlias(aliasManager, EOFException.class);
        SerializerUtils.doAlias(aliasManager, FileNotFoundException.class);
        SerializerUtils.doAlias(aliasManager, NumberFormatException.class);
        SerializerUtils.doAlias(aliasManager, SQLException.class);
        SerializerUtils.doAlias(aliasManager, NoClassDefFoundError.class);
        SerializerUtils.doAlias(aliasManager, ClassNotFoundException.class);
        SerializerUtils.doAlias(aliasManager, NoSuchElementException.class);
        TimeUnitHelper.addAlias(aliasManager);
        SerializerUtils.addSystemSemanticTypes(aliasManager);
    }

    static void doAlias(AliasManager manager, String alias, Class typeClass) throws FactoryManagerException {
        SerializerUtils.addSemanticType(manager, alias, typeClass);
    }

    private static void doAlias(AliasManager manager, String alias, Class typeClass, String description, SemanticTypeAncestor ancestor) throws FactoryManagerException {
        SerializerUtils.addSemanticType(manager, alias, typeClass, description, ancestor);
    }

    private static void doAlias(AliasManager manager, String alias, Class typeClass, SemanticTypeAncestor ancestor) throws FactoryManagerException {
        SerializerUtils.doAlias(manager, alias, typeClass, null, ancestor);
    }

    static void doAlias(AliasManager manager, Class typeClass) throws FactoryManagerException {
        SerializerUtils.addSemanticType(manager, typeClass);
    }

    private static void doAlias(AliasManager manager, Class typeClass, SemanticTypeAncestor ancestor) throws FactoryManagerException {
        SerializerUtils.addSemanticType(manager, typeClass, null, ancestor);
    }

    private static void doAlias(AliasManager manager, Class typeClass, String description, SemanticTypeAncestor ancestor) throws FactoryManagerException {
        SerializerUtils.doAlias(manager, typeClass.getSimpleName(), typeClass, description, ancestor);
    }

    private static void doAlias(AliasManager manager, String typeName, Class typeClass, String description) throws FactoryManagerException {
        SerializerUtils.addSemanticType(manager, typeName, typeClass, description);
    }

    private static void doAlias(AliasManager manager, Class typeClass, String description) throws FactoryManagerException {
        SerializerUtils.addSemanticType(manager, typeClass, description);
    }

    private static void doAlias(AliasManager manager, String alias, Class typeClass, String description, String ancestorType) throws FactoryManagerException {
        SerializerUtils.addSemanticType(manager, alias, typeClass, ancestorType, description);
    }

    static void doFakeAlias(AliasManager manager, String alias) {
        if (manager instanceof AliasManagerImpl) {
            ((AliasManagerImpl)manager).serialIdAllocator.getNumber();
        }
    }

    @Override
    protected void realias(AliasManager manager, String alias, Class typeClass) throws FactoryManagerException {
        if (manager instanceof AliasManagerImpl) {
            ((AliasManagerImpl)manager).realias(alias, typeClass);
        }
    }

    @Override
    protected void realias(AbstractSerializerFactory factory, String alias, Class typeClass) throws FactoryManagerException {
        this.realias(factory.aliasManager, alias, typeClass);
    }

    @Override
    protected void fakeAlias(AliasManager manager, String alias) {
        SerializerUtils.doFakeAlias(manager, alias);
    }

    @Override
    protected void addHiddenType(AliasManager manager, String className) {
        if (manager instanceof AliasManagerImpl) {
            ((AliasManagerImpl)manager).aliasHidden(className);
        }
    }

    public static enum SemanticTypeAncestor {
        primitive,
        collection,
        complex;

    }
}

