/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.serializer;

import com.streamscape.Trace;
import com.streamscape.lib.numalloc.ShortNumberAllocatorSimple;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.omf.FactoryManagerException;
import com.streamscape.omf.serializer.AliasManager;
import com.streamscape.omf.serializer.ClassLoaderProvider;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.ErrorMessages;
import com.streamscape.sef.dispatcher.AbstractAliasManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class AliasManagerImpl
extends AbstractAliasManager
implements AliasManager {
    private final Map<String, SemanticType> classToType = new ConcurrentHashMap<String, SemanticType>();
    private final Map<String, SemanticType> aliasToType = new ConcurrentHashMap<String, SemanticType>();
    private final Map<Short, SemanticType> serialIdToType = new ConcurrentHashMap<Short, SemanticType>();
    private final Map<String, SemanticType> classToHiddenType = new ConcurrentHashMap<String, SemanticType>();
    private final Set<Class> immutableClasses = new HashSet<Class>();
    private final Map<String, List<SemanticType>> typesByAncestor = new ConcurrentHashMap<String, List<SemanticType>>();
    private ClassLoaderProvider classLoaderProvider;
    final ShortNumberAllocatorSimple serialIdAllocator = new ShortNumberAllocatorSimple();

    protected AliasManagerImpl(ClassLoaderProvider classLoaderProvider) {
        this.classLoaderProvider = classLoaderProvider;
    }

    protected void checkClassLoaderProvider(ClassLoaderProvider classLoaderProvider) {
        if (this.classLoaderProvider == null) {
            this.classLoaderProvider = classLoaderProvider;
        }
    }

    @Override
    protected SemanticType doLookupSemanticType(String alias) {
        return this.aliasToType.get(alias);
    }

    @Override
    protected SemanticType doLookupSemanticClass(Class clazz) {
        return this.doLookupSemanticClass(clazz.getName());
    }

    @Override
    protected SemanticType doLookupSemanticClass(String className) {
        return this.classToType.get(className);
    }

    protected SemanticType doLookupSemanticClassFull(String className) {
        SemanticType result = this.classToType.get(className);
        return result != null ? result : this.classToHiddenType.get(className);
    }

    @Override
    protected SemanticType doLookupSemanticType(short serialId) {
        return this.serialIdToType.get(serialId);
    }

    protected SemanticType lookupSemanticType(String alias) {
        SemanticType result = this.doLookupSemanticType(alias);
        return result != null ? result.clone() : null;
    }

    protected SemanticType lookupSemanticClass(Class clazz) {
        return this.lookupSemanticClass(clazz.getName());
    }

    protected SemanticType lookupSemanticClass(String className) {
        SemanticType result = this.doLookupSemanticClass(className);
        return result != null ? result.clone() : null;
    }

    @Override
    public void alias(String alias, Class type) throws FactoryManagerException {
        SemanticType semanticType = AliasManagerImpl.createSemanticType(alias, type, false);
        semanticType.setDescription("Generated (transient) alias definition.");
        this.alias(semanticType);
    }

    @Override
    public void aliasImmutableType(SemanticType semanticType) throws FactoryManagerException {
        try {
            this.aliasImmutableType(ClassUtils.loadClass(semanticType.getClassName(), this.doGetClassLoader()));
        }
        catch (ClassNotFoundException exception) {
            throw new FactoryManagerException(3025, "Class not found for semantic type '" + semanticType.getTypeName() + "'.");
        }
    }

    @Override
    public void aliasImmutableType(Class clazz) {
        if (!this.immutableClasses.contains(clazz)) {
            this.immutableClasses.add(clazz);
            Trace.logDebug(this, "Class '" + clazz.getName() + "' aliased as immutable type.");
        }
    }

    @Override
    public boolean isImmutableTypeAliased(Class clazz) {
        return this.immutableClasses.contains(clazz);
    }

    @Override
    public synchronized void alias(SemanticType type) throws FactoryManagerException {
        if (this.aliasToType.containsKey((type = type.clone()).getTypeName())) {
            throw new FactoryManagerException(3021, "Semantic type '" + type.getTypeName() + "' already exists.");
        }
        if (this.classToType.containsKey(type.getClassName())) {
            throw new FactoryManagerException(3026, "Semantic type ('" + String.valueOf(this.classToType.get(type.getClassName())) + "') already exists for class '" + type.getClassName() + "'.");
        }
        if (type.isSystem()) {
            AliasManagerImpl.setSerialId(type, this.serialIdAllocator.getNumber());
            this.serialIdToType.put(AliasManagerImpl.getSerialId(type), type);
        }
        this.aliasToType.put(type.getTypeName(), type);
        this.classToType.put(type.getClassName(), type);
        if (type.getAncestorType() != null) {
            this.typesByAncestor.computeIfAbsent(type.getAncestorType(), k -> new ArrayList()).add(type);
        }
        Trace.logDebug(this, "Class '" + type.getClassName() + "' aliased as '" + type.getTypeName() + "'.");
    }

    @Override
    public void unalias(SemanticType type) throws FactoryManagerException {
        this.unalias(type.getTypeName());
    }

    @Override
    public synchronized void unalias(String alias) throws FactoryManagerException {
        List<SemanticType> ancestorTypes;
        this.checkSemanticType(alias);
        SemanticType removedType = this.aliasToType.remove(alias);
        if (removedType.isSystem()) {
            throw new FactoryManagerException(5017, ErrorMessages.format("System semantic type [%1$s] cannot be removed.", alias));
        }
        String className = removedType.getClassName();
        if (className != null) {
            this.classToType.remove(className);
        }
        if (removedType.getAncestorType() != null && (ancestorTypes = this.typesByAncestor.get(removedType.getAncestorType())) != null) {
            ancestorTypes.remove(removedType);
        }
        this.typesByAncestor.remove(removedType.getTypeName());
        Trace.logDebug(this, "Semantic type '" + alias + "' unaliased.");
    }

    protected synchronized void realias(String alias, Class type) throws FactoryManagerException {
        this.checkSemanticType(alias);
        SemanticType semanticType = this.aliasToType.get(alias);
        this.classToType.remove(semanticType.getClassName());
        AliasManagerImpl.setClassName(semanticType, type.getName());
        this.classToType.put(semanticType.getClassName(), semanticType);
        Trace.logDebug(this, "Class '" + type.getName() + "' aliased as '" + alias + "'.");
    }

    synchronized void aliasHidden(String className) {
        if (!this.classToHiddenType.containsKey(className)) {
            SemanticType type = AliasManagerImpl.createSemanticType(className, className, true);
            AliasManagerImpl.setSerialId(type, this.serialIdAllocator.getNumber());
            this.serialIdToType.put(AliasManagerImpl.getSerialId(type), type);
            this.classToHiddenType.put(className, type);
        }
    }

    @Override
    public List<String> listAliases() {
        ArrayList<String> list = new ArrayList<String>(this.aliasToType.keySet());
        Collections.sort(list);
        return list;
    }

    protected List<SemanticType> getSemanticTypes() {
        return new ArrayList<SemanticType>(this.aliasToType.values());
    }

    @Override
    public String lookup(Class clazz) {
        return this.resolveClass(clazz.getName());
    }

    @Override
    public String lookup(String typeName) {
        SemanticType semanticType = this.aliasToType.get(typeName);
        return semanticType != null ? semanticType.getClassName() : null;
    }

    @Override
    public String resolveClass(String className) {
        SemanticType semanticType = this.classToType.get(className);
        return semanticType != null ? semanticType.getTypeName() : null;
    }

    @Override
    public boolean isAliased(String typeName) {
        return this.aliasToType.containsKey(typeName);
    }

    @Override
    public boolean isAliased(Class type) {
        return this.classToType.containsKey(type.getName());
    }

    @Override
    public boolean isClassAliased(String className) {
        return this.classToType.containsKey(className);
    }

    public boolean isInstanceOfAncestor(String typeName) throws FactoryManagerException {
        Class ancestorClass;
        Class typeClass;
        SemanticType type = this.aliasToType.get(typeName);
        this.checkSemanticType(type, typeName);
        SemanticType ancestorType = this.aliasToType.get(type.getAncestorType());
        this.checkSemanticType(ancestorType, type.getAncestorType());
        try {
            typeClass = ClassUtils.loadClass(type.getClassName(), this.doGetClassLoader());
        }
        catch (ClassNotFoundException exception) {
            throw new FactoryManagerException(3025, "Class not found for semantic type '" + type.getTypeName() + "'.");
        }
        try {
            ancestorClass = ClassUtils.loadClass(ancestorType.getClassName(), this.doGetClassLoader());
        }
        catch (ClassNotFoundException exception) {
            throw new FactoryManagerException(3025, "Class not found for semantic type '" + ancestorType.getTypeName() + "'.");
        }
        return ancestorClass.isAssignableFrom(typeClass);
    }

    private void checkSemanticType(String typeName) throws FactoryManagerException {
        if (!this.aliasToType.containsKey(typeName)) {
            throw new FactoryManagerException(3022, "Semantic type '" + typeName + "' does not exist.");
        }
    }

    private void checkSemanticType(SemanticType type, String typeName) throws FactoryManagerException {
        if (type == null) {
            throw new FactoryManagerException(3022, "Semantic type '" + typeName + "' does not exist.");
        }
    }

    @Override
    protected void clear() {
        this.classToType.clear();
        this.aliasToType.clear();
        this.serialIdToType.clear();
        this.immutableClasses.clear();
        this.typesByAncestor.clear();
    }

    protected ClassLoader doGetClassLoader() {
        return this.classLoaderProvider != null ? this.classLoaderProvider.getClassLoader() : Thread.currentThread().getContextClassLoader();
    }

    public Map<String, Object> getAncestorTree() {
        return this.doGetAncestorTree(this::addAncestors);
    }

    private void addAncestors(Set<String> types, Map<String, Object> result) {
        for (String typeName : types) {
            List<SemanticType> childs = this.typesByAncestor.get(typeName);
            if (childs == null) {
                result.put(typeName, null);
                continue;
            }
            TreeMap<String, Object> childTree = new TreeMap<String, Object>();
            this.addAncestors(childs.stream().map(SemanticType::getTypeName).collect(Collectors.toSet()), childTree);
            result.put(typeName, childTree);
        }
    }

    public Map<String, Object> getUserAncestorTree() {
        return this.doGetAncestorTree(this::addUserAncestors);
    }

    private void addUserAncestors(Set<String> types, Map<String, Object> result) {
        for (String typeName : types) {
            List<SemanticType> childs = this.typesByAncestor.get(typeName);
            if (childs == null) {
                if (this.doLookupSemanticType(typeName).isSystem()) continue;
                result.put(typeName, null);
                continue;
            }
            TreeMap<String, Object> childTree = new TreeMap<String, Object>();
            this.addUserAncestors(childs.stream().map(SemanticType::getTypeName).collect(Collectors.toSet()), childTree);
            if (childTree.isEmpty()) continue;
            result.put(typeName, childTree);
        }
    }

    private Map<String, Object> doGetAncestorTree(BiConsumer<Set<String>, Map<String, Object>> accumulator) {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        accumulator.accept(this.typesByAncestor.keySet().stream().filter(ancestor -> !this.isAliased((String)ancestor)).collect(Collectors.toSet()), result);
        return result;
    }
}

