/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.serializer;

import com.streamscape.lib.loader.ClassLoaderReference;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.omf.mf.admin.ObjectMediationAliasManager;
import com.streamscape.omf.serializer.ClassLoaderProvider;
import com.streamscape.omf.serializer.Serializer;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.repository.types.AbstractSemanticFactory;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sef.dispatcher.AbstractFabricContextFactory;
import com.streamscape.sef.mf.admin.FabricContext;

public abstract class AbstractSerializer
extends AbstractSemanticFactory
implements Serializer,
ClassLoaderProvider {
    protected transient ObjectMediationAliasManager aliasManager;
    protected transient ClassLoaderReference classLoader;

    protected AbstractSerializer(ObjectMediationAliasManager aliasManager) {
        this.aliasManager = aliasManager == null ? new ObjectMediationAliasManager(this) : aliasManager;
        this.aliasManager.checkClassLoaderProvider(this);
        this.classLoader = new ClassLoaderReference(this.doGetClassLoader(null));
    }

    @Override
    public void destroy() {
    }

    protected void checkSemanticType(String typeName) throws SerializerException {
        this.getSemanticType(typeName);
    }

    protected void checkSemanticType(Object object) throws SerializerException {
        this.doCheckSemanticType(this.lookupSemanticClassFull(object.getClass()), null, object.getClass().getName());
    }

    protected SemanticType getSemanticType(String typeName) throws SerializerException {
        this.checkTypeName(typeName);
        SemanticType result = this.lookupSemanticType(typeName);
        this.doCheckSemanticType(result, typeName);
        return result;
    }

    protected SemanticType lookupSemanticType(String typeName) {
        return this.aliasManager != null ? this.aliasManager.doLookupSemanticType(typeName) : null;
    }

    protected SemanticType lookupSemanticClass(Class clazz) {
        return this.aliasManager != null ? this.aliasManager.doLookupSemanticClass(clazz) : null;
    }

    protected SemanticType lookupSemanticClass(String className) {
        return this.aliasManager != null ? this.aliasManager.doLookupSemanticClass(className) : null;
    }

    protected SemanticType lookupSemanticClassFull(Class clazz) {
        return this.aliasManager != null ? this.aliasManager.doLookupSemanticClassFull(clazz.getName()) : null;
    }

    protected SemanticType lookupSemanticType(short serialId) {
        return this.aliasManager != null ? this.aliasManager.doLookupSemanticType(serialId) : null;
    }

    protected void checkSemanticTypeMatch(SemanticType type, Object object, String objectType) throws SerializerException {
        if (object != null) {
            try {
                Class typeClass = ClassUtils.loadClass(type.getClassName(), this.getClassLoader());
                if (!typeClass.isAssignableFrom(object.getClass())) {
                    throw this.createException(3024, "Semantic class '" + type.getClassName() + "' does not match class of " + objectType + " object.");
                }
            }
            catch (ClassNotFoundException exception) {
                throw this.createException(3025, exception);
            }
        }
    }

    protected void checkSemanticTypeMatch(Class typeClass, Object object, String objectType) throws SerializerException {
        if (object != null && !typeClass.isAssignableFrom(object.getClass())) {
            throw this.createException(3024, "Semantic class '" + typeClass.getName() + "' does not match class of " + objectType + " object.");
        }
    }

    private void checkTypeName(String typeName) throws SerializerException {
        if (typeName == null || typeName.length() == 0) {
            throw this.createException(3004, "Semantic type name is null or empty.");
        }
    }

    private void doCheckSemanticType(SemanticType type, String typeName) throws SerializerException {
        this.doCheckSemanticType(type, typeName, null);
    }

    private void doCheckSemanticType(SemanticType type, String typeName, String className) throws SerializerException {
        if (type == null) {
            throw this.createException(3022, className == null ? "Semantic type '" + typeName + "' does not exist." : "Semantic type does not exist for class '" + className + "'.");
        }
        if (!type.isValid()) {
            throw this.createException(3023, "Semantic type '" + type.getTypeName() + "' is invalid.");
        }
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader.setReference(this.doGetClassLoader(classLoader));
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader.getReference();
    }

    protected ClassLoader doGetClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            FabricContext context = AbstractFabricContextFactory.getContext();
            classLoader = context != null ? context.getSystemClassLoaderChain() : Thread.currentThread().getContextClassLoader();
        }
        return classLoader;
    }

    protected abstract SerializerException createException(int var1, String var2);

    protected abstract SerializerException createException(int var1, Throwable var2);

    protected abstract SerializerException createException(int var1, String var2, Throwable var3);
}

