/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.mf.admin;

import com.streamscape.lib.analyzer.SerializableFieldsAndParentTypesStrategy;
import com.streamscape.lib.analyzer.TypeAnalyzer;
import com.streamscape.lib.analyzer.TypeAnalyzerFactory;
import com.streamscape.lib.analyzer.TypeGraph;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.omf.json.utils.Primitives;
import com.streamscape.omf.serializer.AliasManager;
import com.streamscape.omf.serializer.AliasManagerImpl;
import com.streamscape.omf.serializer.ClassLoaderProvider;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.mf.admin.SemanticTypeCache;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ObjectMediationAliasManager
extends AliasManagerImpl
implements SemanticTypeCache,
AliasManager {
    public ObjectMediationAliasManager() {
        super(null);
    }

    public ObjectMediationAliasManager(ClassLoaderProvider classLoaderProvider) {
        super(classLoaderProvider);
    }

    @Override
    public SemanticType lookupSemanticType(String typeName) {
        return super.lookupSemanticType(typeName);
    }

    @Override
    public SemanticType lookupSemanticClass(Class semanticClass) {
        return super.lookupSemanticClass(semanticClass);
    }

    @Override
    public SemanticType lookupSemanticClass(String className) {
        return super.lookupSemanticClass(className);
    }

    @Override
    public boolean existsSemanticType(String typeName) {
        return super.isAliased(typeName);
    }

    @Override
    public boolean existsSemanticClass(Class semanticClass) {
        return super.isClassAliased(semanticClass.getName());
    }

    @Override
    public boolean existsSemanticClass(String className) {
        return super.isClassAliased(className);
    }

    @Override
    public List<String> listSemanticTypes() {
        return super.listAliases();
    }

    @Override
    public String resolveSemanticType(String typeName) {
        return super.lookup(typeName);
    }

    @Override
    public String resolveSemanticClass(Class semanticClass) {
        return super.lookup(semanticClass);
    }

    @Override
    public String resolveSemanticClass(String className) {
        return super.resolveClass(className);
    }

    @Override
    public List<String> listSemanticTypesByAncestor(String ancestorName) {
        return this.doGetUserSemanticTypesByAncestor(ancestorName).map(SemanticType::getTypeName).sorted().collect(Collectors.toList());
    }

    @Override
    public List<String> listUserSemanticTypesByAncestor(String ancestorName) {
        return this.doGetUserSemanticTypesByAncestor(ancestorName).map(SemanticType::getTypeName).sorted().collect(Collectors.toList());
    }

    protected Stream<SemanticType> doGetUserSemanticTypesByAncestor(String ancestorName) {
        return this.getSemanticTypes().stream().filter(type -> type != null && (ancestorName == null || type.getAncestorType().equals(ancestorName)));
    }

    @Override
    public List<String> listUserSemanticTypes() {
        return this.doGetUserSemanticTypes().map(SemanticType::getTypeName).sorted().collect(Collectors.toList());
    }

    protected List<SemanticType> getUserSemanticTypes() {
        return this.doGetUserSemanticTypes().collect(Collectors.toList());
    }

    protected Stream<SemanticType> doGetUserSemanticTypes() {
        return this.getSemanticTypes().stream().filter(type -> type != null && !type.isSystem());
    }

    @Override
    public List<String> listComponentSemanticTypes(String typeName) {
        return this.listComponentSemanticTypes(this.lookupSemanticType(typeName));
    }

    private List<String> listComponentSemanticTypes(SemanticType type) {
        if (type != null && type.isValid()) {
            ClassLoader rootClassLoader = this.doGetClassLoader();
            TypeAnalyzer analyzer = TypeAnalyzerFactory.getInstance().createTypeAnalyzer(rootClassLoader, this, new SerializableFieldsAndParentTypesStrategy());
            HashSet<String> classes = new HashSet<String>();
            try {
                ObjectMediationAliasManager.fillClasses(classes, analyzer.getTypeGraph(ClassUtils.loadClass(type.getClassName(), rootClassLoader)));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return classes.stream().map(this::lookupSemanticClass).filter(t -> t != null && !t.getTypeName().equals(type.getTypeName())).map(SemanticType::getTypeName).sorted().collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private static boolean isPrimitive(Class cls) {
        return cls.isPrimitive() || cls.equals(String.class) || cls.equals(Class.class) || Primitives.isWrapperType(cls);
    }

    private static void fillClasses(Set<String> classes, TypeGraph graph) {
        if (graph == null) {
            return;
        }
        if (graph.getType() instanceof Class) {
            Class cls = (Class)graph.getType();
            if (Primitives.isPrimitive(cls)) {
                cls = Primitives.wrap(cls);
            }
            classes.add(cls.getName());
        }
        for (TypeGraph child : graph.getChildren()) {
            ObjectMediationAliasManager.fillClasses(classes, child);
        }
    }

    @Override
    public List<String> listDependentSemanticTypes(String typeName) {
        SemanticType type = this.lookupSemanticType(typeName);
        return this.doListDependentSemanticTypes(typeName, () -> type.isSystem() ? this.getSemanticTypes() : this.getUserSemanticTypes());
    }

    @Override
    public List<String> listDependentUserSemanticTypes(String typeName) {
        return this.doListDependentSemanticTypes(typeName, this::getUserSemanticTypes);
    }

    private List<String> doListDependentSemanticTypes(String typeName, Supplier<List<SemanticType>> typesGetter) {
        SemanticType type = this.lookupSemanticType(typeName);
        return type != null ? typesGetter.get().stream().filter(t -> !t.getTypeName().equals(typeName) && this.isSemanticTypeDependsOn((SemanticType)t, type)).map(SemanticType::getTypeName).sorted().collect(Collectors.toList()) : new ArrayList<String>();
    }

    @Override
    public boolean isSemanticTypeDependsOn(String typeName, String targetTypeName) {
        return this.isSemanticTypeDependsOn(this.lookupSemanticType(typeName), this.lookupSemanticType(targetTypeName));
    }

    private boolean isSemanticTypeDependsOn(SemanticType type, SemanticType targetType) {
        return type != null && type.isValid() && targetType != null && (!type.isSystem() || targetType.isSystem()) && this.listComponentSemanticTypes(type).stream().anyMatch(t -> t.equals(targetType.getTypeName()));
    }
}

