/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.mapper.parser;

import com.streamscape.omf.json.utils.TypeUtils;
import com.streamscape.omf.mapper.SemanticMapperException;
import com.streamscape.omf.mapper.parser.ArrayHandler;
import com.streamscape.omf.mapper.parser.ListHandler;
import com.streamscape.omf.mapper.parser.MapHandler;
import com.streamscape.omf.mapper.parser.SemanticMapperContext;
import com.streamscape.omf.mapper.parser.SetHandler;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.edl.annotations.SemanticType;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class SequenceHandler {
    Object currentValue = null;
    Object sequence = null;
    Iterator<?> iterator = null;
    Class<?> sequenceClass = null;
    Class<?> sequenceElementClass = null;

    static SequenceHandler getHandler(SemanticMapperContext ctx, String semType, String spath) throws SemanticMapperException {
        try {
            Object parentObject = ctx.getMappingObject(semType);
            if (parentObject == null) {
                ctx.raiseError("Unknown semantic type encountered '" + semType + "'.");
            }
            String sequenceClassName = ctx.getTypeAnalyzer().getFieldTypeAsString(parentObject.getClass(), spath);
            Field field = ctx.getTypeAnalyzer().getField(parentObject.getClass(), spath);
            Class<?> sequenceClass = ctx.loadClass(sequenceClassName);
            Object sequence = ctx.getSdrManager().getValueAtPath(spath, parentObject);
            SequenceHandler handler = null;
            if (List.class.isAssignableFrom(sequenceClass)) {
                handler = new ListHandler(sequenceClass, sequence, field);
            } else if (Map.class.isAssignableFrom(sequenceClass)) {
                handler = new MapHandler(sequenceClass, sequence, field);
            } else if (Set.class.isAssignableFrom(sequenceClass)) {
                handler = new SetHandler(sequenceClass, sequence);
            } else if (sequence.getClass().isArray()) {
                handler = new ArrayHandler(sequenceClass, sequence);
            } else {
                throw new SemanticMapperException(3013, "Unsupported sequence type. ");
            }
            ((SequenceHandler)handler).init(ctx, parentObject, spath);
            return handler;
        }
        catch (Exception error) {
            throw new SemanticMapperException(3013, error.getMessage());
        }
    }

    public SequenceHandler(Class<?> sequenceClass, Object sequence) {
        this.sequenceClass = sequenceClass;
        this.sequence = sequence;
    }

    void init(SemanticMapperContext ctx, Object parentObject, String parentSpath) throws SemanticMapperException {
    }

    void clean() {
        this.currentValue = null;
    }

    Object getCurrent() {
        return this.currentValue;
    }

    void moveToNext(SemanticMapperContext ctx) throws SemanticMapperException {
    }

    String getCollectionElementType(Type type, Field field) throws Exception {
        Class<?> rawClass = TypeUtils.toRawClass(type);
        if (Collection.class.isAssignableFrom(rawClass) || Map.class.isAssignableFrom(rawClass)) {
            SemanticType annotation;
            String[] arguments = null;
            if (field != null && (annotation = field.getAnnotation(SemanticType.class)) != null) {
                String type1 = annotation.type();
                String type2 = annotation.type1();
                if (type1 != null && type1.length() > 0) {
                    if (type2 != null && type2.length() > 0) {
                        arguments = new String[2];
                        arguments[1] = type2;
                    } else {
                        arguments = new String[]{type1};
                    }
                }
            }
            if (arguments == null) {
                return null;
            }
            if (Map.class.isAssignableFrom(rawClass)) {
                return this.resolveSemanticType((String)arguments[1]);
            }
            if (List.class.isAssignableFrom(rawClass)) {
                return this.resolveSemanticType((String)arguments[0]);
            }
            return null;
        }
        return null;
    }

    private String resolveSemanticType(String typeName) {
        com.streamscape.repository.types.SemanticType type = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType(typeName);
        if (type != null) {
            return type.getClassName();
        }
        type = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticClass(typeName);
        if (type != null) {
            return type.getClassName();
        }
        return null;
    }
}

