/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.mapper.parser;

import com.streamscape.omf.mapper.SemanticMapperException;
import com.streamscape.omf.mapper.parser.Expression;
import com.streamscape.omf.mapper.parser.SPathExpression;
import com.streamscape.omf.mapper.parser.SemanticMapperContext;
import com.streamscape.omf.mapper.parser.SequenceHandler;

public class SPathSequenceExpression
extends SPathExpression {
    private static final int SEQ_SPATH = 2;
    private SequenceHandler handler = null;

    SPathSequenceExpression() {
        super(Expression.ExpressionType.SPATH_SEQUENCE);
    }

    public void setSequenceSpath(String spath) {
        this.exprs.add(2, spath);
    }

    public String getSequenceSpath() {
        String seqSpath = (String)this.exprs.get(2);
        if (seqSpath == null || seqSpath.trim().length() == 0) {
            return "//";
        }
        if (seqSpath.trim().startsWith("//")) {
            return seqSpath;
        }
        if (seqSpath.trim().startsWith("/")) {
            return "/" + seqSpath;
        }
        return "//" + seqSpath;
    }

    void init(SemanticMapperContext ctx) throws SemanticMapperException {
        try {
            if (this.handler == null) {
                this.handler = ctx.getSequenceObjects().get(this.getAlias() + this.getSpath());
                if (this.handler == null) {
                    this.handler = SequenceHandler.getHandler(ctx, this.getAlias(), this.getSpath());
                    ctx.getSequenceObjects().put(this.getAlias() + this.getSpath(), this.handler);
                }
            }
        }
        catch (Exception error) {
            throw new SemanticMapperException(3013, error.getMessage());
        }
    }

    @Override
    Object evaluate(SemanticMapperContext ctx) throws SemanticMapperException {
        Object currentObject;
        this.evaluateParams(ctx);
        if (this.handler == null) {
            this.init(ctx);
        }
        if ((currentObject = this.handler.getCurrent()) != null && this.params.get(2) instanceof String) {
            try {
                return ctx.getSdrManager().getValueAtPath(this.getSequenceSpath(), currentObject);
            }
            catch (Exception error) {
                throw new SemanticMapperException(3013, error.getMessage());
            }
        }
        return super.evaluate(ctx);
    }
}

