/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.mapper.parser;

import com.streamscape.omf.mapper.SemanticMapperException;
import com.streamscape.omf.mapper.parser.Expression;
import com.streamscape.omf.mapper.parser.SemanticMapperContext;

class SPathForEachAliasExpression
extends Expression {
    private static final int SEM_TYPE = 0;
    private static final int SPATH = 1;

    SPathForEachAliasExpression() {
        super(Expression.ExpressionType.SPATH);
    }

    public void setSpath(String spath) {
        this.exprs.add(1, spath);
    }

    public String getSpath() {
        return (String)this.exprs.get(1);
    }

    public void setSemType(String type) {
        this.exprs.add(0, type);
    }

    public String getSemType() {
        return (String)this.exprs.get(0);
    }

    @Override
    Object evaluate(SemanticMapperContext ctx) throws SemanticMapperException {
        this.evaluateParams(ctx);
        if (this.params.get(1) instanceof String) {
            try {
                Object temp = ctx.getMappingObject(this.getSemType());
                if (temp == null) {
                    throw new SemanticMapperException(3013, "Invalid semantic type '" + this.getSemType() + "' specified.");
                }
                return ctx.getSdrManager().getValueAtPath(this.getSpath(), temp);
            }
            catch (Exception error) {
                throw new SemanticMapperException(3013, error.getMessage());
            }
        }
        return super.evaluate(ctx);
    }
}

