/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.mapper.parser;

import com.streamscape.omf.mapper.SemanticMapperException;
import com.streamscape.omf.mapper.parser.Expression;
import com.streamscape.omf.mapper.parser.SemanticMapperContext;

public class SPathExpression
extends Expression {
    private static final int ALIAS = 0;
    private static final int SPATH = 1;

    SPathExpression() {
        super(Expression.ExpressionType.SPATH);
    }

    SPathExpression(Expression.ExpressionType type) {
        super(type);
    }

    public void setSpath(String spath) {
        this.exprs.add(1, spath);
    }

    public boolean hasSpath() {
        return this.exprs.size() > 1;
    }

    public String getSpath() {
        return (String)this.exprs.get(1);
    }

    public void setAlias(String type) {
        this.exprs.add(0, type);
    }

    public String getAlias() {
        return (String)this.exprs.get(0);
    }

    @Override
    Object evaluate(SemanticMapperContext ctx) throws SemanticMapperException {
        this.evaluateParams(ctx);
        try {
            Object temp = ctx.getMappingObject(this.getAlias());
            if (temp == null) {
                throw new SemanticMapperException(3013, "Invalid alias '" + this.getAlias() + "' specified.");
            }
            if (!this.hasSpath()) {
                return temp;
            }
            if (this.params.get(1) instanceof String) {
                return ctx.getSdrManager().getValueAtPath(this.getSpath(), temp);
            }
        }
        catch (Exception error) {
            throw new SemanticMapperException(3013, error.getMessage());
        }
        return super.evaluate(ctx);
    }

    @Override
    public String toString() {
        return this.getSpath();
    }
}

