/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.mapper.parser;

import com.streamscape.omf.mapper.parser.AssignmentStatement;
import com.streamscape.omf.mapper.parser.CaseStatement;
import com.streamscape.omf.mapper.parser.DataspaceFunction;
import com.streamscape.omf.mapper.parser.EchoStatement;
import com.streamscape.omf.mapper.parser.Expression;
import com.streamscape.omf.mapper.parser.ForEachStatement;
import com.streamscape.omf.mapper.parser.Function;
import com.streamscape.omf.mapper.parser.FunctionExpression;
import com.streamscape.omf.mapper.parser.IfStatement;
import com.streamscape.omf.mapper.parser.SPathExpression;
import com.streamscape.omf.mapper.parser.SPathSequenceExpression;
import com.streamscape.omf.mapper.parser.SemanticMapperContext;
import com.streamscape.omf.mapper.parser.Statement;
import com.streamscape.omf.mapper.parser.TokenType;
import com.streamscape.sdo.excp.ValidationException;
import java.util.ArrayList;
import java.util.List;

public class Parser {
    String buffer = null;
    int counter = 0;
    Token currentToken = new Token(this);
    boolean isLiteral;
    int literalBegin;

    public Statement parse(SemanticMapperContext context, String rule) throws ValidationException {
        return this.parse(context, rule, true);
    }

    public Statement parse(SemanticMapperContext ctx, String rule, boolean reset) throws ValidationException {
        if (reset) {
            this.buffer = ctx.getMacroProcessor().process(rule);
            this.counter = 0;
        }
        int counterBeforeParse = this.counter;
        if (this.readNextToken()) {
            this.counter = counterBeforeParse;
            switch (this.currentToken.type) {
                case ALIAS: {
                    Expression leftExpression = this.readExpression(ctx);
                    this.readToken(TokenType.ASSIGNMENT_OPERAND);
                    Expression rightExpression = this.readExpression(ctx);
                    AssignmentStatement stat = new AssignmentStatement();
                    stat.setLeftExpression(leftExpression);
                    stat.setRightExpression(rightExpression);
                    return stat;
                }
                case FOR: {
                    String sequenceAlias = null;
                    this.readToken(TokenType.FOR);
                    this.readToken(TokenType.EACH);
                    this.readToken(TokenType.OPEN_BRACKET);
                    Expression sourcePath = this.readExpression(ctx);
                    this.readToken(TokenType.CLOSE_BRACKET);
                    int currentCounter = this.counter;
                    try {
                        this.readToken(TokenType.AS);
                        if (this.readNextToken() && this.currentToken.value instanceof String) {
                            sequenceAlias = (String)this.currentToken.value;
                        }
                    }
                    catch (Exception err) {
                        this.counter = currentCounter;
                    }
                    this.readToken(TokenType.OPEN_BRACKET);
                    ArrayList<Statement> subStats = new ArrayList<Statement>();
                    while (this.currentToken.type != TokenType.CLOSE_BRACKET) {
                        Statement temp = this.parse(ctx, rule, false);
                        subStats.add(temp);
                        currentCounter = this.counter;
                        try {
                            this.readToken(TokenType.SEMICOLON);
                        }
                        catch (Exception err) {
                            this.counter = currentCounter;
                        }
                        currentCounter = this.counter;
                        try {
                            this.readToken(TokenType.CLOSE_BRACKET);
                        }
                        catch (Exception err) {
                            this.counter = currentCounter;
                        }
                    }
                    ForEachStatement stat = new ForEachStatement();
                    stat.setExpression(sourcePath);
                    stat.setSubStats(subStats);
                    if (sequenceAlias != null) {
                        stat.setSequenceAlias(sequenceAlias);
                    }
                    return stat;
                }
                case IF: {
                    this.readToken(TokenType.IF);
                    this.readToken(TokenType.OPEN_BRACKET);
                    Expression condition = this.readExpression(ctx);
                    this.readToken(TokenType.CLOSE_BRACKET);
                    this.readToken(TokenType.THEN);
                    this.readToken(TokenType.OPEN_BRACKET);
                    Statement mainStatement = this.parse(ctx, rule, false);
                    this.readToken(TokenType.CLOSE_BRACKET);
                    int currentCounter = this.counter;
                    Statement elseStatement = null;
                    try {
                        this.readToken(TokenType.ELSE);
                        this.readToken(TokenType.OPEN_BRACKET);
                        elseStatement = this.parse(ctx, rule, false);
                        this.readToken(TokenType.CLOSE_BRACKET);
                    }
                    catch (Exception err) {
                        this.counter = currentCounter;
                    }
                    IfStatement stat = new IfStatement();
                    stat.setCondition(condition);
                    stat.setMainStatement(mainStatement);
                    if (elseStatement != null) {
                        stat.setElseStatement(elseStatement);
                    }
                    return stat;
                }
                case CASE: {
                    this.readToken(TokenType.CASE);
                    this.readToken(TokenType.OPEN_BRACKET);
                    Expression leftOperand = this.readExpression(ctx);
                    this.readToken(TokenType.CLOSE_BRACKET);
                    CaseStatement caseStatement = new CaseStatement();
                    caseStatement.setConditionExpression(leftOperand);
                    boolean statementParsed = false;
                    while (!statementParsed) {
                        int temp = this.counter;
                        try {
                            this.readToken(TokenType.WHEN);
                            Expression expr = this.readExpression(ctx);
                            this.readToken(TokenType.OPEN_BRACKET);
                            Statement stat = this.parse(ctx, rule, false);
                            this.readToken(TokenType.CLOSE_BRACKET);
                            caseStatement.addCase(expr, stat);
                            try {
                                this.readToken(TokenType.SEMICOLON);
                            }
                            catch (Exception exception) {
                            }
                        }
                        catch (Exception err) {
                            this.counter = temp;
                            statementParsed = true;
                        }
                    }
                    return caseStatement;
                }
                case ECHO: {
                    Expression msg = this.readExpression(ctx);
                    EchoStatement stat = new EchoStatement();
                    stat.setMessage(msg);
                    return stat;
                }
            }
            throw new ValidationException(3013, "Unexpected token '" + String.valueOf(this.currentToken.value) + "' encountered in the mapping rule.");
        }
        throw new ValidationException(3013, "Unexpected end of semantic mapper rule.");
    }

    private FunctionExpression lookupFunction(SemanticMapperContext ctx, String name) throws ValidationException {
        Function function = Function.lookupFunction(this.currentToken.value.toString());
        if (function != null) {
            FunctionExpression functionExpression = new FunctionExpression(function);
            functionExpression.parse(this, ctx);
            return functionExpression;
        }
        if (ctx.getUserDsFunctions().contains(name)) {
            function = new DataspaceFunction(name);
            FunctionExpression functionExpression = new FunctionExpression(function);
            functionExpression.parse(this, ctx);
            return functionExpression;
        }
        return null;
    }

    Expression readExpression(SemanticMapperContext ctx) throws ValidationException {
        Expression current = null;
        block17: while (this.readNextToken()) {
            switch (this.currentToken.type) {
                case LITERAL: {
                    FunctionExpression function = this.lookupFunction(ctx, this.currentToken.value.toString());
                    if (function != null) {
                        current = function;
                        continue block17;
                    }
                    current = new Expression(Expression.ExpressionType.VALUE);
                    current.addExpr(this.currentToken.value);
                    continue block17;
                }
                case STRING_LITERAL: {
                    FunctionExpression function = this.lookupFunction(ctx, this.currentToken.value.toString());
                    if (function != null) {
                        current = function;
                        continue block17;
                    }
                    current = new Expression(Expression.ExpressionType.STRING_VALUE);
                    current.addExpr(this.currentToken.value);
                    continue block17;
                }
                case ALIAS: {
                    String semType = (String)this.currentToken.value;
                    int temp = this.counter;
                    this.readNextToken();
                    if (this.currentToken.type == TokenType.SPATH) {
                        String spath = (String)this.currentToken.value;
                        int index = 0;
                        index = spath.indexOf(42);
                        if (index > 0) {
                            current = new SPathSequenceExpression();
                            ((SPathSequenceExpression)current).setAlias(semType);
                            String sequenceSpath = spath.substring(index + 1);
                            spath = spath.substring(0, index);
                            index = spath.lastIndexOf(91);
                            if (index != -1) {
                                spath = spath.substring(0, index);
                            }
                            ((SPathSequenceExpression)current).setSpath(spath);
                            index = sequenceSpath.indexOf(93);
                            if (index != -1) {
                                sequenceSpath = sequenceSpath.substring(index + 1);
                            }
                            ((SPathSequenceExpression)current).setSequenceSpath(sequenceSpath);
                            continue block17;
                        }
                        current = new SPathExpression();
                        ((SPathExpression)current).setAlias(semType);
                        ((SPathExpression)current).setSpath(spath);
                        continue block17;
                    }
                    current = new SPathExpression();
                    ((SPathExpression)current).setAlias(semType);
                    this.counter = temp;
                    return current;
                }
                case CONCATENATION: {
                    if (current == null) continue block17;
                    Expression temp = new Expression(Expression.ExpressionType.CONCAT);
                    temp.addExpr(current);
                    temp.addExpr(this.readExpression(ctx));
                    current = temp;
                    continue block17;
                }
                case GREATER_THAN: {
                    if (current == null) continue block17;
                    Expression temp = new Expression(Expression.ExpressionType.GREATER_THAN);
                    temp.addExpr(current);
                    temp.addExpr(this.readExpression(ctx));
                    current = temp;
                    continue block17;
                }
                case GREATER_OR_EQUALS_THAN: {
                    if (current == null) continue block17;
                    Expression temp = new Expression(Expression.ExpressionType.GREATER_OR_EQUALS_THAN);
                    temp.addExpr(current);
                    temp.addExpr(this.readExpression(ctx));
                    current = temp;
                    continue block17;
                }
                case LESS_THAN: {
                    if (current == null) continue block17;
                    Expression temp = new Expression(Expression.ExpressionType.LESS_THAN);
                    temp.addExpr(current);
                    temp.addExpr(this.readExpression(ctx));
                    current = temp;
                    continue block17;
                }
                case LESS_OR_EQUALS_THAN: {
                    if (current == null) continue block17;
                    Expression temp = new Expression(Expression.ExpressionType.LESS_OR_EQUALS_THAN);
                    temp.addExpr(current);
                    temp.addExpr(this.readExpression(ctx));
                    current = temp;
                    continue block17;
                }
                case EQUALS: {
                    if (current == null) continue block17;
                    Expression temp = new Expression(Expression.ExpressionType.EQUALS);
                    temp.addExpr(current);
                    temp.addExpr(this.readExpression(ctx));
                    current = temp;
                    continue block17;
                }
                case NOT_EQUALS: {
                    if (current == null) continue block17;
                    Expression temp = new Expression(Expression.ExpressionType.NOT_EQUALS);
                    temp.addExpr(current);
                    temp.addExpr(this.readExpression(ctx));
                    current = temp;
                    continue block17;
                }
                case IS: {
                    if (current == null) continue block17;
                    boolean isNot = false;
                    int currentCounter = this.counter;
                    try {
                        this.readToken(TokenType.NOT);
                        isNot = true;
                    }
                    catch (Exception err) {
                        this.counter = currentCounter;
                        this.readToken(TokenType.NULL);
                    }
                    Expression temp = new Expression(isNot ? Expression.ExpressionType.IS_NOT_NULL : Expression.ExpressionType.IS_NULL);
                    temp.addExpr(current);
                    current = temp;
                    continue block17;
                }
                case IN: {
                    if (current != null) {
                        int tempCounter = this.counter;
                        if (this.readNextToken()) {
                            Expression expr;
                            this.counter = tempCounter;
                            if (this.currentToken.type == TokenType.DOMAIN) {
                                Expression temp = new Expression(Expression.ExpressionType.IN_DOMAIN);
                                this.readToken(TokenType.DOMAIN);
                                expr = this.readExpression(ctx);
                                temp.addExpr(current);
                                temp.addExpr(expr);
                                return temp;
                            }
                            if (this.currentToken.type == TokenType.RANGE) {
                                Expression temp = new Expression(Expression.ExpressionType.IN_RANGE);
                                this.readToken(TokenType.RANGE);
                                expr = this.readExpression(ctx);
                                temp.addExpr(current);
                                temp.addExpr(expr);
                                current = temp;
                                continue block17;
                            }
                        } else {
                            throw new ValidationException(3013, "Unexpected end of semantic mapper expression. '" + TokenType.DOMAIN.getValue() + "' or '" + TokenType.RANGE.getValue() + "' is expected.");
                        }
                    }
                }
                case OPEN_BRACKET: 
                case CLOSE_BRACKET: 
                case COMMA: 
                case ASSIGNMENT_OPERAND: 
                case SEMICOLON: {
                    --this.counter;
                    return current;
                }
            }
            FunctionExpression function = this.lookupFunction(ctx, this.currentToken.value.toString());
            if (function == null) continue;
            current = function;
        }
        return current;
    }

    List<Expression> readQueryExpression(SemanticMapperContext ctx) throws ValidationException {
        ArrayList<Expression> result = new ArrayList<Expression>();
        this.readToken(TokenType.OPEN_BRACKET);
        StringBuilder buffer = new StringBuilder();
        int nestedParenthesis = 0;
        boolean completed = false;
        block7: while (!completed && this.readNextToken()) {
            switch (this.currentToken.type) {
                case ALIAS: {
                    SPathExpression spathExpr = null;
                    String semType = (String)this.currentToken.value;
                    int temp = this.counter;
                    try {
                        this.readNextToken();
                        if (this.currentToken.type == TokenType.SPATH) {
                            String spath = (String)this.currentToken.value;
                            spathExpr = new SPathExpression();
                            spathExpr.setAlias(semType);
                            spathExpr.setSpath(spath);
                        } else {
                            spathExpr = new SPathExpression();
                            spathExpr.setAlias(semType);
                            this.counter = temp;
                        }
                    }
                    catch (Exception error) {
                        buffer.append(semType).append(' ');
                        this.counter = temp;
                    }
                    if (spathExpr == null) continue block7;
                    result.add(spathExpr);
                    buffer.append(" ? ");
                    continue block7;
                }
                case OPEN_BRACKET: {
                    buffer.append(this.currentToken.value.toString());
                    ++nestedParenthesis;
                    continue block7;
                }
                case CLOSE_BRACKET: {
                    if (nestedParenthesis == 0) {
                        --this.counter;
                        completed = true;
                        continue block7;
                    }
                    buffer.append(this.currentToken.value.toString());
                    --nestedParenthesis;
                    continue block7;
                }
            }
            if (this.currentToken.type == TokenType.STRING_LITERAL) {
                buffer.append("'");
            }
            buffer.append(this.currentToken.value.toString());
            if (this.currentToken.type == TokenType.STRING_LITERAL) {
                buffer.append("'");
            }
            buffer.append(' ');
        }
        this.readToken(TokenType.CLOSE_BRACKET);
        Expression query = new Expression(Expression.ExpressionType.VALUE);
        query.addExpr(buffer.toString());
        result.add(0, query);
        return result;
    }

    void readToken(TokenType tokenType) throws ValidationException {
        if (this.readNextToken()) {
            if (this.currentToken.type != tokenType) {
                throw new ValidationException(3013, "Unexpected token '" + String.valueOf(this.currentToken.value) + "' encountered. Token of type '" + tokenType.name() + "' is expected.");
            }
        } else {
            throw new ValidationException(3013, "Unexpected end of semantic mapper expression. '" + tokenType.name() + "' is expected.");
        }
    }

    private boolean readNextToken() throws ValidationException {
        this.literalBegin = this.counter;
        this.isLiteral = false;
        block18: while (this.counter < this.buffer.length()) {
            switch (this.buffer.charAt(this.counter)) {
                case '\'': {
                    if (this.isLiteral) {
                        this.processLiteral();
                        return true;
                    }
                    this.literalBegin = ++this.counter;
                    while (this.counter < this.buffer.length()) {
                        if (this.buffer.charAt(this.counter) == '\'') {
                            this.currentToken.type = TokenType.STRING_LITERAL;
                            this.currentToken.value = this.buffer.substring(this.literalBegin, this.counter);
                            ++this.counter;
                            return true;
                        }
                        ++this.counter;
                    }
                    continue block18;
                }
                case '\"': {
                    if (this.isLiteral) {
                        this.processLiteral();
                        return true;
                    }
                    this.literalBegin = ++this.counter;
                    while (this.counter < this.buffer.length()) {
                        if (this.buffer.charAt(this.counter) == '\"') {
                            this.currentToken.type = TokenType.LITERAL;
                            this.currentToken.value = this.buffer.substring(this.literalBegin, this.counter);
                            ++this.counter;
                            return true;
                        }
                        ++this.counter;
                    }
                    continue block18;
                }
                case '+': {
                    if (this.isLiteral) {
                        this.processLiteral();
                        return true;
                    }
                    this.currentToken.type = TokenType.CONCATENATION;
                    this.currentToken.value = "+";
                    ++this.counter;
                    return true;
                }
                case '=': {
                    if (this.isLiteral) {
                        this.processLiteral();
                        return true;
                    }
                    this.currentToken.type = TokenType.ASSIGNMENT_OPERAND;
                    this.currentToken.value = "=";
                    ++this.counter;
                    if (this.counter < this.buffer.length() && this.buffer.charAt(this.counter) == '=') {
                        this.currentToken.type = TokenType.EQUALS;
                        ++this.counter;
                    }
                    return true;
                }
                case '!': {
                    if (this.isLiteral) {
                        this.processLiteral();
                        return true;
                    }
                    this.currentToken.type = TokenType.NOT_OPERAND;
                    this.currentToken.value = "!";
                    ++this.counter;
                    if (this.counter < this.buffer.length() && this.buffer.charAt(this.counter) == '=') {
                        this.currentToken.type = TokenType.NOT_EQUALS;
                        ++this.counter;
                    }
                    return true;
                }
                case '%': {
                    if (this.isLiteral) {
                        this.processLiteral();
                        return true;
                    }
                    ++this.counter;
                    this.literalBegin = this.counter;
                    while (this.counter < this.buffer.length() && this.buffer.charAt(this.counter) != ':' && Character.isJavaIdentifierPart(this.buffer.charAt(this.counter))) {
                        ++this.counter;
                    }
                    this.currentToken.type = TokenType.ALIAS;
                    this.currentToken.value = this.buffer.substring(this.literalBegin, this.counter);
                    if (this.counter < this.buffer.length() && this.buffer.charAt(this.counter) == ':') {
                        ++this.counter;
                    }
                    return true;
                }
                case '/': {
                    if (this.isLiteral) {
                        this.processLiteral();
                        return true;
                    }
                    this.literalBegin = this.counter++;
                    if (this.buffer.charAt(this.counter) == '/') {
                        while (this.counter < this.buffer.length() && this.buffer.charAt(this.counter) != ' ' && this.buffer.charAt(this.counter) != ')' && this.buffer.charAt(this.counter) != '(' && this.buffer.charAt(this.counter) != ',' && this.buffer.charAt(this.counter) != ';') {
                            ++this.counter;
                        }
                        this.currentToken.type = TokenType.SPATH;
                        this.currentToken.value = this.buffer.substring(this.literalBegin, this.counter);
                        return true;
                    }
                }
                case '(': {
                    if (this.isLiteral) {
                        this.processLiteral();
                        return true;
                    }
                    ++this.counter;
                    this.currentToken.type = TokenType.OPEN_BRACKET;
                    this.currentToken.value = "(";
                    return true;
                }
                case ')': {
                    if (this.isLiteral) {
                        this.processLiteral();
                        return true;
                    }
                    ++this.counter;
                    this.currentToken.type = TokenType.CLOSE_BRACKET;
                    this.currentToken.value = ")";
                    return true;
                }
                case ',': {
                    if (this.isLiteral) {
                        this.processLiteral();
                        return true;
                    }
                    ++this.counter;
                    this.currentToken.type = TokenType.COMMA;
                    this.currentToken.value = ",";
                    return true;
                }
                case ';': {
                    if (this.isLiteral) {
                        this.processLiteral();
                        return true;
                    }
                    ++this.counter;
                    this.currentToken.type = TokenType.SEMICOLON;
                    this.currentToken.value = ";";
                    return true;
                }
                case ':': {
                    if (this.isLiteral) {
                        this.processLiteral();
                        return true;
                    }
                    ++this.counter;
                    this.currentToken.type = TokenType.COLON;
                    this.currentToken.value = ":";
                    return true;
                }
                case ' ': {
                    if (this.isLiteral) {
                        this.processLiteral();
                        return true;
                    }
                    ++this.counter;
                    continue block18;
                }
                case '>': {
                    if (this.isLiteral) {
                        this.processLiteral();
                        return true;
                    }
                    this.currentToken.type = TokenType.GREATER_THAN;
                    this.currentToken.value = ">";
                    ++this.counter;
                    if (this.counter < this.buffer.length() && this.buffer.charAt(this.counter) == '=') {
                        this.currentToken.type = TokenType.GREATER_OR_EQUALS_THAN;
                        ++this.counter;
                    }
                    return true;
                }
                case '<': {
                    if (this.isLiteral) {
                        this.processLiteral();
                        return true;
                    }
                    this.currentToken.type = TokenType.LESS_THAN;
                    this.currentToken.value = "<";
                    ++this.counter;
                    if (this.counter < this.buffer.length() && this.buffer.charAt(this.counter) == '=') {
                        this.currentToken.type = TokenType.LESS_OR_EQUALS_THAN;
                        ++this.counter;
                    }
                    return true;
                }
                case '\t': 
                case '\n': {
                    ++this.counter;
                    continue block18;
                }
            }
            if (!this.isLiteral) {
                this.isLiteral = true;
                this.literalBegin = this.counter;
            }
            ++this.counter;
        }
        if (this.isLiteral) {
            this.processLiteral();
            return true;
        }
        return false;
    }

    private void processLiteral() {
        this.currentToken.value = this.buffer.substring(this.literalBegin, this.counter);
        TokenType type = TokenType.tokenByString(((String)this.currentToken.value).toUpperCase());
        this.currentToken.type = type != null ? type : TokenType.LITERAL;
        this.isLiteral = false;
    }

    private void processError(String error) throws ValidationException {
        throw new ValidationException(3013, error);
    }

    class Token {
        TokenType type;
        Object value;

        Token(Parser this$0) {
        }
    }
}

