/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.mapper.parser;

import com.streamscape.Trace;
import com.streamscape.omf.mapper.SemanticMapperException;
import com.streamscape.omf.mapper.parser.SemanticMapperContext;
import com.streamscape.omf.mapper.parser.SequenceHandler;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

class MapHandler
extends SequenceHandler {
    Field field;

    MapHandler(Class<?> sequenceClass, Object sequence, Field field) {
        super(sequenceClass, sequence);
        this.field = field;
    }

    @Override
    void init(SemanticMapperContext ctx, Object parentObject, String parentSpath) throws SemanticMapperException {
        try {
            String sequenceElementClassName = null;
            try {
                sequenceElementClassName = ctx.getTypeAnalyzer().getFieldTypeAsString(parentObject.getClass(), parentSpath + "/value");
            }
            catch (Exception error) {
                sequenceElementClassName = this.getCollectionElementType(this.sequenceClass, this.field);
            }
            if (sequenceElementClassName == null) {
                ctx.raiseError("Unable to determine sequence element type.");
            }
            this.sequenceElementClass = ctx.loadClass(sequenceElementClassName);
            if (this.sequence == null) {
                this.sequence = this.sequenceClass.isInterface() ? new HashMap() : ctx.instantiateClass(this.sequenceClass);
                ctx.getSdrManager().setValueAtPath(parentSpath, parentObject, this.sequence);
                this.currentValue = ctx.instantiateClass(this.sequenceElementClass);
                ((Map)this.sequence).put(ctx.getSequenceKey(), this.currentValue);
            } else {
                this.iterator = ((Map)this.sequence).entrySet().iterator();
                if (this.iterator != null && this.iterator.hasNext()) {
                    this.currentValue = ((Map.Entry)this.iterator.next()).getValue();
                } else {
                    this.iterator = null;
                    this.currentValue = ctx.instantiateClass(this.sequenceElementClass);
                    ((Map)this.sequence).put(ctx.getSequenceKey(), this.currentValue);
                }
            }
        }
        catch (Exception error) {
            Trace.logException(this, error, true);
            ctx.raiseError(error.getMessage());
        }
    }

    @Override
    void moveToNext(SemanticMapperContext ctx) throws SemanticMapperException {
        try {
            if (this.iterator != null && this.iterator.hasNext()) {
                this.currentValue = ((Map.Entry)this.iterator.next()).getValue();
            } else {
                this.currentValue = ctx.instantiateClass(this.sequenceElementClass);
                ((Map)this.sequence).put(ctx.getSequenceKey(), this.currentValue);
            }
        }
        catch (Exception error) {
            Trace.logException(this, error, true);
            ctx.raiseError(error.getMessage());
        }
    }
}

