/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.mapper.parser;

import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.lib.analyzer.TypeAnalyzerFactory;
import com.streamscape.lib.utils.MacroProcessor;
import com.streamscape.omf.mapper.SemanticMapperException;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.DomainConstraint;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.RangeConstraint;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import com.streamscape.sef.dispatcher.AbstractDataspaceComponent;
import com.streamscape.sef.dispatcher.SemanticMapperHelper;
import com.streamscape.sef.service.ServiceContext;

public class LocalSemanticMapperContext
extends SemanticMapperHelper {
    private FabricConnection connection;
    private FabricComponent component;

    public LocalSemanticMapperContext(ClassLoader classLoader) {
        super(classLoader != null ? classLoader : RuntimeContext.getInstance().getSystemClassLoaderChain());
        this.doSetSdrManager(RuntimeContext.getInstance().getSDRManagerFactory().createManager());
        this.doSetTypeAnalyzer(TypeAnalyzerFactory.getInstance().createTypeAnalyzer());
        this.doSetMacroProcessor(new MacroProcessor(RuntimeContext.getInstance().getModerator()));
        this.doSetSemanticTypeCache(RuntimeContext.getInstance().getSemanticTypeCache());
    }

    public LocalSemanticMapperContext(ClassLoader classLoader, FabricComponent component) {
        this(classLoader);
        this.component = component;
    }

    public LocalSemanticMapperContext(ClassLoader classLoader, FabricConnection connection) {
        this(classLoader);
        this.connection = connection;
    }

    @Override
    protected DataspaceAccessor doCreateDataspaceAccessor(String nodeName, DataspaceType dataspaceType, String dataspaceName) throws FabricComponentAccessorException, FabricConnectionException {
        DataspaceAccessor accessor = null;
        if (this.component instanceof ServiceContext) {
            accessor = nodeName != null ? ((ServiceContext)this.component).createDataspaceAccessor(nodeName, dataspaceType, dataspaceName) : ((ServiceContext)this.component).createDataspaceAccessor(dataspaceType, dataspaceName);
        } else if (this.component instanceof AbstractDataspaceComponent) {
            accessor = nodeName != null ? ((AbstractDataspaceComponent)this.component).createDataspaceAccessor(nodeName, dataspaceType, dataspaceName) : ((AbstractDataspaceComponent)this.component).createDataspaceAccessor(dataspaceType, dataspaceName);
        } else if (this.connection instanceof FabricConnection) {
            accessor = nodeName != null ? this.connection.createDataspaceAccessor(nodeName, dataspaceType, dataspaceName) : this.connection.createDataspaceAccessor(dataspaceType, dataspaceName);
        }
        return accessor;
    }

    @Override
    public DomainConstraint getDomainConstraint(String domainName) throws FabricEventDispatcherException, FabricConnectionException, SemanticMapperException {
        if (this.connection != null) {
            return this.connection.getDomainConstraint(domainName);
        }
        if (this.component != null) {
            return LocalSemanticMapperContext.getDispatcher(this.component).getDomainConstraint(domainName);
        }
        throw new SemanticMapperException(3013, "Failed to get domain constraint, fabric component/connection is not set.");
    }

    @Override
    public RangeConstraint getRangeConstraint(String rangeName) throws FabricEventDispatcherException, FabricConnectionException, SemanticMapperException {
        if (this.connection != null) {
            return this.connection.getRangeConstraint(rangeName);
        }
        if (this.component != null) {
            return LocalSemanticMapperContext.getDispatcher(this.component).getRangeConstraint(rangeName);
        }
        throw new SemanticMapperException(3013, "Failed to get range constraint, fabric component/connection is not set.");
    }
}

