/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.mapper.parser;

import com.streamscape.Trace;
import com.streamscape.omf.mapper.SemanticMapperException;
import com.streamscape.omf.mapper.parser.SemanticMapperContext;
import com.streamscape.omf.mapper.parser.SequenceHandler;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

class ListHandler
extends SequenceHandler {
    Field field;

    ListHandler(Class<?> sequenceClass, Object sequence, Field field) {
        super(sequenceClass, sequence);
        this.field = field;
    }

    @Override
    void init(SemanticMapperContext ctx, Object parentObject, String parentSpath) throws SemanticMapperException {
        try {
            String sequenceElementClassName = null;
            try {
                sequenceElementClassName = ctx.getTypeAnalyzer().getFieldTypeAsString(parentObject.getClass(), parentSpath + "/value");
            }
            catch (Exception error) {
                sequenceElementClassName = this.getCollectionElementType(this.sequenceClass, this.field);
            }
            if (sequenceElementClassName == null) {
                ctx.raiseError("Unable to determine sequence element type.");
            }
            this.sequenceElementClass = ctx.loadClass(sequenceElementClassName);
            if (this.sequence == null) {
                this.sequence = this.sequenceClass.isInterface() ? new ArrayList() : ctx.instantiateClass(this.sequenceClass);
                ctx.getSdrManager().setValueAtPath(parentSpath, parentObject, this.sequence);
                this.currentValue = ctx.instantiateClass(this.sequenceElementClass);
                ((List)this.sequence).add(this.currentValue);
            } else {
                this.iterator = ((List)this.sequence).iterator();
                if (this.iterator.hasNext()) {
                    this.currentValue = this.iterator.next();
                } else {
                    this.iterator = null;
                    this.currentValue = ctx.instantiateClass(this.sequenceElementClass);
                    ((List)this.sequence).add(this.currentValue);
                }
            }
        }
        catch (Exception error) {
            Trace.logException(this, error, true);
            ctx.raiseError(error.getMessage());
        }
    }

    @Override
    void moveToNext(SemanticMapperContext ctx) throws SemanticMapperException {
        try {
            if (this.iterator != null && this.iterator.hasNext()) {
                this.currentValue = this.iterator.next();
            } else {
                this.currentValue = ctx.instantiateClass(this.sequenceElementClass);
                ((List)this.sequence).add(this.currentValue);
            }
        }
        catch (Exception error) {
            Trace.logException(this, error, true);
            ctx.raiseError(error.getMessage());
        }
    }
}

