/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.mapper.parser;

import com.streamscape.omf.mapper.SemanticMapperException;
import com.streamscape.omf.mapper.parser.NumberHelper;

class IntegerHelper
extends NumberHelper<Integer> {
    IntegerHelper() {
    }

    @Override
    int compare(Object first, Object second) throws SemanticMapperException {
        return this.checkValue(first).compareTo(this.checkValue(second));
    }

    @Override
    Object getDefaultValue() {
        return Integer.valueOf("0");
    }

    @Override
    Object sum(Object first, Object second) throws SemanticMapperException {
        return this.checkValue(first) + this.checkValue(second);
    }

    @Override
    Object divide(Object first, Object second) throws SemanticMapperException {
        return this.checkValue(first) / this.checkValue(second);
    }

    @Override
    Integer checkValue(Object value) throws SemanticMapperException {
        if (value == null) {
            throw new SemanticMapperException(3013, "NULL value is passed instead of number value.");
        }
        if (value instanceof String) {
            return Integer.valueOf((String)value);
        }
        if (!(value instanceof Integer) && value instanceof Number) {
            return ((Number)value).intValue();
        }
        return (Integer)value;
    }
}

