/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.mapper.parser;

import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.omf.mapper.SemanticMapperException;
import com.streamscape.omf.mapper.parser.DataspaceFunction;
import com.streamscape.omf.mapper.parser.Expression;
import com.streamscape.omf.mapper.parser.FunctionExpression;
import com.streamscape.omf.mapper.parser.NumberHelper;
import com.streamscape.omf.mapper.parser.Parser;
import com.streamscape.omf.mapper.parser.SemanticMapperContext;
import com.streamscape.omf.mapper.parser.TokenType;
import com.streamscape.sdo.excp.ValidationException;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowSet;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Function {
    static Map<String, Function> builtinFunctions = new HashMap<String, Function>();
    static Map<String, Function> dataspaceFunctions = new HashMap<String, Function>();

    static Object processRowSet(RowSet rs) throws SemanticMapperException {
        block8: {
            try {
                if (rs.getRowMetaData().getColumnCount() > 1) {
                    if (rs.next()) {
                        Row row = rs.getCurrentRow();
                        if (rs.next()) {
                            rs.beforeFirst();
                            return rs;
                        }
                        return row;
                    }
                    break block8;
                }
                ArrayList<Object> values = new ArrayList<Object>();
                while (rs.next()) {
                    values.add(rs.getObject(1));
                }
                if (values.size() == 1) {
                    return values.get(0);
                }
                if (values.size() > 0) {
                    return values;
                }
                return null;
            }
            catch (Exception error) {
                throw new SemanticMapperException(3013, error.getMessage());
            }
        }
        return null;
    }

    private static void registerDataspaceFunction(String name) {
        dataspaceFunctions.put(name, new DataspaceFunction(name){});
    }

    public static Function lookupFunction(String name) {
        Function result = builtinFunctions.get(name.toLowerCase());
        if (result != null) {
            return result;
        }
        result = dataspaceFunctions.get(name.toLowerCase());
        if (result != null) {
            return result;
        }
        return dataspaceFunctions.get(name);
    }

    void parse(Parser parser, SemanticMapperContext ctx, FunctionExpression parent) throws ValidationException {
    }

    Object invoke(SemanticMapperContext ctx, FunctionExpression parent) throws SemanticMapperException {
        return null;
    }

    String toString(FunctionExpression parent) {
        return "noname";
    }

    static {
        builtinFunctions.put("count", new Function(){

            @Override
            void parse(Parser parser, SemanticMapperContext ctx, FunctionExpression parent) throws ValidationException {
                parser.readToken(TokenType.OPEN_BRACKET);
                parent.addExpr(parser.readExpression(ctx));
                parser.readToken(TokenType.CLOSE_BRACKET);
            }

            @Override
            Object invoke(SemanticMapperContext ctx, FunctionExpression parent) {
                if (parent.params.get(0) instanceof Collection) {
                    return ((Collection)parent.params.get(0)).size();
                }
                if (parent.params.get(0) instanceof Map) {
                    return ((Map)parent.params.get(0)).size();
                }
                if (parent.params.get(0) != null && parent.params.get(0).getClass().isArray()) {
                    return Array.getLength(parent.params.get(0));
                }
                return -1;
            }

            public String toString() {
                return "count()";
            }
        });
        builtinFunctions.put("min", new Function(){

            @Override
            void parse(Parser parser, SemanticMapperContext ctx, FunctionExpression parent) throws ValidationException {
                parser.readToken(TokenType.OPEN_BRACKET);
                parent.addExpr(parser.readExpression(ctx));
                parser.readToken(TokenType.CLOSE_BRACKET);
            }

            @Override
            Object invoke(SemanticMapperContext ctx, FunctionExpression parent) throws SemanticMapperException {
                if (parent.params.get(0) instanceof Collection) {
                    if (((Collection)parent.params.get(0)).size() == 0) {
                        ctx.raiseError("Empty collection is passed into MIN function.");
                    }
                    NumberHelper<?> comparator = NumberHelper.getComparator(ctx, parent.params.get(0).getClass().getTypeParameters()[0].getGenericDeclaration());
                    Iterator iter = ((Collection)parent.params.get(0)).iterator();
                    Object min = null;
                    while (iter.hasNext()) {
                        Object next = iter.next();
                        if (min == null) {
                            min = next;
                            continue;
                        }
                        if (comparator.compare(next, min) >= 0) continue;
                        min = next;
                    }
                    return min;
                }
                if (parent.params.get(0) != null && parent.params.get(0).getClass().isArray()) {
                    if (Array.getLength(parent.params.get(0)) == 0) {
                        ctx.raiseError("Empty array is passed into MIN function.");
                    }
                    NumberHelper<?> comparator = NumberHelper.getComparator(ctx, parent.params.get(0).getClass().getComponentType());
                    Comparable min = null;
                    for (int i = 0; i < Array.getLength(parent.params.get(0)); ++i) {
                        Comparable next = (Comparable)Array.get(parent.params.get(0), i);
                        if (min == null) {
                            min = next;
                            continue;
                        }
                        if (comparator.compare(next, min) >= 0) continue;
                        min = next;
                    }
                    return min;
                }
                ctx.raiseError("Unsupported argument is passed to MIN function.");
                return null;
            }

            public String toString() {
                return "min()";
            }
        });
        builtinFunctions.put("max", new Function(){

            @Override
            void parse(Parser parser, SemanticMapperContext ctx, FunctionExpression parent) throws ValidationException {
                parser.readToken(TokenType.OPEN_BRACKET);
                parent.addExpr(parser.readExpression(ctx));
                parser.readToken(TokenType.CLOSE_BRACKET);
            }

            @Override
            Object invoke(SemanticMapperContext ctx, FunctionExpression parent) throws SemanticMapperException {
                if (parent.params.get(0) instanceof Collection) {
                    if (((Collection)parent.params.get(0)).size() == 0) {
                        ctx.raiseError("Empty collection is passed into MAX function.");
                    }
                    NumberHelper<?> comparator = NumberHelper.getComparator(ctx, parent.params.get(0).getClass().getTypeParameters()[0].getGenericDeclaration());
                    Iterator iter = ((Collection)parent.params.get(0)).iterator();
                    Object max = null;
                    while (iter.hasNext()) {
                        Object next = iter.next();
                        if (max == null) {
                            max = next;
                            continue;
                        }
                        if (comparator.compare(next, max) <= 0) continue;
                        max = next;
                    }
                    return max;
                }
                if (parent.params.get(0) != null && parent.params.get(0).getClass().isArray()) {
                    if (Array.getLength(parent.params.get(0)) == 0) {
                        ctx.raiseError("Empty array is passed into MAX function.");
                    }
                    NumberHelper<?> comparator = NumberHelper.getComparator(ctx, parent.params.get(0).getClass().getComponentType());
                    Comparable max = null;
                    for (int i = 0; i < Array.getLength(parent.params.get(0)); ++i) {
                        Comparable next = (Comparable)Array.get(parent.params.get(0), i);
                        if (max == null) {
                            max = next;
                            continue;
                        }
                        if (comparator.compare(next, max) <= 0) continue;
                        max = next;
                    }
                    return max;
                }
                ctx.raiseError("Unsupported argument is passed to MAX function.");
                return null;
            }

            public String toString() {
                return "max()";
            }
        });
        builtinFunctions.put("sum", new Function(){

            @Override
            void parse(Parser parser, SemanticMapperContext ctx, FunctionExpression parent) throws ValidationException {
                parser.readToken(TokenType.OPEN_BRACKET);
                parent.addExpr(parser.readExpression(ctx));
                parser.readToken(TokenType.CLOSE_BRACKET);
            }

            @Override
            Object invoke(SemanticMapperContext ctx, FunctionExpression parent) throws SemanticMapperException {
                if (parent.params.get(0) instanceof Collection) {
                    NumberHelper<?> helper = NumberHelper.getComparator(ctx, parent.params.get(0).getClass().getTypeParameters()[0].getGenericDeclaration());
                    if (helper == null) {
                        ctx.raiseError("Unsupported data type is passed into SUM function.");
                    }
                    Iterator iter = ((Collection)parent.params.get(0)).iterator();
                    Object sum = helper.getDefaultValue();
                    while (iter.hasNext()) {
                        Number next = (Number)iter.next();
                        sum = helper.sum(sum, next);
                    }
                    return sum;
                }
                if (parent.params.get(0) != null && parent.params.get(0).getClass().isArray()) {
                    NumberHelper<?> helper = NumberHelper.getComparator(ctx, parent.params.get(0).getClass().getComponentType());
                    if (helper == null) {
                        ctx.raiseError("Unsupported data type is passed into SUM function.");
                    }
                    Object sum = helper.getDefaultValue();
                    for (int i = 0; i < Array.getLength(parent.params.get(0)); ++i) {
                        Object next = Array.get(parent.params.get(0), i);
                        sum = helper.sum(sum, next);
                    }
                    return sum;
                }
                ctx.raiseError("Unsupported sequence type is passed into SUM function.");
                return null;
            }

            public String toString() {
                return "sum()";
            }
        });
        builtinFunctions.put("avg", new Function(){

            @Override
            void parse(Parser parser, SemanticMapperContext ctx, FunctionExpression parent) throws ValidationException {
                parser.readToken(TokenType.OPEN_BRACKET);
                parent.addExpr(parser.readExpression(ctx));
                parser.readToken(TokenType.CLOSE_BRACKET);
            }

            @Override
            Object invoke(SemanticMapperContext ctx, FunctionExpression parent) throws SemanticMapperException {
                if (parent.params.get(0) instanceof Collection) {
                    NumberHelper<?> helper = NumberHelper.getComparator(ctx, parent.params.get(0).getClass().getTypeParameters()[0].getGenericDeclaration());
                    if (helper == null) {
                        ctx.raiseError("Unsupported data type is passed into AVG function.");
                    }
                    Object counter = helper.getDefaultValue();
                    Iterator iter = ((Collection)parent.params.get(0)).iterator();
                    Object sum = helper.getDefaultValue();
                    while (iter.hasNext()) {
                        Number next = (Number)iter.next();
                        sum = helper.sum(sum, next);
                        counter = helper.sum(counter, 1);
                    }
                    return helper.divide(sum, counter);
                }
                if (parent.params.get(0) != null && parent.params.get(0).getClass().isArray()) {
                    NumberHelper<?> helper = NumberHelper.getComparator(ctx, parent.params.get(0).getClass().getComponentType());
                    if (helper == null) {
                        ctx.raiseError("Unsupported data type is passed into AVG function.");
                    }
                    Object counter = helper.getDefaultValue();
                    Object sum = helper.getDefaultValue();
                    for (int i = 0; i < Array.getLength(parent.params.get(0)); ++i) {
                        Object next = Array.get(parent.params.get(0), i);
                        sum = helper.sum(sum, next);
                        counter = helper.sum(counter, 1);
                    }
                    return helper.divide(sum, counter);
                }
                ctx.raiseError("Unsupported sequence type is passed into AVG function.");
                return null;
            }

            public String toString() {
                return "avg()";
            }
        });
        builtinFunctions.put("query", new Function(){

            @Override
            void parse(Parser parser, SemanticMapperContext ctx, FunctionExpression parent) throws ValidationException {
                List<Expression> expressions = parser.readQueryExpression(ctx);
                for (Expression expr : expressions) {
                    parent.addExpr(expr);
                }
            }

            @Override
            Object invoke(SemanticMapperContext ctx, FunctionExpression parent) throws SemanticMapperException {
                if (ctx.getDataspaceAccessor() == null) {
                    throw new SemanticMapperException(3013, "Unable to evaluate 'query' expression. Dataspace accessor is not initialized.");
                }
                try {
                    Method method = DataspaceAccessor.class.getDeclaredMethod("executeQuery", String.class, Object[].class);
                    if (method != null) {
                        Object query = parent.params.remove(0);
                        RowSet rs = (RowSet)method.invoke((Object)ctx.getDataspaceAccessor(), query, parent.params.toArray());
                        if (rs != null) {
                            return 6.processRowSet(rs);
                        }
                        new SemanticMapperException(3013, "Unable to execute 'query' expression.");
                    } else {
                        new SemanticMapperException(3013, "Unable to execute 'query' expression.");
                    }
                }
                catch (InvocationTargetException error) {
                    Throwable cause = error.getTargetException();
                    if (cause != null) {
                        throw new SemanticMapperException(3013, "Unable to evaluate 'query' expression. " + cause.getMessage());
                    }
                    throw new SemanticMapperException(3013, "Unable to evaluate 'query' expression.");
                }
                catch (Exception error) {
                    throw new SemanticMapperException(3013, "Unable to evaluate 'query' expression. " + error.getMessage());
                }
                return null;
            }

            public String toString() {
                return "query";
            }
        });
        Function.registerDataspaceFunction("ascii");
        Function.registerDataspaceFunction("char");
        Function.registerDataspaceFunction("concat");
        Function.registerDataspaceFunction("tokenize");
        Function.registerDataspaceFunction("difference");
        Function.registerDataspaceFunction("insert");
        Function.registerDataspaceFunction("hextoraw");
        Function.registerDataspaceFunction("lcase");
        Function.registerDataspaceFunction("left");
        Function.registerDataspaceFunction("length");
        Function.registerDataspaceFunction("locate");
        Function.registerDataspaceFunction("lpad");
        Function.registerDataspaceFunction("ltrim");
        Function.registerDataspaceFunction("rawtohex");
        Function.registerDataspaceFunction("matches");
        Function.registerDataspaceFunction("repeat");
        Function.registerDataspaceFunction("replace");
        Function.registerDataspaceFunction("reverse");
        Function.registerDataspaceFunction("right");
        Function.registerDataspaceFunction("rpad");
        Function.registerDataspaceFunction("rtrim");
        Function.registerDataspaceFunction("soundex");
        Function.registerDataspaceFunction("space");
        Function.registerDataspaceFunction("substr");
        Function.registerDataspaceFunction("ucase");
        Function.registerDataspaceFunction("chracter_length");
        Function.registerDataspaceFunction("octet_length");
        Function.registerDataspaceFunction("bit_length");
        Function.registerDataspaceFunction("overlay");
        Function.registerDataspaceFunction("position");
        Function.registerDataspaceFunction("trim");
        Function.registerDataspaceFunction("bit_length");
        Function.registerDataspaceFunction("abs");
        Function.registerDataspaceFunction("acos");
        Function.registerDataspaceFunction("asin");
        Function.registerDataspaceFunction("atan");
        Function.registerDataspaceFunction("atan2");
        Function.registerDataspaceFunction("ceiling");
        Function.registerDataspaceFunction("bitand");
        Function.registerDataspaceFunction("bitor");
        Function.registerDataspaceFunction("bitxor");
        Function.registerDataspaceFunction("cos");
        Function.registerDataspaceFunction("cot");
        Function.registerDataspaceFunction("degrees");
        Function.registerDataspaceFunction("exp");
        Function.registerDataspaceFunction("floor");
        Function.registerDataspaceFunction("ln");
        Function.registerDataspaceFunction("log");
        Function.registerDataspaceFunction("log10");
        Function.registerDataspaceFunction("mod");
        Function.registerDataspaceFunction("pi");
        Function.registerDataspaceFunction("power");
        Function.registerDataspaceFunction("radians");
        Function.registerDataspaceFunction("rand");
        Function.registerDataspaceFunction("round");
        Function.registerDataspaceFunction("sign");
        Function.registerDataspaceFunction("sin");
        Function.registerDataspaceFunction("sqrt");
        Function.registerDataspaceFunction("tan");
        Function.registerDataspaceFunction("trunc");
        Function.registerDataspaceFunction("timezone");
        Function.registerDataspaceFunction("session_timezone");
        Function.registerDataspaceFunction("extract");
        Function.registerDataspaceFunction("current_date");
        Function.registerDataspaceFunction("current_time");
        Function.registerDataspaceFunction("localtime");
        Function.registerDataspaceFunction("current_timestamp");
        Function.registerDataspaceFunction("localtimestamp");
        Function.registerDataspaceFunction("curdate");
        Function.registerDataspaceFunction("curtime");
        Function.registerDataspaceFunction("dayname");
        Function.registerDataspaceFunction("daymonth");
        Function.registerDataspaceFunction("dayofweek");
        Function.registerDataspaceFunction("dayofyear");
        Function.registerDataspaceFunction("hour");
        Function.registerDataspaceFunction("minute");
        Function.registerDataspaceFunction("month");
        Function.registerDataspaceFunction("monthname");
        Function.registerDataspaceFunction("now");
        Function.registerDataspaceFunction("quarter");
        Function.registerDataspaceFunction("second");
        Function.registerDataspaceFunction("seconds_since_midnight");
        Function.registerDataspaceFunction("week");
        Function.registerDataspaceFunction("year");
        Function.registerDataspaceFunction("dateadd");
        Function.registerDataspaceFunction("datediff");
        Function.registerDataspaceFunction("round");
        Function.registerDataspaceFunction("timestampadd");
        Function.registerDataspaceFunction("timestampdiff");
        Function.registerDataspaceFunction("trunc");
        Function.registerDataspaceFunction("to_char");
        Function.registerDataspaceFunction("to_date");
        Function.registerDataspaceFunction("to_timestamp");
        Function.registerDataspaceFunction("unix_timestamp");
        Function.registerDataspaceFunction("soundex");
        Function.registerDataspaceFunction("levenshtein");
        Function.registerDataspaceFunction("qgram");
        Function.registerDataspaceFunction("metaphone");
        Function.registerDataspaceFunction("jaro_winkler");
        Function.registerDataspaceFunction("weighted_levenshtein");
        Function.registerDataspaceFunction("eval");
        Function.registerDataspaceFunction("ifnull");
        Function.registerDataspaceFunction("isnull");
        Function.registerDataspaceFunction("decode");
        Function.registerDataspaceFunction("coalesce");
        Function.registerDataspaceFunction("convert");
        Function.registerDataspaceFunction("uuid");
        Function.registerDataspaceFunction("nullif");
        Function.registerDataspaceFunction("cardinality");
        Function.registerDataspaceFunction("max_cardinality");
        Function.registerDataspaceFunction("position_array");
        Function.registerDataspaceFunction("sort_array");
        Function.registerDataspaceFunction("sequence_array");
        Function.registerDataspaceFunction("cast");
        Function.registerDataspaceFunction("toString");
        Function.registerDataspaceFunction("toDecimal");
    }
}

