/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.mapper.parser;

import com.streamscape.omf.mapper.SemanticMapperException;
import com.streamscape.omf.mapper.parser.AbstractStatement;
import com.streamscape.omf.mapper.parser.Expression;
import com.streamscape.omf.mapper.parser.ForEachSequenceHandler;
import com.streamscape.omf.mapper.parser.SPathExpression;
import com.streamscape.omf.mapper.parser.SemanticMapperContext;
import com.streamscape.omf.mapper.parser.SequenceHandler;
import com.streamscape.omf.mapper.parser.Statement;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ForEachStatement
extends AbstractStatement {
    Expression expression;
    List<Statement> subStats;
    String sequenceAlias;
    ForEachSequenceHandler handler;

    ForEachStatement() {
        super(Statement.StatementType.FOR_EACH);
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public void setSubStats(List<Statement> subStats) {
        this.subStats = subStats;
    }

    public void setSequenceAlias(String alias) {
        this.sequenceAlias = alias;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public List<Statement> getSubStatements() {
        return this.subStats;
    }

    public Statement getSubStatement(int index) {
        return this.subStats.get(index);
    }

    public int getSubStatementsNum() {
        return this.subStats.size();
    }

    public String getSequenceAlias() {
        return this.sequenceAlias;
    }

    @Override
    public void execute(SemanticMapperContext ctx) throws SemanticMapperException {
        try {
            Object fieldValue = this.expression.evaluate(ctx);
            if (this.sequenceAlias != null) {
                this.handler = new ForEachSequenceHandler(fieldValue.getClass());
                ctx.getSequenceObjects().put(this.sequenceAlias + "//", this.handler);
            } else if (this.expression instanceof SPathExpression) {
                this.handler = new ForEachSequenceHandler(fieldValue.getClass());
                ctx.getSequenceObjects().put(((SPathExpression)this.expression).getAlias() + ((SPathExpression)this.expression).getAlias(), this.handler);
            }
            if (fieldValue == null) {
                ctx.raiseError("NULL sequence is specified for FOR EACH statement.");
            }
            if (this.sequenceAlias != null) {
                ctx.addMappingObject(this.sequenceAlias, fieldValue);
            }
            if (fieldValue instanceof List) {
                Iterator iter = ((List)fieldValue).iterator();
                while (iter.hasNext()) {
                    this.processSequenceElement(ctx, iter.next());
                }
            } else if (fieldValue instanceof Map) {
                for (Map.Entry entry : ((Map)fieldValue).entrySet()) {
                    ctx.setSequenceKey(entry.getKey());
                    this.processSequenceElement(ctx, entry.getValue());
                }
            } else if (fieldValue.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(fieldValue); ++i) {
                    Object element = Array.get(fieldValue, i);
                    this.processSequenceElement(ctx, element);
                }
            }
            ctx.cleanSequences();
            if (this.sequenceAlias != null) {
                ctx.removeMappingObject(this.sequenceAlias);
            }
        }
        catch (Exception error) {
            throw new SemanticMapperException(3013, "Unable to get type information corresponding to specified spaths. " + error.getMessage());
        }
    }

    private void processSequenceElement(SemanticMapperContext ctx, Object element) throws SemanticMapperException {
        this.handler.setCurrent(element);
        for (SequenceHandler handler : ctx.getSequenceObjects().values()) {
            handler.moveToNext(ctx);
        }
        for (Statement stat : this.subStats) {
            stat.execute(ctx);
        }
    }
}

