/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.mapper.parser;

import com.streamscape.omf.mapper.SemanticMapperException;
import com.streamscape.omf.mapper.parser.NumberHelper;

class FloatHelper
extends NumberHelper<Float> {
    FloatHelper() {
    }

    @Override
    int compare(Object first, Object second) throws SemanticMapperException {
        return this.checkValue(first).compareTo(this.checkValue(second));
    }

    @Override
    Object getDefaultValue() {
        return Float.valueOf("0");
    }

    @Override
    Object sum(Object first, Object second) throws SemanticMapperException {
        return Float.valueOf(this.checkValue(first).floatValue() + this.checkValue(second).floatValue());
    }

    @Override
    Object divide(Object first, Object second) throws SemanticMapperException {
        return Float.valueOf(this.checkValue(first).floatValue() / this.checkValue(second).floatValue());
    }

    @Override
    Float checkValue(Object value) throws SemanticMapperException {
        if (value == null) {
            throw new SemanticMapperException(3013, "NULL value is passed instead of number value.");
        }
        if (value instanceof String) {
            return Float.valueOf((String)value);
        }
        if (!(value instanceof Float) && value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        return (Float)value;
    }
}

