/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.mapper.parser;

import com.streamscape.omf.mapper.SemanticMapperException;
import com.streamscape.omf.mapper.parser.NumberHelper;
import com.streamscape.omf.mapper.parser.SemanticMapperContext;
import com.streamscape.sef.DomainConstraint;
import com.streamscape.sef.RangeConstraint;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Expression {
    ExpressionType type;
    List<Object> exprs = new ArrayList<Object>();
    List<Object> params = new ArrayList<Object>();

    Expression(ExpressionType type) {
        this.type = type;
    }

    void addExpr(Object param) {
        this.exprs.add(param);
    }

    void evaluateParams(SemanticMapperContext ctx) throws SemanticMapperException {
        this.params = new ArrayList<Object>(this.exprs.size());
        for (int i = 0; i < this.exprs.size(); ++i) {
            if (this.exprs.get(i) instanceof Expression) {
                this.params.add(i, ((Expression)this.exprs.get(i)).evaluate(ctx));
                continue;
            }
            this.params.add(i, this.exprs.get(i));
        }
    }

    void evaluateParamsForFunction(SemanticMapperContext ctx) throws SemanticMapperException {
        for (int i = 0; i < this.exprs.size(); ++i) {
            if (this.exprs.get(i) instanceof Expression) {
                Object expressionValue = ((Expression)this.exprs.get(i)).evaluate(ctx);
                if (((Expression)this.exprs.get((int)i)).type == ExpressionType.STRING_VALUE && expressionValue instanceof String) {
                    expressionValue = "'" + String.valueOf(expressionValue) + "'";
                } else if (((Expression)this.exprs.get((int)i)).type == ExpressionType.CONCAT && expressionValue instanceof String) {
                    expressionValue = "'" + String.valueOf(expressionValue) + "'";
                } else if (((Expression)this.exprs.get((int)i)).type == ExpressionType.SPATH && expressionValue instanceof String) {
                    expressionValue = "'" + String.valueOf(expressionValue) + "'";
                } else if (((Expression)this.exprs.get((int)i)).type == ExpressionType.FUNCTION && expressionValue instanceof String) {
                    expressionValue = "'" + String.valueOf(expressionValue) + "'";
                }
                this.params.add(i, expressionValue);
                continue;
            }
            this.params.add(i, this.exprs.get(i));
        }
    }

    Object evaluate(SemanticMapperContext ctx) throws SemanticMapperException {
        this.evaluateParams(ctx);
        switch (this.type.ordinal()) {
            case 0: 
            case 1: {
                return this.params.get(0);
            }
            case 2: {
                StringBuilder buffer = new StringBuilder();
                for (Object param : this.params) {
                    if (param != null) {
                        buffer.append(param.toString());
                        continue;
                    }
                    buffer.append("null");
                }
                return buffer.toString();
            }
            case 12: {
                NumberHelper<?> comparator;
                if (this.params.get(0) == null || this.params.get(1) == null) {
                    ctx.raiseError("NULL operands for '>' expression.");
                }
                if ((comparator = NumberHelper.getComparator(ctx, this.params.get(0).getClass())) != null) {
                    return comparator.compare(this.params.get(0), this.params.get(1)) > 0;
                }
                ctx.raiseError("Incompatible operands for '>' expression.");
            }
            case 16: {
                NumberHelper<?> comparator;
                if (this.params.get(0) == null || this.params.get(1) == null) {
                    ctx.raiseError("NULL operands for '>=' expression.");
                }
                if ((comparator = NumberHelper.getComparator(ctx, this.params.get(0).getClass())) != null) {
                    return comparator.compare(this.params.get(0), this.params.get(1)) >= 0;
                }
                ctx.raiseError("Incompatible operands for '>=' expression.");
            }
            case 13: {
                NumberHelper<?> comparator;
                if (this.params.get(0) == null || this.params.get(1) == null) {
                    ctx.raiseError("NULL operands for '<' expression.");
                }
                if ((comparator = NumberHelper.getComparator(ctx, this.params.get(0).getClass())) != null) {
                    return comparator.compare(this.params.get(0), this.params.get(1)) < 0;
                }
                ctx.raiseError("Incompatible operands for '<' expression.");
            }
            case 17: {
                NumberHelper<?> comparator;
                if (this.params.get(0) == null || this.params.get(1) == null) {
                    ctx.raiseError("NULL operands for '<=' expression.");
                }
                if ((comparator = NumberHelper.getComparator(ctx, this.params.get(0).getClass())) != null) {
                    return comparator.compare(this.params.get(0), this.params.get(1)) <= 0;
                }
                ctx.raiseError("Incompatible operands for '<=' expression.");
            }
            case 14: {
                NumberHelper<?> comparator;
                if (this.params.get(0) != null && this.params.get(1) != null && this.params.get(0) instanceof Number) {
                    comparator = NumberHelper.getComparator(ctx, this.params.get(0).getClass());
                    if (comparator != null) {
                        return comparator.compare(this.params.get(0), this.params.get(1)) == 0;
                    }
                    ctx.raiseError("Incompatible operands for '==' expression.");
                } else {
                    if (this.params.get(0) instanceof String && this.params.get(1) instanceof String) {
                        return ((String)this.params.get(0)).equals((String)this.params.get(1));
                    }
                    if (this.params.get(0) != null) {
                        return this.params.get(0).equals(this.params.get(1));
                    }
                    if (this.params.get(1) != null) {
                        return this.params.get(1).equals(this.params.get(0));
                    }
                    ctx.raiseError("Incompatible operands for '==' expression.");
                }
            }
            case 15: {
                NumberHelper<?> comparator;
                if (this.params.get(0) != null && this.params.get(1) != null && this.params.get(0) instanceof Number) {
                    comparator = NumberHelper.getComparator(ctx, this.params.get(0).getClass());
                    if (comparator != null) {
                        return comparator.compare(this.params.get(0), this.params.get(1)) != 0;
                    }
                    ctx.raiseError("Incompatible operands for '!=' expression.");
                } else {
                    if (this.params.get(0) instanceof String && this.params.get(1) instanceof String) {
                        return !((String)this.params.get(0)).equals((String)this.params.get(1));
                    }
                    if (this.params.get(0) != null) {
                        return !this.params.get(0).equals(this.params.get(1));
                    }
                    if (this.params.get(1) != null) {
                        return !this.params.get(1).equals(this.params.get(0));
                    }
                    ctx.raiseError("Incompatible operands for '!=' expression.");
                }
            }
            case 5: {
                try {
                    DomainConstraint constraint = ctx.getDomainConstraint((String)this.params.get(1));
                    if (constraint != null) {
                        return constraint.matchesValue(this.params.get(0)) ? Boolean.TRUE : Boolean.FALSE;
                    }
                    throw new SemanticMapperException(3013, "Unknown domain '" + String.valueOf(this.params.get(1)) + "' specified in the mapping rule.");
                }
                catch (Exception error) {
                    throw new SemanticMapperException(3013, "Unable to evaluate 'in domain' expression. " + error.getMessage());
                }
            }
            case 6: {
                try {
                    if (this.params.get(0) instanceof Number || this.params.get(0) instanceof Date) {
                        RangeConstraint constraint = ctx.getRangeConstraint((String)this.params.get(1));
                        if (constraint != null) {
                            return constraint.matchesValue(this.params.get(0)) ? Boolean.TRUE : Boolean.FALSE;
                        }
                        throw new SemanticMapperException(3013, "Unknown range '" + String.valueOf(this.params.get(1)) + "' specified in the mapping rule.");
                    }
                }
                catch (Exception error) {
                    throw new SemanticMapperException(3013, "Unable to evaluate 'in range' expression. " + error.getMessage());
                }
            }
            case 7: {
                if (this.params.get(0) == null) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 8: {
                if (this.params.get(0) != null) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public ExpressionType getType() {
        return this.type;
    }

    public List<Object> getExprs() {
        return this.exprs;
    }

    public List<Object> getParams() {
        return this.params;
    }

    public String toString() {
        if (this.exprs.size() == 2) {
            return this.exprs.get(0).toString() + " " + this.type.toString() + " " + this.exprs.get(1).toString();
        }
        switch (this.type.ordinal()) {
            case 0: {
                return this.exprs.get(0).toString();
            }
            case 1: {
                return "'" + this.exprs.get(0).toString() + "'";
            }
        }
        return this.type.toString();
    }

    public static enum ExpressionType {
        VALUE,
        STRING_VALUE,
        CONCAT{

            public String toString() {
                return "concat";
            }
        }
        ,
        SPATH,
        FOREACH,
        IN_DOMAIN{

            public String toString() {
                return "in domain";
            }
        }
        ,
        IN_RANGE{

            public String toString() {
                return "in range";
            }
        }
        ,
        IS_NULL{

            public String toString() {
                return "is null";
            }
        }
        ,
        IS_NOT_NULL{

            public String toString() {
                return "is not null";
            }
        }
        ,
        QUERY,
        FUNCTION,
        SPATH_SEQUENCE,
        GREATER_THAN{

            public String toString() {
                return ">";
            }
        }
        ,
        LESS_THAN{

            public String toString() {
                return "<";
            }
        }
        ,
        EQUALS{

            public String toString() {
                return "==";
            }
        }
        ,
        NOT_EQUALS{

            public String toString() {
                return "!=";
            }
        }
        ,
        GREATER_OR_EQUALS_THAN{

            public String toString() {
                return ">=";
            }
        }
        ,
        LESS_OR_EQUALS_THAN{

            public String toString() {
                return "<=";
            }
        };

    }
}

