/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.mapper.parser;

import com.streamscape.omf.mapper.SemanticMapperException;
import com.streamscape.omf.mapper.parser.NumberHelper;

class DoubleHelper
extends NumberHelper<Double> {
    DoubleHelper() {
    }

    @Override
    int compare(Object first, Object second) throws SemanticMapperException {
        return this.checkValue(first).compareTo(this.checkValue(second));
    }

    @Override
    Object getDefaultValue() {
        return Double.valueOf("0");
    }

    @Override
    Object sum(Object first, Object second) throws SemanticMapperException {
        return this.checkValue(first) + this.checkValue(second);
    }

    @Override
    Object divide(Object first, Object second) throws SemanticMapperException {
        return this.checkValue(first) / this.checkValue(second);
    }

    @Override
    Double checkValue(Object value) throws SemanticMapperException {
        if (value == null) {
            throw new SemanticMapperException(3013, "NULL value is passed instead of number value.");
        }
        if (value instanceof String) {
            return Double.valueOf((String)value);
        }
        if (!(value instanceof Double) && value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return (Double)value;
    }
}

