/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.mapper.parser;

import com.streamscape.omf.mapper.SemanticMapperException;
import com.streamscape.omf.mapper.parser.Expression;
import com.streamscape.omf.mapper.parser.Function;
import com.streamscape.omf.mapper.parser.FunctionExpression;
import com.streamscape.omf.mapper.parser.Parser;
import com.streamscape.omf.mapper.parser.SemanticMapperContext;
import com.streamscape.omf.mapper.parser.TokenType;
import com.streamscape.sdo.excp.ValidationException;
import java.util.stream.Collectors;

class DataspaceFunction
extends Function {
    String name;

    DataspaceFunction(String name) {
        this.name = name;
    }

    @Override
    void parse(Parser parser, SemanticMapperContext ctx, FunctionExpression parent) throws ValidationException {
        parser.readToken(TokenType.OPEN_BRACKET);
        this.parseFunctionParameters(parser, ctx, parent);
        parser.readToken(TokenType.CLOSE_BRACKET);
    }

    void parseFunctionParameters(Parser parser, SemanticMapperContext ctx, FunctionExpression parent) throws ValidationException {
        while (parser.currentToken.type != TokenType.CLOSE_BRACKET) {
            Expression temp = parser.readExpression(ctx);
            if (temp == null) {
                return;
            }
            parent.addExpr(temp);
            if (parser.currentToken.type != TokenType.COMMA) continue;
            parser.readToken(TokenType.COMMA);
        }
    }

    @Override
    Object invoke(SemanticMapperContext ctx, FunctionExpression parent) throws SemanticMapperException {
        if (ctx.getDataspaceAccessor() == null) {
            throw new SemanticMapperException(3013, "Unable to evaluate 'query' expression. JDBC connection is not set.");
        }
        try {
            String call = "call " + this.name + "(" + this.renderParameters(parent, false) + ")";
            return DataspaceFunction.processRowSet(ctx.getDataspaceAccessor().executeQuery(call));
        }
        catch (Exception error) {
            throw new SemanticMapperException(3013, "Unable to evaluate function '" + this.name + "' expression. " + error.getMessage());
        }
    }

    private String renderParameters(FunctionExpression parent, boolean questions) {
        return parent.params.stream().map(p -> questions ? "?" : String.valueOf(p)).collect(Collectors.joining(","));
    }

    public String toString() {
        return this.name;
    }
}

