/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.mapper.parser;

import com.streamscape.omf.mapper.SemanticMapperException;
import com.streamscape.omf.mapper.parser.AbstractStatement;
import com.streamscape.omf.mapper.parser.Expression;
import com.streamscape.omf.mapper.parser.SemanticMapperContext;
import com.streamscape.omf.mapper.parser.Statement;
import java.util.ArrayList;
import java.util.List;

public class CaseStatement
extends AbstractStatement {
    Expression conditionExpression = null;
    List<Expression> expressions = new ArrayList<Expression>();
    List<Statement> statements = new ArrayList<Statement>();

    CaseStatement() {
        super(Statement.StatementType.CASE);
    }

    public void setConditionExpression(Expression expr) {
        this.conditionExpression = expr;
    }

    public void addCase(Expression expr, Statement stat) {
        this.expressions.add(expr);
        this.statements.add(stat);
    }

    public Expression getConditionExpression() {
        return this.conditionExpression;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public Expression getExpression(int index) {
        return this.expressions.get(index);
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public Statement getStatement(int index) {
        return this.statements.get(index);
    }

    public int getCasesNum() {
        return this.expressions.size();
    }

    @Override
    public void execute(SemanticMapperContext ctx) throws SemanticMapperException {
        Object conditionValue = this.conditionExpression.evaluate(ctx);
        for (int i = 0; i < this.expressions.size(); ++i) {
            if (this.expressions.get(i) != null) {
                Object expressionValue = this.expressions.get(i).evaluate(ctx);
                if (!conditionValue.equals(expressionValue) || this.statements.get(i) == null) continue;
                this.statements.get(i).execute(ctx);
                break;
            }
            throw new SemanticMapperException(3013, "Wrong expression is specified for CASE statement.");
        }
    }
}

