/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.mapper.parser;

import com.streamscape.omf.mapper.SemanticMapperException;
import com.streamscape.omf.mapper.parser.NumberHelper;
import java.math.BigDecimal;

class BigDecimalHelper
extends NumberHelper<BigDecimal> {
    BigDecimalHelper() {
    }

    @Override
    int compare(Object first, Object second) throws SemanticMapperException {
        return this.checkValue(first).compareTo(this.checkValue(second));
    }

    @Override
    Object getDefaultValue() {
        return new BigDecimal(0);
    }

    @Override
    Object sum(Object first, Object second) throws SemanticMapperException {
        return this.checkValue(first).add(this.checkValue(second));
    }

    @Override
    Object divide(Object first, Object second) throws SemanticMapperException {
        return this.checkValue(first).divide(this.checkValue(second));
    }

    @Override
    BigDecimal checkValue(Object value) throws SemanticMapperException {
        if (value == null) {
            throw new SemanticMapperException(3013, "NULL value is passed instead of number value.");
        }
        if (value instanceof String) {
            return new BigDecimal((String)value);
        }
        if (!(value instanceof Double)) {
            throw new SemanticMapperException(3013, "Incompatible data type. Value of type '" + BigDecimal.class.getSimpleName() + "' expected.");
        }
        return (BigDecimal)value;
    }
}

