/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.mapper.parser;

import com.streamscape.Trace;
import com.streamscape.omf.mapper.SemanticMapperException;
import com.streamscape.omf.mapper.parser.AbstractStatement;
import com.streamscape.omf.mapper.parser.Expression;
import com.streamscape.omf.mapper.parser.SPathExpression;
import com.streamscape.omf.mapper.parser.SPathSequenceExpression;
import com.streamscape.omf.mapper.parser.SemanticMapperContext;
import com.streamscape.omf.mapper.parser.SequenceHandler;
import com.streamscape.omf.mapper.parser.Statement;
import java.lang.reflect.Field;

public class AssignmentStatement
extends AbstractStatement {
    Expression leftExpression;
    Expression rightExpression;

    AssignmentStatement() {
        super(Statement.StatementType.ASSIGNMENT);
    }

    public void setLeftExpression(Expression expr) {
        this.leftExpression = expr;
    }

    public void setRightExpression(Expression expr) {
        this.rightExpression = expr;
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }

    public Expression getRightExpression() {
        return this.rightExpression;
    }

    @Override
    public void execute(SemanticMapperContext ctx) throws SemanticMapperException {
        try {
            if (this.leftExpression instanceof SPathSequenceExpression) {
                if (this.rightExpression instanceof SPathSequenceExpression && ((SPathSequenceExpression)this.leftExpression).getSequenceSpath().equals("//") && ((SPathSequenceExpression)this.rightExpression).getSequenceSpath().equals("//")) {
                    Object sourceObject = ctx.getMappingObject(((SPathExpression)this.rightExpression).getAlias());
                    String elementClassName = ctx.getTypeAnalyzer().getFieldTypeAsString(sourceObject.getClass(), ((SPathExpression)this.rightExpression).getSpath());
                    Class<?> elementClass = ctx.loadClass(elementClassName);
                    sourceObject = ctx.getSdrManager().getValueAtPath(((SPathExpression)this.rightExpression).getSpath(), sourceObject);
                    Object targetObject = ctx.getMappingObject(((SPathExpression)this.leftExpression).getAlias());
                    String targetElementClassName = ctx.getTypeAnalyzer().getFieldTypeAsString(targetObject.getClass(), ((SPathExpression)this.leftExpression).getSpath());
                    Class<?> targetElementClass = ctx.loadClass(targetElementClassName);
                    targetObject = ctx.getSdrManager().getValueAtPath(((SPathExpression)this.leftExpression).getSpath(), targetObject);
                    if (targetObject == null) {
                        targetObject = ctx.instantiateClass(targetElementClass);
                        ctx.getSdrManager().setValueAtPath(((SPathExpression)this.leftExpression).getSpath(), ctx.getMappingObject(((SPathExpression)this.leftExpression).getAlias()), targetObject);
                    }
                    for (Field field : elementClass.getDeclaredFields()) {
                        if (!field.isAccessible()) {
                            field.setAccessible(true);
                        }
                        Object fieldValue = field.get(sourceObject);
                        try {
                            Field targetField = targetElementClass.getDeclaredField(field.getName());
                            if (!targetField.isAccessible()) {
                                targetField.setAccessible(true);
                            }
                            targetField.set(targetObject, fieldValue);
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            // empty catch block
                        }
                    }
                } else {
                    Object fieldValue = this.rightExpression.evaluate(ctx);
                    this.leftExpression.evaluate(ctx);
                    SequenceHandler handler = ctx.getSequenceObjects().get(((SPathSequenceExpression)this.leftExpression).getAlias() + ((SPathSequenceExpression)this.leftExpression).getSpath());
                    ctx.getSdrManager().setValueAtPath(((SPathSequenceExpression)this.leftExpression).getSequenceSpath(), handler.getCurrent(), fieldValue);
                }
            } else {
                Object fieldValue = this.rightExpression.evaluate(ctx);
                if (((SPathExpression)this.leftExpression).hasSpath()) {
                    Object assigneeObject = ctx.getMappingObject(((SPathExpression)this.leftExpression).getAlias());
                    try {
                        ctx.getSdrManager().setValueAtPath(((SPathExpression)this.leftExpression).getSpath(), assigneeObject, fieldValue);
                    }
                    catch (IllegalArgumentException error) {
                        String elementClassName = ctx.getTypeAnalyzer().getFieldTypeAsString(assigneeObject.getClass(), ((SPathExpression)this.leftExpression).getSpath());
                        Class<?> elementClass = ctx.loadClass(elementClassName);
                        if (elementClass.isEnum() && fieldValue instanceof String) {
                            fieldValue = Enum.valueOf(elementClass, (String)fieldValue);
                        }
                        ctx.getSdrManager().setValueAtPath(((SPathExpression)this.leftExpression).getSpath(), assigneeObject, fieldValue);
                    }
                } else {
                    ctx.addMappingObject(((SPathExpression)this.leftExpression).getAlias(), fieldValue);
                }
            }
        }
        catch (Exception error) {
            Trace.logException(this, error, true);
            throw new SemanticMapperException(3013, error.getMessage());
        }
    }
}

