/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.mapper.parser;

import com.streamscape.Trace;
import com.streamscape.omf.mapper.SemanticMapperException;
import com.streamscape.omf.mapper.parser.SemanticMapperContext;
import com.streamscape.omf.mapper.parser.SequenceHandler;
import java.lang.reflect.Array;

class ArrayHandler
extends SequenceHandler {
    int index = 0;

    ArrayHandler(Class<?> sequenceClass, Object sequence) {
        super(sequenceClass, sequence);
    }

    @Override
    void init(SemanticMapperContext ctx, Object parentObject, String parentSpath) throws SemanticMapperException {
        if (this.sequence == null || Array.getLength(this.sequence) == 0) {
            this.sequence = Array.newInstance(this.sequenceElementClass, 1);
            try {
                this.currentValue = ctx.instantiateClass(this.sequenceElementClass);
                Array.set(this.sequence, 0, this.currentValue);
            }
            catch (Exception error) {
                Trace.logException(this, error, true);
                ctx.raiseError(error.getMessage());
            }
        }
        this.currentValue = Array.get(this.sequence, this.index);
    }

    @Override
    void moveToNext(SemanticMapperContext ctx) throws SemanticMapperException {
        try {
            ++this.index;
            if (this.index >= Array.getLength(this.sequence)) {
                Object newArray = Array.newInstance(this.sequenceElementClass, Array.getLength(this.sequence) + 1);
                System.arraycopy(this.sequence, 0, newArray, 0, Array.getLength(this.sequence));
                this.sequence = newArray;
                this.currentValue = ctx.instantiateClass(this.sequenceElementClass);
                Array.set(this.sequence, this.index, this.currentValue);
            } else {
                this.currentValue = Array.get(this.sequence, this.index);
            }
        }
        catch (Exception error) {
            Trace.logException(this, error, true);
            ctx.raiseError(error.getMessage());
        }
    }
}

