/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.mapper.parser;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.lib.analyzer.TypeAnalyzer;
import com.streamscape.lib.reflection.ReflectionProvider;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.MacroProcessor;
import com.streamscape.omf.mapper.SemanticMapperException;
import com.streamscape.omf.mapper.parser.SemanticMapperContext;
import com.streamscape.omf.mapper.parser.SequenceHandler;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.mf.admin.SemanticTypeCache;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.sdrpath.ReferencePathManager;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public abstract class AbstractSemanticMapperContext
implements SemanticMapperContext {
    private ReferencePathManager sdrManager;
    private TypeAnalyzer typeAnalyzer;
    private ClassLoader classLoader;
    private MacroProcessor macroProcessor;
    private SemanticTypeCache semanticTypeCache;
    private DataspaceAccessor dataspaceAccessor;
    private Map<String, Object> mappingObjects = new HashMap<String, Object>();
    private Object sequenceKey = null;
    private Map<String, SequenceHandler> sequenceObjects = new HashMap<String, SequenceHandler>();
    private Set<String> userDsFunctions = new HashSet<String>();

    public AbstractSemanticMapperContext(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected void doSetSdrManager(ReferencePathManager sdrManager) {
        this.sdrManager = sdrManager;
    }

    protected void doSetTypeAnalyzer(TypeAnalyzer typeAnalyzer) {
        this.typeAnalyzer = typeAnalyzer;
    }

    protected void doSetMacroProcessor(MacroProcessor macroProcessor) {
        this.macroProcessor = macroProcessor;
    }

    protected void doSetSemanticTypeCache(SemanticTypeCache semanticTypeCache) {
        this.semanticTypeCache = semanticTypeCache;
    }

    @Override
    public void initDataspaceAccessor(String dataspace) throws SemanticMapperException {
        if (this.dataspaceAccessor != null) {
            this.dataspaceAccessor.close();
            this.dataspaceAccessor = null;
        }
        StringTokenizer tokenizer = new StringTokenizer(dataspace, ".");
        String nodeName = null;
        DataspaceType dataspaceType = null;
        String dataspaceName = null;
        if (tokenizer.countTokens() < 2 || tokenizer.countTokens() > 3) {
            throw new SemanticMapperException(3006, "Invalid dataspace name '" + dataspace + "' specified.");
        }
        if (tokenizer.countTokens() == 3) {
            nodeName = tokenizer.nextToken();
        }
        String type = tokenizer.nextToken();
        try {
            dataspaceType = DataspaceType.valueOf(type.toUpperCase());
        }
        catch (IllegalArgumentException error) {
            throw new SemanticMapperException(3006, "Invalid dataspace type '" + type + "' specified.");
        }
        dataspaceName = tokenizer.nextToken();
        try {
            this.dataspaceAccessor = this.doCreateDataspaceAccessor(nodeName, dataspaceType, dataspaceName);
        }
        catch (Exception error) {
            throw new SemanticMapperException(3006, "Unable to init accessor to '" + dataspace + "' dataspace. " + error.getMessage());
        }
        if (this.dataspaceAccessor == null) {
            throw new SemanticMapperException(3006, "Unable to init accessor to '" + dataspace + "' dataspace.");
        }
        try {
            RowSet rs = this.dataspaceAccessor.executeQuery("list functions");
            if (rs != null) {
                while (rs.next()) {
                    this.userDsFunctions.add(rs.getString(1));
                }
            }
            rs.close();
        }
        catch (Exception error) {
            Trace.logError(this, "Unable to initialize dataspace user defined functions.");
        }
    }

    protected abstract DataspaceAccessor doCreateDataspaceAccessor(String var1, DataspaceType var2, String var3) throws FabricComponentAccessorException, FabricConnectionException;

    @Override
    public DataspaceAccessor getDataspaceAccessor() {
        return this.dataspaceAccessor;
    }

    @Override
    public TypeAnalyzer getTypeAnalyzer() {
        return this.typeAnalyzer;
    }

    @Override
    public ReferencePathManager getSdrManager() {
        return this.sdrManager;
    }

    @Override
    public void setMacroProcessorEvent(ImmutableEventDatagram event) {
        this.macroProcessor.setEvent(event);
    }

    @Override
    public SemanticTypeCache getSemanticTypeCache() {
        return this.semanticTypeCache;
    }

    @Override
    public MacroProcessor getMacroProcessor() {
        return this.macroProcessor;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return ClassUtils.loadClass(className, this.classLoader);
    }

    @Override
    public Object instantiateClass(Class<?> clazz) throws Exception {
        return ReflectionProvider.getInstance().newInstance(clazz);
    }

    @Override
    public void addMappingObject(String semType, Object obj) {
        this.mappingObjects.put(semType, obj);
    }

    @Override
    public Object getMappingObject(String alias) {
        return this.mappingObjects.get(alias);
    }

    @Override
    public Object removeMappingObject(String semType) {
        return this.mappingObjects.remove(semType);
    }

    @Override
    public Object getSequenceKey() {
        return this.sequenceKey;
    }

    @Override
    public void setSequenceKey(Object sequenceKey) {
        this.sequenceKey = sequenceKey;
    }

    @Override
    public Map<String, SequenceHandler> getSequenceObjects() {
        return this.sequenceObjects;
    }

    @Override
    public Set<String> getUserDsFunctions() {
        return this.userDsFunctions;
    }

    @Override
    public void reset() {
        this.mappingObjects.clear();
    }

    @Override
    public void cleanSequences() {
        for (SequenceHandler handler : this.sequenceObjects.values()) {
            handler.clean();
        }
        this.sequenceObjects.clear();
        this.sequenceKey = null;
    }

    @Override
    public void raiseError(String error) throws SemanticMapperException {
        throw new SemanticMapperException(3013, error);
    }

    @Override
    public void destroy() {
        if (this.dataspaceAccessor != null) {
            this.dataspaceAccessor.close();
            this.dataspaceAccessor = null;
        }
    }
}

