/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.mapper.mf;

import com.streamscape.Trace;
import com.streamscape.omf.mapper.ConverterPlugin;
import com.streamscape.omf.mapper.ConverterPluginDescriptor;
import com.streamscape.omf.mapper.mf.ConverterPluginManagerException;
import com.streamscape.repository.types.AbstractSemanticFactory;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.runtime.mf.admin.obj.SemanticObjectReferenceStore;
import com.streamscape.sef.mf.admin.FabricContext;
import com.streamscape.sef.utils.RepositoryUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ConverterPluginManager
extends AbstractSemanticFactory {
    protected static final String NAMESPACE = "/sys/converter";
    protected FabricContext context;
    protected boolean repositoryEnabled;
    private Map<String, ConverterPluginDescriptor> converters = new HashMap<String, ConverterPluginDescriptor>();

    protected ConverterPluginManager(FabricContext context, boolean repositoryEnabled) {
        this.context = context;
        this.repositoryEnabled = repositoryEnabled;
    }

    public void init() throws ConverterPluginManagerException {
        if (this.repositoryEnabled) {
            this.loadConverters();
        }
    }

    protected void loadConverters() throws ConverterPluginManagerException {
        Trace.logDebug(this, "Loading converter plugins...");
        try {
            SemanticObjectReferenceStore.beginXact();
            SemanticObjectReferenceStore.setReferenceContext(RepositoryUtils.getReferenceContext(NAMESPACE, true, true));
            for (String converterName : SemanticObjectReferenceStore.listBoundNames(null)) {
                Object object = SemanticObjectReferenceStore.lookup(converterName);
                if (ConverterPluginDescriptor.class.isAssignableFrom(object.getClass())) {
                    this.converters.put(converterName, (ConverterPluginDescriptor)object);
                    continue;
                }
                Trace.logError(this, "Object '" + converterName + "' is not instance of " + ConverterPluginDescriptor.class.getName() + " and will be ignored.");
            }
            SemanticObjectReferenceStore.commitXact();
        }
        catch (Throwable exception) {
            SemanticObjectReferenceStore.abortXactSafe();
            throw new ConverterPluginManagerException("Loading of converter plugins failed." + exception.getMessage());
        }
        Trace.logInfo(this, "Converter plugins loaded.");
    }

    public synchronized ConverterPlugin<?, ?> createConverterPlugin(String name, ClassLoader loader) throws ConverterPluginManagerException {
        if (!this.converters.containsKey(name)) {
            throw new ConverterPluginManagerException(3044, "Converter plugin '" + name + "' does not exist.");
        }
        try {
            ConverterPluginDescriptor descriptor = this.converters.get(name);
            Class<?> clazz = loader.loadClass(descriptor.getPluginClassName());
            return (ConverterPlugin)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new ConverterPluginManagerException("Instantiation of converter plugin '" + name + "' failed. " + exception.getMessage());
        }
    }

    public synchronized ConverterPlugin<?, ?> createConverterPlugin(String name) throws ConverterPluginManagerException {
        return this.createConverterPlugin(name, this.context.getSystemClassLoaderChain());
    }

    public synchronized void registerConverterPlugin(String name, String className, String inboundSemanticType, String outboundSemanticType, String description) throws ConverterPluginManagerException {
        if (this.converters.containsKey(name)) {
            throw new ConverterPluginManagerException(3043, "Converter plugin '" + name + "' already exists.");
        }
        try {
            ConverterPluginDescriptor descriptor = new ConverterPluginDescriptor(name, className);
            descriptor.setInboundSemanticType(inboundSemanticType);
            descriptor.setOutboundSemanticType(outboundSemanticType);
            descriptor.setDescription(description);
            if (this.repositoryEnabled) {
                RepositoryUtils.bindObject(NAMESPACE, name, (Object)descriptor);
            }
            this.converters.put(name, descriptor);
        }
        catch (Exception exception) {
            throw new ConverterPluginManagerException("Binding of converter plugin '" + name + "' to repository failed. " + exception.getMessage());
        }
    }

    public synchronized void registerConverterPlugin(ConverterPluginDescriptor descriptor) throws ConverterPluginManagerException {
        if (this.converters.containsKey(descriptor.getName())) {
            throw new ConverterPluginManagerException(3043, "Converter plugin '" + descriptor.getName() + "' already exists.");
        }
        try {
            if (this.repositoryEnabled) {
                RepositoryUtils.bindObject(NAMESPACE, descriptor.getName(), (Object)descriptor);
            }
            this.converters.put(descriptor.getName(), descriptor);
        }
        catch (Exception exception) {
            throw new ConverterPluginManagerException("Binding of converter plugin '" + descriptor.getName() + "' to repository failed. " + exception.getMessage());
        }
    }

    public synchronized void unregisterConverterPlugin(String name) throws ConverterPluginManagerException {
        if (!this.converters.containsKey(name)) {
            throw new ConverterPluginManagerException(3044, "Converter plugin '" + name + "' does not exist.");
        }
        if (this.converters.remove(name) != null && this.repositoryEnabled) {
            try {
                RepositoryUtils.unbindObject(NAMESPACE, name);
            }
            catch (Exception exception) {
                throw new ConverterPluginManagerException("Unbinding of converter plugin '" + name + "' from repository failed. " + exception.getMessage());
            }
        }
    }

    public synchronized ConverterPluginDescriptor getConverterPluginDescriptor(String name) {
        return this.converters.get(name);
    }

    public synchronized boolean existsConverterPlugin(String name) {
        return this.converters.containsKey(name);
    }

    public synchronized List<String> listConverterPlugins() {
        return new ArrayList<String>(this.converters.keySet());
    }

    public synchronized void updateConverterPluginDescriptor(ConverterPluginDescriptor configuration) throws ConverterPluginManagerException {
        if (this.repositoryEnabled) {
            if (!this.converters.containsKey(configuration.getName())) {
                throw new ConverterPluginManagerException(3044, "Converter plugin '" + configuration.getName() + "' does not exist.");
            }
            try {
                RepositoryUtils.bindObject(NAMESPACE, configuration.getName(), (Object)configuration);
            }
            catch (ObjectConfigurationException exception) {
                throw new ConverterPluginManagerException("Update of converter plugin descriptor '" + configuration.getName() + "' in repository failed. " + exception.getMessage());
            }
        }
    }
}

