/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.mapper;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.omf.java.Utils;
import com.streamscape.omf.mapper.MappingObject;
import com.streamscape.omf.mapper.MappingRule;
import com.streamscape.omf.mapper.SemanticMap;
import com.streamscape.omf.mapper.SemanticMapper;
import com.streamscape.omf.mapper.SemanticMapperException;
import com.streamscape.omf.mapper.parser.Parser;
import com.streamscape.omf.mapper.parser.SemanticMapperContext;
import com.streamscape.omf.mapper.parser.Statement;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.excp.ValidationError;
import com.streamscape.sdo.excp.ValidationException;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sdo.validation.ValidationFactory;
import com.streamscape.sdo.validation.Validator;
import java.util.ArrayList;
import java.util.Map;

public final class SemanticMapperImpl
implements SemanticMapper {
    private String targetClassName;
    private Class<?> targetObjectClass = null;
    private Validator targetValidator = null;
    private Map<Class<?>, Validator> sourceValidators = null;
    private SemanticMap semanticMap;
    private SemanticMapperContext context;
    private String dataspaceContext = null;
    private boolean isInitialized = false;

    public SemanticMapperImpl(SemanticMapperContext context) {
        this.context = context;
    }

    public void setSemanticMap(SemanticMap semanticMap) {
        this.semanticMap = semanticMap;
        if (this.dataspaceContext == null) {
            this.dataspaceContext = semanticMap.getDefaultDataspace();
        }
    }

    public void setDataspaceContext(String dataspaceContext) {
        this.dataspaceContext = dataspaceContext;
    }

    public void init() throws SemanticMapperException {
        if (this.isInitialized) {
            throw new SemanticMapperException("Semantic mapper already initializer. Destroy first.");
        }
        try {
            if (this.semanticMap.getSources().size() == 0) {
                throw new IllegalArgumentException("Source object(s) is not specified.");
            }
            if (this.semanticMap.getTarget() == null || this.semanticMap.getTarget().getAlias().length() == 0) {
                throw new IllegalArgumentException("Target object is not specified.");
            }
            for (MappingObject sourceObjectType : this.semanticMap.getSources()) {
                this.context.getSemanticTypeCache().resolveSemanticType(sourceObjectType.getSemanticType());
            }
            this.targetClassName = this.context.getSemanticTypeCache().resolveSemanticType(this.semanticMap.getTarget().getSemanticType());
            if (this.dataspaceContext == null) {
                this.dataspaceContext = DataspaceType.TSPACE.name() + ".SDS";
            }
            this.initSourceValidators();
            this.initTargetValidator();
            this.context.initDataspaceAccessor(this.dataspaceContext);
            this.isInitialized = true;
        }
        catch (Exception error) {
            this.isInitialized = false;
            this.destroy();
            throw new SemanticMapperException(3002, error.getMessage());
        }
    }

    private void initSourceValidators() throws ClassNotFoundException {
        if (this.semanticMap.canValidateSource()) {
            for (MappingObject sourceObject : this.semanticMap.getSources()) {
                this.initValidatorFor(sourceObject);
            }
        }
    }

    private Validator initValidatorFor(MappingObject sourceObject) throws ClassNotFoundException {
        SemanticType type = this.context.getSemanticTypeCache().lookupSemanticType(sourceObject.getSemanticType());
        if (type == null) {
            throw new IllegalArgumentException("Unable to resolve source semantic type '" + String.valueOf(sourceObject) + "'.");
        }
        Validator sourceValidator = new ValidationFactory(this.context.getClassLoader(), this.context.getSemanticTypeCache()).lookupValidatorForType(type);
        if (sourceValidator == null) {
            throw new IllegalArgumentException("Unable to resolve validator for source type '" + String.valueOf(sourceObject) + ".");
        }
        Class<?> sourceObjectClass = this.context.loadClass(type.getClassName());
        this.sourceValidators.put(sourceObjectClass, sourceValidator);
        return sourceValidator;
    }

    protected void initTargetValidator() throws ClassNotFoundException {
        if (this.semanticMap.canValidateTarget()) {
            SemanticType type = this.context.getSemanticTypeCache().lookupSemanticType(this.semanticMap.getTarget().getSemanticType());
            if (type == null) {
                throw new IllegalArgumentException("Unable to resolve target semantic type.");
            }
            this.targetValidator = new ValidationFactory(this.context.getClassLoader(), this.context.getSemanticTypeCache()).lookupValidatorForType(type);
            if (this.targetValidator == null) {
                throw new IllegalArgumentException("Unable to resolve validator for target type.");
            }
            this.targetObjectClass = this.context.loadClass(type.getClassName());
        }
    }

    public void validate() {
    }

    @Override
    public void resetSourceObjects() {
        if (this.context != null) {
            this.context.reset();
        }
    }

    @Override
    public void setSourceObject(String alias, Object inbound) throws SemanticMapperException, ValidationException {
        this.checkInitialized();
        String semType = this.context.getSemanticTypeCache().resolveSemanticClass(inbound.getClass());
        if (this.semanticMap.canValidateSource()) {
            Validator validator = this.sourceValidators.get(semType);
            if (validator == null) {
                try {
                    validator = this.initValidatorFor(new MappingObject(semType, alias));
                }
                catch (Exception error) {
                    throw new IllegalStateException("Unable to init validator for source object '" + semType + "'. " + error.getMessage());
                }
            }
            if (validator != null) {
                validator.validate(inbound);
            } else {
                throw new IllegalStateException("Unable to init validator for source object '" + semType + "'.");
            }
        }
        if (this.context.getMappingObject(alias) != null) {
            throw new IllegalArgumentException("Object '" + alias + "' already set.");
        }
        this.context.addMappingObject(alias, inbound);
        if (inbound instanceof ImmutableEventDatagram) {
            this.context.setMacroProcessorEvent((ImmutableEventDatagram)inbound);
        }
    }

    @Override
    public Object convert() throws SemanticMapperException, ValidationException {
        return this.convertWithRules(new int[0]);
    }

    @Override
    public Object convert(Object inbound) throws SemanticMapperException, ValidationException {
        return this.convertWithRules(inbound, new int[0]);
    }

    @Override
    public Object convertWithRules(Object inbound, int ... ruleIds) throws SemanticMapperException, ValidationException {
        this.checkInitialized();
        try {
            this.context.reset();
            if (inbound instanceof Object[]) {
                for (MappingObject source : this.semanticMap.getSources()) {
                    if (!source.getSemanticType().equals("Row")) continue;
                    inbound = new Row(new RowMetaData(source.getColumns()), (Object[])inbound);
                    break;
                }
            }
            String alias = this.context.getSemanticTypeCache().resolveSemanticClass(inbound.getClass());
            for (MappingObject source : this.semanticMap.getSources()) {
                if (!source.getSemanticType().equals(alias)) continue;
                alias = source.getAlias();
                break;
            }
            this.context.addMappingObject(alias, inbound);
            return this.convertWithRules(ruleIds);
        }
        catch (Exception error) {
            Trace.logException(this, error, true);
            throw new SemanticMapperException(3002, Utils.formatExceptionWithUnrepeatedCauses(error));
        }
    }

    @Override
    public Object convertWithRules(int ... ruleIds) throws SemanticMapperException, ValidationException {
        this.checkInitialized();
        try {
            Object mappingRulesSelected;
            if (this.semanticMap == null) {
                throw new IllegalStateException("Semantic map is not set.");
            }
            Object outbound = null;
            boolean targetFromSource = false;
            if (!this.semanticMap.getTarget().equals(this.semanticMap.getSources().get(0)) && this.targetClassName != null) {
                for (MappingObject sourceObject : this.semanticMap.getSources()) {
                    if (!sourceObject.getAlias().equals(this.semanticMap.getTarget().getAlias())) continue;
                    targetFromSource = true;
                    break;
                }
                if (!targetFromSource) {
                    if (this.semanticMap.getTarget().getEventId() != null) {
                        outbound = EventDatagramFactory.getInstance().createEvent(this.semanticMap.getTarget().getEventId());
                    } else if (Row.class.getName().equals(this.targetClassName)) {
                        outbound = new Row(new RowMetaData(this.semanticMap.getTarget().getColumns()));
                    } else if (this.targetClassName != null) {
                        outbound = this.context.instantiateClass(this.context.loadClass(this.targetClassName));
                    } else {
                        throw new IllegalStateException("Unable to init target.");
                    }
                    this.context.addMappingObject(this.semanticMap.getTarget().getAlias(), outbound);
                }
            }
            Parser parser = new Parser();
            Object mappingRules = this.semanticMap.getMappingRules();
            if (ruleIds != null && ruleIds.length > 0) {
                mappingRulesSelected = new ArrayList();
                for (int ruleId : ruleIds) {
                    if (ruleId < 0 || ruleId >= mappingRules.size()) {
                        throw new SemanticMapperException(3013, "Invalid ruleId '" + ruleId + "' specified.");
                    }
                    mappingRulesSelected.add((MappingRule)mappingRules.get(ruleId));
                }
                mappingRules = mappingRulesSelected;
            }
            mappingRulesSelected = mappingRules.iterator();
            while (mappingRulesSelected.hasNext()) {
                MappingRule mappingRule = (MappingRule)mappingRulesSelected.next();
                Statement stat = parser.parse(this.context, mappingRule.getRule());
                if (stat != null) {
                    stat.execute(this.context);
                    continue;
                }
                throw new SemanticMapperException(3013, "Unable to parse expression '" + mappingRule.getRule() + "'.");
            }
            if (targetFromSource && outbound == null) {
                outbound = this.context.getMappingObject(this.semanticMap.getTarget().getAlias());
            }
            if (this.semanticMap.canValidateTarget()) {
                if (this.targetValidator == null || this.targetObjectClass != null && this.targetObjectClass != outbound.getClass()) {
                    this.initTargetValidator();
                }
                this.targetValidator.validate(outbound);
            }
            return outbound;
        }
        catch (ValidationException exception) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(exception.getMessage());
            for (ValidationError error : exception.getErrors()) {
                buffer.append(" Field '" + error.name + "' : " + error.value);
            }
            ValidationException newException = new ValidationException(5076, buffer.toString());
            for (ValidationError error : exception.getErrors()) {
                newException.addError(error.name, error.value);
            }
            throw newException;
        }
        catch (Exception error) {
            Trace.logException(this, error, true);
            throw new SemanticMapperException(3002, error.getMessage());
        }
    }

    private void checkInitialized() throws SemanticMapperException {
        if (!this.isInitialized) {
            throw new SemanticMapperException("Semantic mapper is not initialized.");
        }
    }

    public void destroy() {
        if (this.context != null) {
            try {
                this.context.destroy();
            }
            catch (Exception exception) {
                Trace.logException(this, exception, true);
            }
        }
        this.targetValidator = null;
        this.sourceValidators = null;
        this.isInitialized = false;
    }

    @Override
    public void close() {
        this.destroy();
    }

    @Override
    public SemanticMap getSemanticMap() {
        try {
            return (SemanticMap)SDOUtils.clone(this.semanticMap);
        }
        catch (SDOException sDOException) {
            return this.semanticMap;
        }
    }
}

