/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.mapper;

import com.streamscape.omf.mapper.MappingObject;
import com.streamscape.omf.mapper.MappingRule;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class SemanticMap {
    public static String SEMANTIC_MAP_OBJECTS_NAMESPACE = "/mapper";
    private List<MappingObject> sources = new ArrayList<MappingObject>();
    private MappingObject target = new MappingObject();
    private List<MappingRule> mappingRules = new ArrayList<MappingRule>();
    private boolean validateSource = false;
    private boolean validateTarget = false;
    private String defaultDataspace = "TSPACE.SDS";
    private int version = 0;
    private byte[] ux = new byte[0];

    public boolean canValidateSource() {
        return this.validateSource;
    }

    public void setValidateSource(boolean validateSource) {
        this.validateSource = validateSource;
    }

    public boolean canValidateTarget() {
        return this.validateTarget;
    }

    public void setValidateTarget(boolean validateTarget) {
        this.validateTarget = validateTarget;
    }

    public String getDefaultDataspace() {
        return this.defaultDataspace;
    }

    public void setDefaultDataspace(String defaultDataspace) {
        this.defaultDataspace = defaultDataspace;
    }

    public List<MappingObject> getSources() {
        return this.sources;
    }

    public void setSources(List<MappingObject> sources) {
        HashSet<String> aliases = new HashSet<String>();
        for (MappingObject obj : sources) {
            if (aliases.add(obj.getAlias())) continue;
            throw new IllegalArgumentException("Sources with duplicate aliases are not allowed.");
        }
        this.sources = sources;
    }

    public void addSource(MappingObject source) {
        for (MappingObject obj : this.sources) {
            if (!obj.getAlias().equals(source.getAlias())) continue;
            throw new IllegalArgumentException("Mapping Object with alias '" + source.getAlias() + "' already added.");
        }
        this.sources.add(source);
    }

    public void addSources(List<MappingObject> sources) {
        sources.forEach(source -> this.addSource((MappingObject)source));
    }

    public void removeSource(String alias) {
        Iterator<MappingObject> iter = this.sources.iterator();
        while (iter.hasNext()) {
            MappingObject obj = iter.next();
            if (!obj.getAlias().equals(alias)) continue;
            iter.remove();
            break;
        }
    }

    public MappingObject getTarget() {
        return this.target;
    }

    public void setTarget(MappingObject targetObject) {
        this.target = targetObject;
    }

    public List<MappingRule> getMappingRules() {
        return this.mappingRules;
    }

    public void addMappingRule(MappingRule mappingRule) {
        this.mappingRules.add(mappingRule);
    }

    public void addMappingRules(List<MappingRule> mappingRules) {
        this.mappingRules.addAll(mappingRules);
    }

    public void removeMappingRule(MappingRule mappingRule) {
        this.mappingRules.remove(mappingRule);
    }

    public void clearMappingRules() {
        this.mappingRules.clear();
    }

    public void addMappingRule(int sequence, MappingRule mappingRule) {
        this.mappingRules.add(sequence, mappingRule);
    }

    public void setMappingRules(List<MappingRule> mappingRules) {
        this.mappingRules = mappingRules;
    }

    public void removeMappingRule(int sequence) {
        this.mappingRules.remove(sequence);
    }

    public void updateMappingRule(MappingRule oldMappingRule, MappingRule newMappingRule) {
        for (int i = 0; i < this.mappingRules.size(); ++i) {
            if (!this.mappingRules.get(i).equals(oldMappingRule)) continue;
            this.mappingRules.remove(i);
            this.mappingRules.add(i, newMappingRule);
            break;
        }
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public byte[] getUX() {
        return this.ux;
    }

    public void setUX(byte[] ux) {
        this.ux = ux;
    }
}

