/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.mapper;

import com.streamscape.omf.ObjectMediationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DecodeTable {
    private String name;
    private String defaultValue;
    private Map<String, String> decodeTable = new HashMap<String, String>();

    protected DecodeTable() {
    }

    public DecodeTable(String name, String defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDefault(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public void addElement(String sourceValue, String decodeValue) throws ObjectMediationException {
        if (this.decodeTable.containsKey(sourceValue)) {
            throw new ObjectMediationException(3030, "Source value '" + sourceValue + "' already exists.");
        }
        this.decodeTable.put(sourceValue, decodeValue);
    }

    public void removeElement(String sourceValue) throws ObjectMediationException {
        if (!this.decodeTable.containsKey(sourceValue)) {
            throw new ObjectMediationException(3031, "Source value '" + sourceValue + "' does not exist.");
        }
        this.decodeTable.remove(sourceValue);
    }

    public String decode(String value) {
        if (value == null) {
            return this.defaultValue;
        }
        if (!this.decodeTable.containsKey(value)) {
            return "undefined";
        }
        return this.decodeTable.get(value);
    }

    public String assertDecode(String value) throws ObjectMediationException {
        if (value == null) {
            return this.defaultValue;
        }
        if (!this.decodeTable.containsKey(value)) {
            throw new ObjectMediationException(3031, "Source value '" + value + "' does not exist.");
        }
        return this.decodeTable.get(value);
    }

    public void initTable(Map<String, String> table) {
        this.decodeTable.putAll(table);
    }

    public void clearTable() {
        this.decodeTable.clear();
    }

    public List<String> listElements() {
        return new ArrayList<String>(this.decodeTable.keySet());
    }
}

