/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.json.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TokenizedText {
    private String text;
    private List<Token> tokens = new ArrayList<Token>();
    private List<Token> stopwordsFiltered = new ArrayList<Token>();
    private List<Token> posFiltered = new ArrayList<Token>();
    private List<Replacement> replacements = new ArrayList<Replacement>();
    private List<String> ngram2;
    private List<String> ngram3;
    private List<String> ngram4;

    public TokenizedText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    public TokenizedText setTokens(List<Token> tokens) {
        this.tokens = tokens;
        return this;
    }

    public List<Token> getStopwordsFiltered() {
        return this.stopwordsFiltered;
    }

    public TokenizedText setStopwordsFiltered(List<Token> stopwordsFiltered) {
        this.stopwordsFiltered = stopwordsFiltered;
        return this;
    }

    public TokenizedText addStopwordsFiltered(Token token) {
        if (this.stopwordsFiltered == null) {
            this.stopwordsFiltered = new ArrayList<Token>();
        }
        this.stopwordsFiltered.add(token);
        return this;
    }

    public List<Token> getPosFiltered() {
        return this.posFiltered;
    }

    public TokenizedText setPosFiltered(List<Token> posFiltered) {
        this.posFiltered = posFiltered;
        return this;
    }

    public TokenizedText addPosFiltered(Token token) {
        if (this.posFiltered == null) {
            this.posFiltered = new ArrayList<Token>();
        }
        this.posFiltered.add(token);
        return this;
    }

    public List<Replacement> getReplacements() {
        return this.replacements;
    }

    public TokenizedText setReplacements(List<Replacement> replacements) {
        this.replacements = replacements;
        return this;
    }

    public void setNgram2(List<String> ngram2) {
        this.ngram2 = ngram2;
    }

    public List<String> getNgram2() {
        return this.ngram2;
    }

    public List<String> getNgram3() {
        return this.ngram3;
    }

    public TokenizedText setNgram3(List<String> ngram3) {
        this.ngram3 = ngram3;
        return this;
    }

    public List<String> getNgram4() {
        return this.ngram4;
    }

    public TokenizedText setNgram4(List<String> ngram4) {
        this.ngram4 = ngram4;
        return this;
    }

    public List<Token> getMergedTokens() {
        return Stream.concat(Stream.concat(this.getTokens().stream(), this.getStopwordsFiltered().stream()), this.getPosFiltered().stream()).sorted(Comparator.comparingInt(Token::getStart)).collect(Collectors.toList());
    }

    public static class Replacement {
        private String original;
        private String replacement;
        private int start;
        private int end;
        private String reason;

        public Replacement(String original, String replacement, int start, int end, String reason) {
            this.original = original;
            this.replacement = replacement;
            this.start = start;
            this.end = end;
            this.reason = reason;
        }

        public String getOriginal() {
            return this.original;
        }

        public String getReplacement() {
            return this.replacement;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public String getReason() {
            return this.reason;
        }
    }

    public static class Token {
        private String token;
        private int start;
        private int end;
        private String pos;
        private RuleType ruleType;
        private String lemma;
        private String synonym;

        public Token(String token, int start, int end, String pos) {
            this.token = token;
            this.start = start;
            this.end = end;
            this.pos = pos;
            this.ruleType = RuleType.TOKEN;
        }

        public String getToken() {
            return this.token;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public String getPos() {
            return this.pos;
        }

        public void setPos(String pos) {
            this.pos = pos;
        }

        public RuleType getRuleType() {
            return this.ruleType;
        }

        public Token setRuleType(RuleType ruleType) {
            this.ruleType = ruleType;
            return this;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public void setLemma(String token) {
            if (!this.token.equals(token)) {
                this.ruleType = RuleType.LEMMATIZED;
                this.lemma = token;
            }
        }

        public String getFinalToken() {
            return this.synonym != null ? this.synonym : (this.lemma != null ? this.lemma : this.token);
        }

        public String getSynonym() {
            return this.synonym;
        }

        public Token setSynonym(String synonym) {
            this.ruleType = RuleType.SYNONYM_REPLACED;
            this.synonym = synonym;
            return this;
        }
    }

    public static enum RuleType {
        TOKEN,
        LEMMATIZED,
        STOPWORD_EXCLUDED,
        POS_EXCLUDED,
        SYNONYM_REPLACED;

    }
}

