/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.json.utils;

import com.streamscape.omf.json.utils.TokenizedJsonPrinter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;

public class TokenizedJson
extends LinkedHashMap<TokenizedJsonKey, TokenizedJsonValue> {
    private DisplayType displayType = DisplayType.JSON_PLAIN;

    public DisplayType getDisplayType() {
        return this.displayType;
    }

    public TokenizedJson setDisplayType(DisplayType displayType) {
        this.displayType = displayType;
        return this;
    }

    public <T extends TokenizedJsonPrinter> T print(T printer) {
        printer.onObjectStart();
        this.entrySet().stream().forEach((? super T e) -> {
            printer.onKey((TokenizedJsonKey)e.getKey());
            this.print((TokenizedJsonKey)e.getKey(), (TokenizedJsonValue)e.getValue(), false, printer);
        });
        printer.onObjectEnd();
        return printer;
    }

    private void print(TokenizedJsonKey key, TokenizedJsonValue value, boolean arrayValue, TokenizedJsonPrinter printer) {
        if (value == null) {
            if (arrayValue) {
                printer.onArrayValue(key, null);
            }
            return;
        }
        if (value.isNode()) {
            value.getNode().print(printer);
        } else if (value.isArray()) {
            printer.onArrayStart();
            value.getArray().forEach((? super E node) -> this.print(key, (TokenizedJsonValue)node, true, printer));
            printer.onArrayEnd();
        } else if (arrayValue) {
            printer.onArrayValue(key, value);
        } else {
            printer.onValue(key, value);
        }
    }

    public void visitLeafs(BiConsumer<String, Object> consumer) {
        this.entrySet().stream().forEach((? super T e) -> this.visitLeafs(consumer, (TokenizedJsonKey)e.getKey(), (TokenizedJsonValue)e.getValue()));
    }

    private void visitLeafs(BiConsumer<String, Object> consumer, TokenizedJsonKey key, TokenizedJsonValue value) {
        if (value.isNode()) {
            value.getNode().visitLeafs(consumer);
        } else if (value.isArray()) {
            value.getArray().forEach((? super E node) -> this.visitLeafs(consumer, key, (TokenizedJsonValue)node));
        } else {
            consumer.accept(key.getPath(), value.getValue());
        }
    }

    public static enum DisplayType {
        JSON_PLAIN,
        JSON_WITH_STRIKETHROUGH,
        JSON_WITH_TOKENS_AND_PATH,
        PATHS_TABLE;

    }

    public static class TokenizedJsonKey {
        private String key;
        private String path;
        private boolean isExcluded;
        private Set<String> causedBy;

        protected TokenizedJsonKey() {
        }

        private TokenizedJsonKey(String key, String path, boolean isExcluded, Set<String> causedBy) {
            this.key = key;
            this.path = path;
            this.isExcluded = isExcluded;
            this.causedBy = causedBy;
        }

        public String getKey() {
            return this.key;
        }

        public String getPath() {
            return this.path;
        }

        public boolean isExcluded() {
            return this.isExcluded;
        }

        public Set<String> getCausedBy() {
            return this.causedBy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TokenizedJsonKey)) {
                return false;
            }
            TokenizedJsonKey that = (TokenizedJsonKey)o;
            return Objects.equals(this.key, that.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }

        public static TokenizedJsonKey of(String key, String path, boolean isExcluded, Set<String> causedBy) {
            return new TokenizedJsonKey(key, path, isExcluded, causedBy);
        }

        public static TokenizedJsonKey of(String key) {
            return new TokenizedJsonKey(key, null, false, null);
        }
    }

    public static class TokenizedJsonValue {
        private Object value;
        private boolean isExcluded;
        private boolean isTokenized;
        private boolean isCompound;
        private List<String> tokens;
        private Set<String> causedBy;

        protected TokenizedJsonValue() {
        }

        private TokenizedJsonValue(TokenizedJson value) {
            this.value = value;
            this.isExcluded = false;
            this.isTokenized = false;
            this.isCompound = false;
        }

        private TokenizedJsonValue(ArrayList<Object> value) {
            this.value = value;
            this.isExcluded = false;
            this.isTokenized = false;
            this.isCompound = false;
        }

        private TokenizedJsonValue(Object value, boolean isExcluded, boolean isTokenized, boolean isCompound, List<String> tokens, Set<String> causedBy) {
            this.value = value;
            this.isExcluded = isExcluded;
            this.isTokenized = isTokenized;
            this.isCompound = isCompound;
            this.tokens = tokens;
            this.causedBy = causedBy;
        }

        public static TokenizedJsonValue valueNode() {
            return new TokenizedJsonValue(new TokenizedJson());
        }

        public static TokenizedJsonValue valueArray() {
            return new TokenizedJsonValue(new ArrayList<Object>());
        }

        public static TokenizedJsonValue of(Object value, boolean isExcluded, boolean isTokenized, boolean isCompound, String[] tokens, Set<String> causedBy) {
            return new TokenizedJsonValue(value, isExcluded, isTokenized, isCompound, tokens != null ? new ArrayList<String>(Arrays.asList(tokens)) : new ArrayList(), causedBy);
        }

        public boolean isNode() {
            return this.value instanceof TokenizedJson;
        }

        public boolean isArray() {
            return this.value instanceof ArrayList;
        }

        public TokenizedJson getNode() {
            return (TokenizedJson)this.value;
        }

        public ArrayList getArray() {
            return (ArrayList)this.value;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isExcluded() {
            return this.isExcluded;
        }

        public boolean isTokenized() {
            return this.isTokenized;
        }

        public boolean isCompound() {
            return this.isCompound;
        }

        public List<String> getTokens() {
            return this.tokens;
        }

        public Set<String> getCausedBy() {
            return this.causedBy;
        }
    }
}

