/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.json.utils;

import com.streamscape.omf.json.utils.TokenizedJson;
import com.streamscape.omf.json.utils.TokenizedJsonPartPrinter;
import com.streamscape.omf.json.utils.TokenizedJsonPrinter;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class TextTokenizedJsonPrinter
implements TokenizedJsonPrinter {
    private final int INDENT = 2;
    private int indent = 0;
    private TokenizedJsonPartPrinter partPrinter;
    private boolean lastNewLine = false;

    protected TextTokenizedJsonPrinter(TokenizedJsonPartPrinter partPrinter) {
        this.partPrinter = partPrinter;
    }

    public static TextTokenizedJsonPrinter of(TokenizedJsonPartPrinter partPrinter) {
        return new TextTokenizedJsonPrinter(partPrinter);
    }

    @Override
    public void onObjectStart() {
        if (this.lastNewLine) {
            this.printIdent();
        }
        this.partPrinter.onPrintDelimiters("{\n");
        this.indent += 2;
        this.lastNewLine = true;
    }

    @Override
    public void onObjectEnd() {
        this.indent -= 2;
        this.printIdent();
        this.partPrinter.onPrintDelimiters("}\n");
        this.lastNewLine = true;
    }

    @Override
    public void onArrayStart() {
        this.partPrinter.onPrintDelimiters("[\n");
        this.indent += 2;
        this.lastNewLine = true;
    }

    @Override
    public void onArrayEnd() {
        this.indent -= 2;
        this.printIdent();
        this.partPrinter.onPrintDelimiters("]\n");
        this.lastNewLine = true;
    }

    @Override
    public void onKey(TokenizedJson.TokenizedJsonKey key) {
        this.printIdent();
        this.partPrinter.onPrintKey(this.quoteKey(key.getKey()), key.isExcluded());
        this.partPrinter.onPrintDelimiters(" : ");
        this.lastNewLine = false;
    }

    @Override
    public void onValue(TokenizedJson.TokenizedJsonKey key, TokenizedJson.TokenizedJsonValue value) {
        String svalue = this.quoteValue(value != null ? value.getValue() : null);
        String compoundValue = null;
        if (value != null && value.isCompound() && value.getTokens().size() > 0) {
            compoundValue = this.quoteValue(value.getTokens().get(0));
        }
        this.partPrinter.onPrintValue(svalue, compoundValue, value.isExcluded());
        this.partPrinter.onPrintValueTokens(value != null ? value.getTokens() : Collections.emptyList(), key);
        this.partPrinter.onPrintDelimiters("\n");
        this.lastNewLine = true;
    }

    @Override
    public void onArrayValue(TokenizedJson.TokenizedJsonKey key, TokenizedJson.TokenizedJsonValue value) {
        this.printIdent();
        this.onValue(key, value);
    }

    private void printIdent() {
        this.partPrinter.onPrintDelimiters(IntStream.range(0, this.indent).mapToObj(i -> " ").collect(Collectors.joining("")));
    }

    private String quoteKey(String key) {
        return "\"" + key.replace("\"", "\\\"") + "\"";
    }

    private String quoteValue(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "\"" + ((String)value).replace("\"", "\\\"") + "\"";
        }
        return String.valueOf(value);
    }
}

