/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.json.utils;

import com.streamscape.omf.json.utils.TokenizedJson;
import com.streamscape.omf.json.utils.TokenizedJsonPartPrinter;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;

public class SimpleTokenizedJsonPartPrinter
implements TokenizedJsonPartPrinter {
    private ByteArrayOutputStream byteArrayOutputStream;
    private final PrintStream printStream;

    private SimpleTokenizedJsonPartPrinter(PrintStream printStream) {
        this.printStream = printStream;
    }

    private SimpleTokenizedJsonPartPrinter(ByteArrayOutputStream byteArrayOutputStream) {
        this.byteArrayOutputStream = byteArrayOutputStream;
        this.printStream = new PrintStream(byteArrayOutputStream);
    }

    public static SimpleTokenizedJsonPartPrinter of(PrintStream printStream) {
        return new SimpleTokenizedJsonPartPrinter(printStream);
    }

    public static SimpleTokenizedJsonPartPrinter of() {
        return new SimpleTokenizedJsonPartPrinter(new ByteArrayOutputStream());
    }

    @Override
    public void onPrintDelimiters(String s) {
        this.printStream.append(s);
    }

    @Override
    public void onPrintKey(String key, boolean excluded) {
        this.printStream.append(key);
    }

    @Override
    public void onPrintValue(String value, String compoundValue, boolean excluded) {
        this.printStream.append(value);
    }

    @Override
    public void onPrintValueTokens(List<String> tokens, TokenizedJson.TokenizedJsonKey key) {
        this.printStream.append("   --->    ");
        this.printStream.append(tokens.stream().collect(Collectors.joining(",")));
    }

    public String getText() {
        if (this.byteArrayOutputStream == null) {
            throw new RuntimeException("TextTokenizedJsonPrinter doesn't store string");
        }
        try {
            return this.byteArrayOutputStream.toString(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

