/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.json.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Primitives {
    public static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER_TYPE;
    public static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE_TYPE;

    private Primitives() {
    }

    private static void add(Map<Class<?>, Class<?>> forward, Map<Class<?>, Class<?>> backward, Class<?> key, Class<?> value) {
        forward.put(key, value);
        backward.put(value, key);
    }

    public static boolean isWrapperType(Class<?> type) {
        return WRAPPER_TO_PRIMITIVE_TYPE.containsKey(Primitives.checkNotNull(type));
    }

    public static boolean isPrimitive(Class<?> type) {
        return PRIMITIVE_TO_WRAPPER_TYPE.containsKey(Primitives.checkNotNull(type));
    }

    public static <T> Class<T> wrap(Class<T> type) {
        Primitives.checkNotNull(type);
        Class<?> wrapped = PRIMITIVE_TO_WRAPPER_TYPE.get(type);
        return wrapped == null ? type : wrapped;
    }

    public static <T> Class<T> unwrap(Class<T> type) {
        Primitives.checkNotNull(type);
        Class<?> unwrapped = WRAPPER_TO_PRIMITIVE_TYPE.get(type);
        return unwrapped == null ? type : unwrapped;
    }

    public static Object unwrap(Object obj) {
        if (obj instanceof Boolean) {
            return obj;
        }
        if (obj instanceof Byte) {
            return obj;
        }
        if (obj instanceof Character) {
            return obj;
        }
        if (obj instanceof Double) {
            return obj;
        }
        if (obj instanceof Float) {
            return obj;
        }
        if (obj instanceof Integer) {
            return obj;
        }
        if (obj instanceof BigInteger) {
            return ((BigInteger)obj).longValue();
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).doubleValue();
        }
        if (obj instanceof Long) {
            return obj;
        }
        if (obj instanceof Short) {
            return obj;
        }
        return obj;
    }

    private static Class<?> checkNotNull(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("Type is null.");
        }
        return type;
    }

    static {
        HashMap primToWrap = new HashMap(16);
        HashMap wrapToPrim = new HashMap(16);
        Primitives.add(primToWrap, wrapToPrim, Boolean.TYPE, Boolean.class);
        Primitives.add(primToWrap, wrapToPrim, Byte.TYPE, Byte.class);
        Primitives.add(primToWrap, wrapToPrim, Character.TYPE, Character.class);
        Primitives.add(primToWrap, wrapToPrim, Integer.TYPE, Integer.class);
        Primitives.add(primToWrap, wrapToPrim, Long.TYPE, BigInteger.class);
        Primitives.add(primToWrap, wrapToPrim, Double.TYPE, BigDecimal.class);
        Primitives.add(primToWrap, wrapToPrim, Long.TYPE, Long.class);
        Primitives.add(primToWrap, wrapToPrim, Double.TYPE, Double.class);
        Primitives.add(primToWrap, wrapToPrim, Float.TYPE, Float.class);
        Primitives.add(primToWrap, wrapToPrim, Short.TYPE, Short.class);
        Primitives.add(primToWrap, wrapToPrim, Void.TYPE, Void.class);
        PRIMITIVE_TO_WRAPPER_TYPE = Collections.unmodifiableMap(primToWrap);
        WRAPPER_TO_PRIMITIVE_TYPE = Collections.unmodifiableMap(wrapToPrim);
    }
}

