/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.json.utils;

import java.util.Stack;

public final class MemoryRefStack<T> {
    private final Stack<T> stack = new Stack();

    public T push(T obj) {
        if (obj == null) {
            throw new IllegalArgumentException("object is null");
        }
        return this.stack.push(obj);
    }

    public T pop() {
        return this.stack.pop();
    }

    public T peek() {
        return this.stack.peek();
    }

    public boolean contains(T obj) {
        if (obj == null) {
            return false;
        }
        for (Object stackObject : this.stack) {
            if (obj != stackObject) continue;
            return true;
        }
        return false;
    }

    public String getPath(T obj) {
        StringBuilder builder = new StringBuilder();
        for (int i = this.stack.size(); i > 0; --i) {
            builder.append("../");
            if (this.stack.elementAt(i - 1) == obj) break;
        }
        return builder.toString();
    }

    public Object getObject(String path) {
        int position = 0;
        int count = 0;
        path = path.trim();
        while (position + 3 <= path.length() && path.substring(position, position + 3).equals("../")) {
            position += 3;
            ++count;
        }
        if (position != path.length() || count > this.stack.size()) {
            return null;
        }
        return this.stack.elementAt(this.stack.size() - count);
    }
}

