/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.json.jackson;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.streamscape.omf.json.jackson.AsSemanticTypeDeserializer;
import com.streamscape.omf.json.jackson.AsSemanticTypeSerializer;
import com.streamscape.omf.json.jackson.AsTopElementDeserializer;
import com.streamscape.omf.json.jackson.AsTopElementSerializer;
import com.streamscape.omf.json.jackson.JacksonUtils;
import com.streamscape.omf.json.jackson.JsonNotation;
import com.streamscape.omf.json.jackson.JsonNotationLevel;
import com.streamscape.omf.json.jackson.SemanticTypeIdResolver;
import com.streamscape.omf.json.jackson.StreamscapeMapDeserializerResolver;
import com.streamscape.omf.mf.admin.ObjectMediationAliasManager;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

public class StreamscapeResolverBuilder
implements TypeResolverBuilder<StreamscapeResolverBuilder> {
    public static final String TYPE_PROPERTY_NAME = "@type";
    private final ObjectMediationAliasManager aliasManager;
    private final ClassLoader classLoader;
    private final JsonNotation jsonNotation;
    private final EnumSet<JsonNotationLevel> jsonNotationLevel;
    private final String typePropertyName = "@type";
    protected Class<?> defaultImpl;
    protected boolean typeIdVisible = false;

    public StreamscapeResolverBuilder(ObjectMediationAliasManager aliasManager, ClassLoader classLoader, JsonNotation jsonNotation, EnumSet<JsonNotationLevel> jsonNotationLevel) {
        this.aliasManager = aliasManager;
        this.classLoader = classLoader;
        this.jsonNotation = jsonNotation;
        this.jsonNotationLevel = jsonNotationLevel;
    }

    @Override
    public StreamscapeResolverBuilder init(JsonTypeInfo.Id idType, TypeIdResolver idRes) {
        throw new IllegalStateException("StreamscapeResolverBuilder.init method not allowed");
    }

    @Override
    public TypeSerializer buildTypeSerializer(SerializationConfig config, JavaType baseType, Collection<NamedType> subtypes) {
        if (!this.useForType(baseType)) {
            return null;
        }
        TypeIdResolver idResolver = this.idResolver(config, baseType);
        switch (this.jsonNotation) {
            case TYPE: {
                return new AsSemanticTypeSerializer(idResolver, null, TYPE_PROPERTY_NAME, this.jsonNotationLevel);
            }
            case TOP_ELEMENT: {
                return new AsTopElementSerializer(idResolver, null, this.jsonNotationLevel);
            }
        }
        throw new IllegalStateException("Do not know how to construct standard type serializer for notation: " + String.valueOf((Object)this.jsonNotation));
    }

    @Override
    public TypeDeserializer buildTypeDeserializer(DeserializationConfig config, JavaType baseType, Collection<NamedType> subtypes) {
        if (!this.useForType(baseType)) {
            return null;
        }
        TypeIdResolver idResolver = this.idResolver(config, baseType);
        switch (this.jsonNotation) {
            case TYPE: {
                return new AsSemanticTypeDeserializer(baseType, idResolver, TYPE_PROPERTY_NAME, this.typeIdVisible, baseType, this.jsonNotationLevel);
            }
            case TOP_ELEMENT: {
                return new AsTopElementDeserializer(baseType, idResolver, TYPE_PROPERTY_NAME, this.typeIdVisible, this.defaultImpl, this.jsonNotationLevel);
            }
        }
        throw new IllegalStateException("Do not know how to construct standard type serializer for notation: " + String.valueOf((Object)this.jsonNotation));
    }

    public boolean useForType(JavaType javaType) {
        boolean arrayType = javaType.isArrayType();
        while (javaType.isArrayType()) {
            javaType = javaType.getContentType();
        }
        if (arrayType && (javaType.getRawClass() == Byte.TYPE || javaType.getRawClass() == Byte.class)) {
            return false;
        }
        if (Collection.class.isAssignableFrom(javaType.getRawClass()) || Set.class.isAssignableFrom(javaType.getRawClass())) {
            return false;
        }
        if (Map.class.isAssignableFrom(javaType.getRawClass())) {
            return this.jsonNotation == JsonNotation.TYPE && this.jsonNotationLevel.contains((Object)JsonNotationLevel.POLYMORPHIC_MAPS_AND_COLLECTIONS) && !StreamscapeMapDeserializerResolver.mapFallbacks.values().contains(javaType.getRawClass());
        }
        if (this.jsonNotation == JsonNotation.TYPE && this.jsonNotationLevel.contains((Object)JsonNotationLevel.OLD_FABRIC_STYLE_DATE_AND_SQLTIMESTAMP) && (javaType.getRawClass() == Date.class || javaType.getRawClass() == Timestamp.class)) {
            return true;
        }
        if (!arrayType && JacksonUtils.isPrimitive(javaType.getRawClass())) {
            return this.jsonNotationLevel.contains((Object)JsonNotationLevel.PRIMITIVE_OBJECTS);
        }
        if (javaType.getRawClass() == Object.class && this.jsonNotationLevel.contains((Object)JsonNotationLevel.POLYMORPHIC_PRIMITIVE_OBJECTS)) {
            return true;
        }
        if (JacksonUtils.isEnum(javaType.getRawClass())) {
            return this.jsonNotationLevel.contains((Object)JsonNotationLevel.ROOT_ENUM) || this.jsonNotationLevel.contains((Object)JsonNotationLevel.ENUMS);
        }
        if (this.jsonNotationLevel.contains((Object)JsonNotationLevel.ROOT_ELEMENT) || this.jsonNotationLevel.contains((Object)JsonNotationLevel.COMPLEX_OBJECTS) || this.jsonNotationLevel.contains((Object)JsonNotationLevel.ROOT_ENUM)) {
            return true;
        }
        if (this.jsonNotationLevel.contains((Object)JsonNotationLevel.POLYMORPHIC_OBJECTS)) {
            return !javaType.isFinal() && !TreeNode.class.isAssignableFrom(javaType.getRawClass());
        }
        return false;
    }

    @Override
    public StreamscapeResolverBuilder inclusion(JsonTypeInfo.As includeAs) {
        throw new IllegalStateException("StreamscapeResolverBuilder.inclusion method not allowed");
    }

    @Override
    public StreamscapeResolverBuilder typeProperty(String typePropertyName) {
        throw new IllegalStateException("StreamscapeResolverBuilder.typeProperty method not allowed");
    }

    @Override
    public StreamscapeResolverBuilder defaultImpl(Class<?> defaultImpl) {
        this.defaultImpl = defaultImpl;
        return this;
    }

    @Override
    public StreamscapeResolverBuilder typeIdVisibility(boolean typeIdVisible) {
        this.typeIdVisible = typeIdVisible;
        return this;
    }

    @Override
    public Class<?> getDefaultImpl() {
        return this.defaultImpl;
    }

    public String getTypeProperty() {
        return TYPE_PROPERTY_NAME;
    }

    public boolean isTypeIdVisible() {
        return this.typeIdVisible;
    }

    protected TypeIdResolver idResolver(MapperConfig<?> config, JavaType baseType) {
        return new SemanticTypeIdResolver(this.aliasManager, this.classLoader, config, baseType);
    }
}

