/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.json.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.type.MapType;
import com.streamscape.omf.json.jackson.StreamscapeMapSerializer;
import java.io.IOException;
import java.util.Map;

public class StreamscapeMapSerializerResolver
extends JsonSerializer<Map>
implements ContextualSerializer {
    private MapType type;

    StreamscapeMapSerializerResolver(MapType type) {
        this.type = type;
    }

    @Override
    public void serialize(Map value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        TypeResolverBuilder<?> typeResolverBuilder = provider.getConfig().getDefaultTyper(this.type.getKeyType());
        TypeSerializer keyTypeSerializer = null;
        TypeSerializer elementTypeSerializer = null;
        if (typeResolverBuilder != null) {
            if (this.type.getKeyType().getRawClass() != String.class) {
                keyTypeSerializer = typeResolverBuilder.buildTypeSerializer(provider.getConfig(), this.type.getKeyType(), null);
            }
            elementTypeSerializer = typeResolverBuilder.buildTypeSerializer(provider.getConfig(), this.type.getContentType(), null);
        }
        JsonSerializer<Object> elementSerializer = null;
        try {
            if (this.type.getContentType() != null && this.type.getContentType().getRawClass() != Object.class && (this.type.getContentType().isCollectionLikeType() || this.type.getContentType().isMapLikeType() || this.type.getContentType().isFinal())) {
                elementSerializer = provider.findValueSerializer(this.type.getContentType(), property);
            }
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        JsonSerializer<Object> keySerializer = null;
        try {
            if (this.type.getKeyType() != null && this.type.getKeyType().getRawClass() != Object.class && (this.type.getKeyType().isCollectionLikeType() || this.type.getKeyType().isMapLikeType() || this.type.getKeyType().isFinal())) {
                keySerializer = provider.findValueSerializer(this.type.getKeyType(), property);
            }
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        return new StreamscapeMapSerializer(this.type, keyTypeSerializer, keySerializer, elementTypeSerializer, elementSerializer);
    }
}

