/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.json.jackson;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class StreamscapeMapSerializer
extends JsonSerializer<Map> {
    private MapType type;
    private TypeSerializer keyTypeSerializer;
    private JsonSerializer keySerializer;
    private TypeSerializer elementTypeSerializer;
    private JsonSerializer elementSerializer;
    private boolean sortKeys = false;
    private boolean skipNulls = false;

    public StreamscapeMapSerializer(MapType type, TypeSerializer keyTypeSerializer, JsonSerializer keySerializer, TypeSerializer elementTypeSerializer, JsonSerializer elementSerializer) {
        this.type = type;
        this.keyTypeSerializer = keyTypeSerializer;
        this.keySerializer = keySerializer;
        this.elementTypeSerializer = elementTypeSerializer;
        this.elementSerializer = elementSerializer;
    }

    @Override
    public void serializeWithType(Map value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        WritableTypeId typeId = typeSer.typeId(value, JsonToken.START_OBJECT);
        typeSer.writeTypePrefix(jgen, typeId);
        if (!value.isEmpty()) {
            this.serializeFieldsWithSort(value, jgen, provider);
        }
        typeSer.writeTypeSuffix(jgen, typeId);
    }

    @Override
    public void serialize(Map value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        jgen.writeStartObject();
        if (!value.isEmpty()) {
            this.serializeFieldsWithSort(value, jgen, provider);
        }
        jgen.writeEndObject();
    }

    private void serializeFieldsWithSort(Map<?, ?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (!(value instanceof LinkedHashMap) && (this.sortKeys || provider.isEnabled(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS))) {
            boolean containsNullKey = false;
            try {
                containsNullKey = value.containsKey(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!containsNullKey) {
                value = this.orderEntries(value);
            }
        }
        this.serializeFields(value, jgen, provider);
    }

    private void serializeFields(Map<?, ?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        boolean wrapInEntries;
        boolean bl = wrapInEntries = this.keyTypeSerializer != null || this.type.getKeyType().getRawClass() != String.class;
        if (wrapInEntries && this.type.getKeyType().getRawClass() == Object.class) {
            Iterator<Map.Entry<?, ?>> iterator = value.entrySet().iterator();
            if (iterator.hasNext()) {
                Object key = iterator.next().getKey();
                if (key != null && key.getClass() == String.class) {
                    wrapInEntries = false;
                }
            } else {
                wrapInEntries = false;
            }
        }
        if (wrapInEntries) {
            jgen.writeFieldName("entries");
            jgen.writeStartArray();
        }
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            JsonSerializer serializer;
            Object keyElem = entry.getKey();
            Object valueElem = entry.getValue();
            if (keyElem == null) {
                if (wrapInEntries) {
                    jgen.writeStartObject();
                    jgen.writeFieldName("key");
                    jgen.writeString((String)null);
                } else {
                    jgen.writeFieldName("null");
                }
            } else {
                if (this.skipNulls && valueElem == null) continue;
                if (wrapInEntries) {
                    serializer = this.keySerializer;
                    if (serializer == null) {
                        serializer = PropertySerializerMap.emptyMap().findAndAddSecondarySerializer(keyElem.getClass(), (SerializerProvider)provider, null).serializer;
                    }
                    jgen.writeStartObject();
                    jgen.writeFieldName("key");
                    this.serialize(serializer, keyElem, jgen, provider, this.keyTypeSerializer);
                } else {
                    jgen.writeFieldName(keyElem.toString());
                }
            }
            if (valueElem == null) {
                if (wrapInEntries) {
                    jgen.writeFieldName("value");
                    jgen.writeString((String)null);
                    jgen.writeEndObject();
                    continue;
                }
                provider.defaultSerializeNull(jgen);
                continue;
            }
            serializer = this.elementSerializer;
            if (serializer == null) {
                serializer = PropertySerializerMap.emptyMap().findAndAddSecondarySerializer(valueElem.getClass(), (SerializerProvider)provider, null).serializer;
            }
            if (wrapInEntries) {
                jgen.writeFieldName("value");
                this.serialize(serializer, valueElem, jgen, provider, this.elementTypeSerializer);
                jgen.writeEndObject();
                continue;
            }
            this.serialize(serializer, valueElem, jgen, provider, this.elementTypeSerializer);
        }
        if (wrapInEntries) {
            jgen.writeEndArray();
        }
    }

    private void serialize(JsonSerializer serializer, Object valueElem, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSerializer) throws IOException {
        if (typeSerializer != null) {
            serializer.serializeWithType(valueElem, jgen, provider, typeSerializer);
        } else {
            serializer.serialize(valueElem, jgen, provider);
        }
    }

    protected Map<?, ?> orderEntries(Map<?, ?> input) {
        if (input instanceof SortedMap) {
            return input;
        }
        return new TreeMap(input);
    }
}

