/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.json.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.deser.AbstractDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.type.MapType;
import com.streamscape.omf.json.jackson.StreamscapeMapDeserializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class StreamscapeMapDeserializerResolver
extends JsonDeserializer<Map>
implements ContextualDeserializer {
    private MapType type;
    private BeanDescription beanDesc;
    private KeyDeserializer keyDeserializer;
    private TypeDeserializer elementTypeDeserializer;
    private JsonDeserializer<?> elementDeserializer;
    public static final HashMap<String, Class<? extends Map>> mapFallbacks = new HashMap();

    public StreamscapeMapDeserializerResolver(MapType type, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) {
        this.type = type;
        this.beanDesc = beanDesc;
        this.elementTypeDeserializer = elementTypeDeserializer;
        this.elementDeserializer = elementDeserializer;
    }

    @Override
    public Map deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        return null;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext context, BeanProperty property) throws JsonMappingException {
        if (this.type.isInterface() || this.type.isAbstract()) {
            Class<Object> mapClass = this.type.getRawClass();
            Class<? extends Map> fallback = mapFallbacks.get(mapClass.getName());
            if (fallback != null) {
                mapClass = fallback;
                this.type = MapType.construct(mapClass, this.type.getBindings(), this.type.getSuperClass(), this.type.getInterfaces().toArray(new JavaType[0]), this.type.getKeyType(), this.type.getContentType());
            } else {
                if (this.type.getTypeHandler() == null) {
                    throw new IllegalArgumentException("Can not find a deserializer for non-concrete Map type " + String.valueOf(this.type));
                }
                if (this.beanDesc != null) {
                    return AbstractDeserializer.constructForNonPOJO(this.beanDesc);
                }
                return null;
            }
        }
        TypeDeserializer keyTypeDeserializer = null;
        JsonDeserializer<Object> keyDeserializer = null;
        TypeResolverBuilder<?> typeResolverBuilder = context.getConfig().getDefaultTyper(this.type.getKeyType());
        if (typeResolverBuilder != null) {
            if (this.type.getKeyType().getRawClass() != String.class) {
                keyTypeDeserializer = typeResolverBuilder.buildTypeDeserializer(context.getConfig(), this.type.getKeyType(), null);
            }
            if (this.elementTypeDeserializer == null) {
                this.elementTypeDeserializer = typeResolverBuilder.buildTypeDeserializer(context.getConfig(), this.type.getContentType(), null);
            }
            if (this.elementDeserializer == null) {
                this.elementDeserializer = context.findContextualValueDeserializer(this.type.getContentType(), property);
            }
            keyDeserializer = context.findContextualValueDeserializer(this.type.getKeyType(), property);
        }
        return new StreamscapeMapDeserializer(this.type, keyTypeDeserializer, keyDeserializer, this.elementTypeDeserializer, this.elementDeserializer, this.beanDesc == null);
    }

    static {
        mapFallbacks.put(Map.class.getName(), HashMap.class);
        mapFallbacks.put(ConcurrentMap.class.getName(), ConcurrentHashMap.class);
        mapFallbacks.put(SortedMap.class.getName(), TreeMap.class);
        mapFallbacks.put("java.util.NavigableMap", TreeMap.class);
        try {
            Class<ConcurrentSkipListMap> value;
            Class<ConcurrentNavigableMap> key = ConcurrentNavigableMap.class;
            Class<ConcurrentSkipListMap> mapValue = value = ConcurrentSkipListMap.class;
            mapFallbacks.put(key.getName(), mapValue);
        }
        catch (Throwable e) {
            System.err.println("Problems with (optional) types: " + String.valueOf(e));
        }
    }
}

