/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.json.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.MapType;
import com.streamscape.omf.json.jackson.AsSemanticTypeDeserializer;
import com.streamscape.omf.json.jackson.AsTopElementDeserializer;
import java.io.IOException;
import java.util.Map;

public class StreamscapeMapDeserializer
extends JsonDeserializer<Map> {
    private final MapType type;
    private final TypeDeserializer keyTypeDeserializer;
    private final JsonDeserializer<?> keyDeserializer;
    private final TypeDeserializer valueTypeDeserializer;
    private final JsonDeserializer<?> valueDeserializer;
    private final boolean isSemanticTypeAndSuppressGenericType;

    public StreamscapeMapDeserializer(MapType type, TypeDeserializer keyTypeDeserializer, JsonDeserializer<?> keyDeserializer, TypeDeserializer valueTypeDeserializer, JsonDeserializer<?> valueDeserializer, boolean isSemanticTypeAndSuppressGenericType) {
        this.type = type;
        this.keyTypeDeserializer = keyTypeDeserializer;
        this.keyDeserializer = keyDeserializer;
        this.valueTypeDeserializer = valueTypeDeserializer;
        this.valueDeserializer = valueDeserializer;
        this.isSemanticTypeAndSuppressGenericType = isSemanticTypeAndSuppressGenericType;
    }

    @Override
    public Class<?> handledType() {
        return this.type.getRawClass();
    }

    @Override
    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        if (this.isSemanticTypeAndSuppressGenericType) {
            if (typeDeserializer instanceof AsSemanticTypeDeserializer) {
                JsonToken t = jp.getCurrentToken();
                if (t == JsonToken.START_OBJECT) {
                    t = jp.nextToken();
                }
                if (t == JsonToken.FIELD_NAME && jp.getCurrentName().equals("@type")) {
                    t = jp.nextToken();
                    t = jp.nextToken();
                }
                return this.deserialize(jp, ctxt);
            }
            if (typeDeserializer instanceof AsTopElementDeserializer) {
                JsonToken t = jp.getCurrentToken();
                if (t == JsonToken.START_OBJECT) {
                    t = jp.nextToken();
                }
                if (t == JsonToken.FIELD_NAME && (t = jp.nextToken()) == JsonToken.START_OBJECT) {
                    t = jp.nextToken();
                }
                return this.deserialize(jp, ctxt);
            }
        }
        return typeDeserializer.deserializeTypedFromAny(jp, ctxt);
    }

    @Override
    public Map deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        Map<Object, Object> result = this.instantiate(ctxt);
        this.readAndBind(jp, ctxt, result);
        return result;
    }

    protected final void readAndBind(JsonParser jp, DeserializationContext ctxt, Map<Object, Object> result) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            t = jp.nextToken();
        } else if (t == JsonToken.VALUE_EMBEDDED_OBJECT) {
            t = jp.nextToken();
        }
        if (t == JsonToken.END_OBJECT) {
            return;
        }
        if (t == JsonToken.FIELD_NAME) {
            String name = jp.getCurrentName();
            if ("entries".equals(name)) {
                t = jp.nextToken();
                if (t == JsonToken.START_ARRAY) {
                    this.readAndBindEntries(jp, ctxt, result);
                    jp.nextToken();
                } else {
                    this.readAndBindNoEntries(jp, ctxt, result, name);
                }
            } else {
                this.readAndBindNoEntries(jp, ctxt, result, null);
            }
        } else {
            throw ctxt.wrongTokenException(jp, JsonToken.FIELD_NAME, "");
        }
        if (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            throw ctxt.wrongTokenException(jp, JsonToken.END_OBJECT, "");
        }
    }

    protected final void readAndBindEntries(JsonParser jp, DeserializationContext ctxt, Map<Object, Object> result) throws IOException {
        block6: {
            JsonToken t = jp.nextToken();
            if (t == JsonToken.END_ARRAY) {
                return;
            }
            if (t != JsonToken.START_OBJECT) {
                throw ctxt.wrongTokenException(jp, JsonToken.START_OBJECT, "");
            }
            do {
                if ((t = jp.nextToken()) != JsonToken.FIELD_NAME || !jp.getCurrentName().equals("key")) {
                    throw ctxt.wrongTokenException(jp, JsonToken.FIELD_NAME, "key");
                }
                t = jp.nextToken();
                Object key = t == JsonToken.VALUE_NULL ? this.keyDeserializer.getNullValue() : (this.keyTypeDeserializer == null ? this.keyDeserializer.deserialize(jp, ctxt) : this.keyDeserializer.deserializeWithType(jp, ctxt, this.keyTypeDeserializer));
                t = jp.nextToken();
                if (t != JsonToken.FIELD_NAME || !jp.getCurrentName().equals("value")) {
                    throw ctxt.wrongTokenException(jp, JsonToken.FIELD_NAME, "valye");
                }
                t = jp.nextToken();
                Object value = t == JsonToken.VALUE_NULL ? this.valueDeserializer.getNullValue() : (this.valueTypeDeserializer == null ? this.valueDeserializer.deserialize(jp, ctxt) : this.valueDeserializer.deserializeWithType(jp, ctxt, this.valueTypeDeserializer));
                result.put(key, value);
                t = jp.nextToken();
                if (t != JsonToken.END_OBJECT) {
                    throw ctxt.wrongTokenException(jp, JsonToken.END_OBJECT, "");
                }
                t = jp.nextToken();
                if (t == JsonToken.END_ARRAY) break block6;
            } while (t == JsonToken.START_OBJECT);
            throw ctxt.wrongTokenException(jp, JsonToken.START_OBJECT, "");
        }
    }

    protected final void readAndBindNoEntries(JsonParser jp, DeserializationContext ctxt, Map<Object, Object> result, String firstKeyName) throws IOException {
        JsonToken t;
        do {
            String key = null;
            t = jp.getCurrentToken();
            if (firstKeyName != null) {
                key = firstKeyName;
                firstKeyName = null;
            } else {
                if (t == JsonToken.END_OBJECT) {
                    return;
                }
                key = jp.getCurrentName();
                t = jp.nextToken();
            }
            Object value = t == JsonToken.VALUE_NULL ? this.valueDeserializer.getNullValue() : (this.valueTypeDeserializer == null ? this.valueDeserializer.deserialize(jp, ctxt) : this.valueDeserializer.deserializeWithType(jp, ctxt, this.valueTypeDeserializer));
            result.put(key, value);
        } while ((t = jp.nextToken()) == JsonToken.FIELD_NAME || t == JsonToken.END_OBJECT);
        throw ctxt.wrongTokenException(jp, JsonToken.FIELD_NAME, "");
    }

    private Map<Object, Object> instantiate(DeserializationContext ctxt) throws IOException {
        try {
            return (Map)this.type.getRawClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException exception) {
            throw ctxt.instantiationException(this.type.getRawClass(), exception);
        }
    }
}

