/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.json.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.CollectionSerializer;
import java.io.IOException;
import java.util.Map;

public class StreamscapeCollectionSerializerResolver
extends JsonSerializer<Map>
implements ContextualSerializer {
    private JavaType elementType;

    public StreamscapeCollectionSerializerResolver(JavaType elementType) {
        this.elementType = elementType;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) {
        JsonSerializer<Object> elementSerializer = null;
        if (this.elementType.isCollectionLikeType() || this.elementType.isMapLikeType() || this.elementType.isFinal()) {
            try {
                elementSerializer = provider.findValueSerializer(this.elementType, property);
            }
            catch (JsonMappingException e) {
                e.printStackTrace();
            }
        }
        TypeSerializer elementTypeSerializer = provider.getConfig().getDefaultTyper(this.elementType).buildTypeSerializer(provider.getConfig(), this.elementType, null);
        return new CollectionSerializer(this.elementType, false, elementTypeSerializer, elementSerializer){

            @Override
            public CollectionSerializer withResolved(BeanProperty property, TypeSerializer vts, JsonSerializer<?> elementSerializer, Boolean unwrapSingle) {
                if (!(elementSerializer == null || this._elementType.isCollectionLikeType() || this._elementType.isMapLikeType() || this._elementType.isFinal())) {
                    elementSerializer = null;
                }
                return new CollectionSerializer(StreamscapeCollectionSerializerResolver.this.elementType, false, vts, elementSerializer);
            }
        };
    }

    @Override
    public void serialize(Map value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
    }
}

