/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.json.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.CollectionDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.util.ArrayList;

class StreamscapeCollectionDeserializerResolver
extends JsonDeserializer
implements ContextualDeserializer {
    private final JavaType collectionType;

    public StreamscapeCollectionDeserializerResolver(JavaType collectionType) {
        this.collectionType = collectionType;
    }

    public CollectionDeserializer createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        TypeDeserializer valueTypeDeserializer = ctxt.getConfig().findTypeDeserializer(this.collectionType.getContentType());
        return new CollectionDeserializer(this.collectionType, null, valueTypeDeserializer, new ValueInstantiator(this){

            @Override
            public String getValueTypeDesc() {
                return ArrayList.class.getName();
            }

            @Override
            public boolean canInstantiate() {
                return true;
            }

            @Override
            public boolean canCreateUsingDefault() {
                return true;
            }

            @Override
            public Object createUsingDefault(DeserializationContext ctxt) throws IOException {
                return new ArrayList();
            }
        }).createContextual(ctxt, property);
    }

    public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        return null;
    }
}

