/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.json.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.lang.reflect.Field;

public class StackTraceElementDeserializer
extends StdScalarDeserializer<StackTraceElement> {
    private static final long serialVersionUID = 1L;
    private static final Field FORMAT;

    public StackTraceElementDeserializer() {
        super(StackTraceElement.class);
    }

    @Override
    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromObject(jp, ctxt);
    }

    @Override
    public StackTraceElement deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            t = jp.nextToken();
        }
        if (t == JsonToken.FIELD_NAME) {
            String classLoaderName = null;
            String moduleName = null;
            String moduleVersion = null;
            String declaringClass = "";
            String methodName = "";
            String fileName = null;
            int lineNumber = -1;
            byte format = 0;
            while (t != JsonToken.END_OBJECT) {
                String propName = jp.getCurrentName();
                jp.nextToken();
                if ("classLoaderName".equals(propName)) {
                    if (jp.getCurrentToken() != JsonToken.VALUE_NULL) {
                        classLoaderName = jp.getValueAsString();
                    }
                } else if ("moduleName".equals(propName)) {
                    if (jp.getCurrentToken() != JsonToken.VALUE_NULL) {
                        moduleName = jp.getValueAsString();
                    }
                } else if ("moduleVersion".equals(propName)) {
                    if (jp.getCurrentToken() != JsonToken.VALUE_NULL) {
                        moduleVersion = jp.getValueAsString();
                    }
                } else if ("declaringClass".equals(propName)) {
                    if (jp.getCurrentToken() != JsonToken.VALUE_NULL) {
                        declaringClass = jp.getValueAsString();
                    }
                } else if ("methodName".equals(propName)) {
                    if (jp.getCurrentToken() != JsonToken.VALUE_NULL) {
                        methodName = jp.getValueAsString();
                    }
                } else if ("fileName".equals(propName)) {
                    if (jp.getCurrentToken() != JsonToken.VALUE_NULL) {
                        fileName = jp.getValueAsString();
                    }
                } else if ("lineNumber".equals(propName)) {
                    if (jp.getCurrentToken() != JsonToken.VALUE_NULL) {
                        lineNumber = jp.getIntValue();
                    }
                } else if ("format".equals(propName)) {
                    if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
                        boolean closeBracket = false;
                        jp.nextToken();
                        jp.nextToken();
                        if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
                            closeBracket = true;
                        }
                        jp.nextToken();
                        jp.nextToken();
                        if (jp.getCurrentToken() != JsonToken.VALUE_NULL) {
                            format = jp.getByteValue();
                        }
                        jp.nextToken();
                        if (closeBracket) {
                            jp.nextToken();
                        }
                    } else if (jp.getCurrentToken() != JsonToken.VALUE_NULL) {
                        format = jp.getByteValue();
                    }
                } else {
                    this.handleUnknownProperty(jp, ctxt, this._valueClass, propName);
                }
                t = jp.nextToken();
            }
            StackTraceElement result = new StackTraceElement(classLoaderName, moduleName, moduleVersion, declaringClass, methodName, fileName, lineNumber);
            if (format != 0) {
                try {
                    FORMAT.set(result, format);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return result;
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            StackTraceElement value = this.deserialize(jp, ctxt);
            if (jp.nextToken() != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'java.lang.StackTraceElement' value but there was more than a single value in the array.");
            }
            return value;
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    static {
        try {
            FORMAT = StackTraceElement.class.getDeclaredField("format");
            FORMAT.setAccessible(true);
        }
        catch (Exception exception) {
            throw new RuntimeException("Initialization of StackTraceElementDeserializer failed.", exception);
        }
    }
}

