/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.json.jackson;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.streamscape.omf.json.jackson.JacksonUtils;
import com.streamscape.omf.mf.admin.ObjectMediationAliasManager;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.mf.operation.edl.annotations.Alias;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import java.util.concurrent.TimeUnit;

class SemanticTypeIdResolver
implements TypeIdResolver {
    private final ObjectMediationAliasManager aliasManager;
    private final ClassLoader classLoader;
    private final com.fasterxml.jackson.databind.type.TypeFactory typeFactory;
    private JavaType baseType;

    public SemanticTypeIdResolver(ObjectMediationAliasManager aliasManager, ClassLoader classLoader, MapperConfig<?> config, JavaType baseType) {
        this.aliasManager = aliasManager;
        this.classLoader = classLoader;
        this.typeFactory = config.getTypeFactory();
        this.baseType = baseType;
    }

    @Override
    public void init(JavaType baseType) {
        this.baseType = baseType;
    }

    public JavaType getBaseType() {
        return this.baseType;
    }

    @Override
    public String idFromValue(Object value) {
        if (value == null) {
            return null;
        }
        return this.idFromValueAndType(value, this.typeFactory.constructType(value.getClass()).getRawClass());
    }

    @Override
    public String idFromValueAndType(Object value, Class<?> suggestedType) {
        Alias alias = suggestedType.getAnnotation(Alias.class);
        if (alias != null && alias.alias() != null && alias.alias().length() > 0) {
            return alias.alias();
        }
        SemanticType type = this.aliasManager.lookupSemanticClass(TypeFactory.wrapPrimitive(suggestedType));
        if (type != null) {
            return type.getTypeName();
        }
        return suggestedType.getName();
    }

    @Override
    public String idFromBaseType() {
        return this.idFromValueAndType(null, this.baseType.getRawClass());
    }

    public JavaType typeFromId(String id) {
        return this.typeFromId(null, id);
    }

    @Override
    public JavaType typeFromId(DatabindContext context, String id) {
        SemanticType semanticType = this.aliasManager.lookupSemanticType(id);
        String className = id;
        if (semanticType != null) {
            className = semanticType.getClassName();
        }
        if (className != null) {
            JavaType javaType;
            block10: {
                com.fasterxml.jackson.databind.type.TypeFactory typeFactory = context != null ? context.getTypeFactory() : this.typeFactory;
                javaType = null;
                if (this.classLoader != null) {
                    try {
                        Class<Object> clazz = this.classLoader.loadClass(className);
                        if (clazz.isAnonymousClass() && clazz.getEnclosingClass() == TimeUnit.class) {
                            clazz = TimeUnit.class;
                        }
                        javaType = typeFactory.constructType(clazz);
                    }
                    catch (ClassNotFoundException clazz) {
                        // empty catch block
                    }
                }
                if (javaType == null) {
                    try {
                        javaType = typeFactory.constructFromCanonical(className);
                    }
                    catch (RuntimeException exception) {
                        if (semanticType == null && this.baseType != null && this.baseType.getRawClass() != null && this.baseType.getRawClass().getSimpleName().endsWith(id)) break block10;
                        throw exception;
                    }
                }
            }
            if (javaType != null && JacksonUtils.isPrimitive(javaType.getRawClass()) && javaType.getRawClass() != this.baseType.getRawClass() && TypeFactory.unwrapBoxer(javaType.getRawClass()) == TypeFactory.unwrapBoxer(this.baseType.getRawClass())) {
                javaType = this.baseType;
            }
            return javaType;
        }
        return null;
    }

    @Override
    public String getDescForKnownTypeIds() {
        return "error for " + String.valueOf(this.baseType);
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

