/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.json.jackson;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.util.VersionUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MapJsonParser
extends JsonParser {
    private ObjectCodec codec;
    private Map map;
    protected MapJsonReadContext context;
    private JsonToken token = null;
    private JsonToken lastClearedToken = null;

    public MapJsonParser(Map map) {
        this.map = map;
        this.context = MapJsonReadContext.createRootContext();
    }

    @Override
    public ObjectCodec getCodec() {
        return this.codec;
    }

    @Override
    public void setCodec(ObjectCodec codec) {
        this.codec = codec;
    }

    @Override
    public Version version() {
        return VersionUtil.versionFor(this.getClass());
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public JsonToken nextToken() throws IOException, JsonParseException {
        if (this.token == JsonToken.NOT_AVAILABLE) {
            return this.token;
        }
        if (this.context.inRoot()) {
            if (this.map == null) {
                this.token = JsonToken.NOT_AVAILABLE;
            } else {
                this.token = JsonToken.START_OBJECT;
                this.context = this.context.createChildObjectContext();
                this.context.entryIterator = this.map.entrySet().iterator();
                this.context.currentEntry = null;
            }
        } else if (this.context.inObject()) {
            if (this.context.currentEntry == null) {
                if (this.context.entryIterator.hasNext()) {
                    this.token = JsonToken.FIELD_NAME;
                    this.context.currentEntry = this.context.entryIterator.next();
                    this.context.currentName = this.context.currentEntry.getKey();
                } else {
                    this.token = JsonToken.END_OBJECT;
                    this.context = this.context.parent;
                    this.context.currentEntry = null;
                    this.context.currentValue = null;
                    this.context.currentName = null;
                }
            } else {
                this.context.currentValue = this.context.currentEntry.getValue();
                this.context.currentEntry = null;
                this.token = this.determineTokenType(this.context.currentValue);
                if (this.token == JsonToken.START_ARRAY) {
                    this.context = this.context.createChildArrayContext();
                    if (this.context.parent.currentValue instanceof List) {
                        this.context.arrayIterator = ((List)this.context.parent.currentValue).iterator();
                    } else if (this.context.parent.currentValue instanceof Object[]) {
                        this.context.arrayIterator = Arrays.asList((Object[])this.context.parent.currentValue).iterator();
                    }
                } else if (this.token == JsonToken.START_OBJECT) {
                    this.context = this.context.createChildObjectContext();
                    this.context.entryIterator = ((Map)this.context.parent.currentValue).entrySet().iterator();
                }
            }
        } else if (this.context.arrayIterator.hasNext()) {
            this.context.currentValue = this.context.arrayIterator.next();
            this.token = this.determineTokenType(this.context.currentValue);
            if (this.token == JsonToken.START_ARRAY) {
                this.context = this.context.createChildArrayContext();
                if (this.context.parent.currentValue instanceof List) {
                    this.context.arrayIterator = ((List)this.context.parent.currentValue).iterator();
                } else if (this.context.parent.currentValue instanceof Object[]) {
                    this.context.arrayIterator = Arrays.asList((Object[])this.context.parent.currentValue).iterator();
                }
            } else if (this.token == JsonToken.START_OBJECT) {
                this.context = this.context.createChildObjectContext();
                this.context.entryIterator = ((Map)this.context.parent.currentValue).entrySet().iterator();
            }
        } else {
            this.token = JsonToken.END_ARRAY;
            this.context = this.context.parent;
            this.context.currentValue = null;
            this.context.currentName = null;
        }
        return this.token;
    }

    private JsonToken determineTokenType(Object currentValue) {
        if (currentValue == null) {
            return JsonToken.VALUE_NULL;
        }
        if (currentValue instanceof String) {
            return JsonToken.VALUE_STRING;
        }
        if (currentValue instanceof Number) {
            if (currentValue instanceof Byte || currentValue instanceof Short || currentValue instanceof Integer || currentValue instanceof Long || currentValue instanceof BigInteger) {
                return JsonToken.VALUE_NUMBER_INT;
            }
            return JsonToken.VALUE_NUMBER_FLOAT;
        }
        if (currentValue == Boolean.TRUE) {
            return JsonToken.VALUE_TRUE;
        }
        if (currentValue == Boolean.FALSE) {
            return JsonToken.VALUE_FALSE;
        }
        if (currentValue instanceof Map) {
            return JsonToken.START_OBJECT;
        }
        if (currentValue instanceof List || currentValue.getClass().isArray() && currentValue.getClass() != byte[].class && currentValue.getClass() != Byte[].class) {
            return JsonToken.START_ARRAY;
        }
        return JsonToken.VALUE_EMBEDDED_OBJECT;
    }

    @Override
    public JsonToken nextValue() throws IOException, JsonParseException {
        block1: {
            do {
                this.nextToken();
                if (this.token == JsonToken.NOT_AVAILABLE || this.token == null) break block1;
            } while (this.token != JsonToken.FIELD_NAME);
            return this.nextToken();
        }
        return null;
    }

    @Override
    public JsonParser skipChildren() throws IOException, JsonParseException {
        if (this.token == JsonToken.START_OBJECT) {
            this.token = JsonToken.END_OBJECT;
            this.context = this.context.parent;
            this.context.currentEntry = null;
            this.context.currentValue = null;
            this.context.currentName = null;
        } else if (this.token == JsonToken.START_ARRAY) {
            this.token = JsonToken.END_ARRAY;
            this.context = this.context.parent;
            this.context.currentValue = null;
            this.context.currentName = null;
        }
        return this;
    }

    @Override
    public JsonToken getCurrentToken() {
        return this.token;
    }

    @Override
    public int getCurrentTokenId() {
        return this.token != null ? this.token.id() : 0;
    }

    @Override
    public boolean hasCurrentToken() {
        return this.token != null;
    }

    @Override
    public boolean hasTokenId(int id) {
        return this.currentTokenId() == id;
    }

    @Override
    public boolean hasToken(JsonToken jsonToken) {
        return this.currentToken() == jsonToken;
    }

    @Override
    public String getCurrentName() throws IOException {
        if (this.token == JsonToken.START_OBJECT || this.token == JsonToken.START_ARRAY) {
            return this.context.parent.currentName;
        }
        return this.context.currentName;
    }

    @Override
    public JsonStreamContext getParsingContext() {
        return this.context;
    }

    @Override
    public JsonLocation getTokenLocation() {
        return JsonLocation.NA;
    }

    @Override
    public JsonLocation getCurrentLocation() {
        return JsonLocation.NA;
    }

    @Override
    public void clearCurrentToken() {
        this.lastClearedToken = this.token;
        this.token = null;
    }

    @Override
    public JsonToken getLastClearedToken() {
        return this.lastClearedToken;
    }

    @Override
    public void overrideCurrentName(String name) {
    }

    @Override
    public String getText() throws IOException {
        if (this.token == null) {
            return null;
        }
        switch (this.token) {
            case NOT_AVAILABLE: 
            case START_OBJECT: 
            case END_OBJECT: 
            case START_ARRAY: 
            case END_ARRAY: 
            case VALUE_TRUE: 
            case VALUE_FALSE: 
            case VALUE_NULL: {
                return this.token.asString();
            }
            case FIELD_NAME: {
                return this.context.currentEntry.getKey();
            }
            case VALUE_STRING: 
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: 
            case VALUE_EMBEDDED_OBJECT: {
                return String.valueOf(this.context.currentValue);
            }
        }
        return null;
    }

    @Override
    public char[] getTextCharacters() throws IOException {
        String text = this.getText();
        if (text != null) {
            return text.toCharArray();
        }
        return null;
    }

    @Override
    public int getTextLength() throws IOException {
        String text = this.getText();
        if (text != null) {
            return text.length();
        }
        return 0;
    }

    @Override
    public int getTextOffset() throws IOException {
        return 0;
    }

    @Override
    public boolean hasTextCharacters() {
        return false;
    }

    @Override
    public Number getNumberValue() throws IOException {
        if (this.token == null) {
            throw new IOException("Token is null.");
        }
        switch (this.token) {
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                if (!(this.context.currentValue instanceof Number)) break;
                return (Number)this.context.currentValue;
            }
        }
        throw new IOException("Cannot convert token '" + String.valueOf((Object)this.token) + "' to number");
    }

    @Override
    public JsonParser.NumberType getNumberType() throws IOException {
        if (this.token == null) {
            throw new IOException("Token is null.");
        }
        switch (this.token) {
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                if (!(this.context.currentValue instanceof Number)) break;
                if (this.context.currentValue instanceof Integer) {
                    return JsonParser.NumberType.INT;
                }
                if (this.context.currentValue instanceof Long) {
                    return JsonParser.NumberType.LONG;
                }
                if (this.context.currentValue instanceof Float) {
                    return JsonParser.NumberType.FLOAT;
                }
                if (this.context.currentValue instanceof Double) {
                    return JsonParser.NumberType.DOUBLE;
                }
                if (this.context.currentValue instanceof BigDecimal) {
                    return JsonParser.NumberType.BIG_DECIMAL;
                }
                if (this.context.currentValue instanceof BigInteger) {
                    return JsonParser.NumberType.BIG_INTEGER;
                }
                return JsonParser.NumberType.INT;
            }
        }
        throw new IOException("Cannot convert token '" + String.valueOf((Object)this.token) + "' to number.");
    }

    @Override
    public int getIntValue() throws IOException {
        if (this.token == null) {
            throw new IOException("Token is null.");
        }
        switch (this.token) {
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                if (!(this.context.currentValue instanceof Number)) break;
                return ((Number)this.context.currentValue).intValue();
            }
        }
        throw new IOException("Cannot convert token '" + String.valueOf((Object)this.token) + "' to int.");
    }

    @Override
    public long getLongValue() throws IOException {
        if (this.token == null) {
            throw new IOException("Token is null.");
        }
        switch (this.token) {
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                if (!(this.context.currentValue instanceof Number)) break;
                return ((Number)this.context.currentValue).longValue();
            }
        }
        throw new IOException("Cannot convert token '" + String.valueOf((Object)this.token) + "' to long.");
    }

    @Override
    public long getValueAsLong(long def) throws IOException {
        return this.getLongValue();
    }

    @Override
    public BigInteger getBigIntegerValue() throws IOException {
        if (this.token == null) {
            throw new IOException("Token is null.");
        }
        switch (this.token) {
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                if (this.context.currentValue instanceof BigInteger) {
                    return (BigInteger)this.context.currentValue;
                }
                if (!(this.context.currentValue instanceof Number)) break;
                return BigInteger.valueOf(((Number)this.context.currentValue).longValue());
            }
        }
        throw new IOException("Cannot convert token '" + String.valueOf((Object)this.token) + "' to big integer.");
    }

    @Override
    public float getFloatValue() throws IOException {
        if (this.token == null) {
            throw new IOException("Token is null.");
        }
        switch (this.token) {
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                if (!(this.context.currentValue instanceof Number)) break;
                return ((Number)this.context.currentValue).floatValue();
            }
        }
        throw new IOException("Cannot convert token '" + String.valueOf((Object)this.token) + "' to float.");
    }

    @Override
    public double getDoubleValue() throws IOException {
        if (this.token == null) {
            throw new IOException("Token is null.");
        }
        switch (this.token) {
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                if (!(this.context.currentValue instanceof Number)) break;
                return ((Number)this.context.currentValue).doubleValue();
            }
        }
        throw new IOException("Cannot convert token '" + String.valueOf((Object)this.token) + "' to double.");
    }

    @Override
    public BigDecimal getDecimalValue() throws IOException {
        if (this.token == null) {
            throw new IOException("Token is null.");
        }
        switch (this.token) {
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                if (this.context.currentValue instanceof BigDecimal) {
                    return (BigDecimal)this.context.currentValue;
                }
                if (!(this.context.currentValue instanceof BigDecimal)) break;
                return BigDecimal.valueOf(((Number)this.context.currentValue).doubleValue());
            }
        }
        throw new IOException("Cannot convert token '" + String.valueOf((Object)this.token) + "' to decimal value.");
    }

    @Override
    public Object getEmbeddedObject() throws IOException {
        if (this.token == null) {
            throw new IOException("Token is null.");
        }
        switch (this.token) {
            case VALUE_EMBEDDED_OBJECT: {
                return this.convertEmbeddedObjectValue(this.context.currentValue);
            }
        }
        throw new IOException("Cannot convert token '" + String.valueOf((Object)this.token) + "' to embedded object.");
    }

    protected Object convertEmbeddedObjectValue(Object currentValue) {
        return currentValue;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant bv) throws IOException {
        return new byte[0];
    }

    @Override
    public String getValueAsString(String def) throws IOException {
        return this.getText();
    }

    public static class MapJsonReadContext
    extends JsonStreamContext {
        protected final MapJsonReadContext parent;
        protected MapJsonReadContext child = null;
        protected String currentName;
        private Iterator<Map.Entry<String, Object>> entryIterator;
        private Map.Entry<String, Object> currentEntry;
        private Iterator<Object> arrayIterator;
        private Object currentValue;

        public MapJsonReadContext(MapJsonReadContext parent, int type) {
            this.parent = parent;
            this._type = type;
            this._index = -1;
        }

        protected void reset(int type) {
            this._type = type;
            this._index = -1;
            this.currentName = null;
            this.entryIterator = null;
            this.currentEntry = null;
            this.arrayIterator = null;
            this.currentValue = null;
        }

        public static MapJsonReadContext createRootContext() {
            return new MapJsonReadContext(null, 0);
        }

        public MapJsonReadContext createChildArrayContext() {
            MapJsonReadContext ctxt = this.child;
            if (ctxt == null) {
                this.child = ctxt = new MapJsonReadContext(this, 1);
            } else {
                ctxt.reset(1);
            }
            return ctxt;
        }

        public MapJsonReadContext createChildObjectContext() {
            MapJsonReadContext ctxt = this.child;
            if (ctxt == null) {
                this.child = ctxt = new MapJsonReadContext(this, 2);
            } else {
                ctxt.reset(2);
            }
            return ctxt;
        }

        @Override
        public String getCurrentName() {
            return this.currentName;
        }

        @Override
        public MapJsonReadContext getParent() {
            return this.parent;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(64);
            switch (this._type) {
                case 0: {
                    sb.append("/");
                    break;
                }
                case 1: {
                    sb.append('[');
                    sb.append(this.getCurrentIndex());
                    sb.append(']');
                    break;
                }
                case 2: {
                    sb.append('{');
                    if (this.currentName != null) {
                        sb.append('\"');
                        CharTypes.appendQuoted(sb, this.currentName);
                        sb.append('\"');
                    } else {
                        sb.append('?');
                    }
                    sb.append('}');
                }
            }
            return sb.toString();
        }
    }
}

