/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.json.jackson;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.util.VersionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class MapJsonGenerator
extends JsonGenerator {
    private ObjectCodec codec;
    private DocumentJsonWriteContext context;
    private Supplier<Map> mapSupplier;
    private Supplier<List> arraySupplier;

    public MapJsonGenerator() {
        this(() -> new HashMap());
    }

    public MapJsonGenerator(Supplier<Map> mapSupplier) {
        this(mapSupplier, () -> new ArrayList());
    }

    public MapJsonGenerator(Supplier<Map> mapSupplier, Supplier<List> arraySupplier) {
        this.mapSupplier = mapSupplier;
        this.arraySupplier = arraySupplier;
        this.context = new DocumentJsonWriteContext();
    }

    @Override
    public JsonGenerator setCodec(ObjectCodec codec) {
        this.codec = codec;
        return this;
    }

    @Override
    public ObjectCodec getCodec() {
        return this.codec;
    }

    @Override
    public Version version() {
        return VersionUtil.versionFor(this.getClass());
    }

    @Override
    public JsonGenerator enable(JsonGenerator.Feature f) {
        return this;
    }

    @Override
    public JsonGenerator disable(JsonGenerator.Feature f) {
        return this;
    }

    @Override
    public boolean isEnabled(JsonGenerator.Feature f) {
        return false;
    }

    @Override
    public int getFeatureMask() {
        return 0;
    }

    @Override
    public JsonGenerator setFeatureMask(int values) {
        return this;
    }

    @Override
    public JsonGenerator useDefaultPrettyPrinter() {
        return this;
    }

    @Override
    public void writeStartArray() throws IOException {
        if (this.context.inRoot()) {
            if (this.context.document != null) {
                throw new IOException("Root object already created.");
            }
            this.context = this.context.createChildArrayContext();
            this.context.parent.array = this.context.array;
            this.context.parent.incIndex();
            return;
        }
        if (this.context.inObject()) {
            if (this.context.currentName == null) {
                throw new IOException("Array cannot be started without field name.");
            }
            this.context = this.context.createChildArrayContext();
            this.context.parent.document.put(this.context.parent.currentName, this.context.array);
            this.context.parent.incIndex();
        } else if (this.context.inArray()) {
            this.context = this.context.createChildArrayContext();
            this.context.parent.array.add(this.context.array);
            this.context.parent.incIndex();
        } else {
            throw new IOException("Unknown context type " + this.context.getTypeDesc() + "'.");
        }
    }

    @Override
    public void writeEndArray() throws IOException {
        if (!this.context.inArray()) {
            throw new IOException("Array cannot be closed in '" + this.context.getTypeDesc() + "'.");
        }
        this.context = this.context.parent;
        this.context.currentName = null;
    }

    @Override
    public void writeStartObject() throws IOException {
        if (this.context.inRoot()) {
            if (this.context.document != null) {
                throw new IOException("Root object already created.");
            }
            this.context = this.context.createChildObjectContext();
            this.context.parent.document = this.context.document;
            this.context.parent.incIndex();
            return;
        }
        if (this.context.inArray()) {
            this.context = this.context.createChildObjectContext();
            this.context.parent.array.add(this.context.document);
            this.context.parent.incIndex();
        } else {
            if (this.context.currentName == null) {
                throw new IOException("Object should start after field name.");
            }
            this.context = this.context.createChildObjectContext();
            this.context.parent.document.put(this.context.parent.currentName, this.context.document);
            this.context.parent.incIndex();
        }
    }

    @Override
    public void writeEndObject() throws IOException {
        if (!this.context.inObject()) {
            throw new IOException("Object not yet started.");
        }
        if (this.context.currentName != null) {
            throw new IOException("Object cannot be ended after field name.");
        }
        this.context = this.context.parent;
        this.context.currentName = null;
    }

    @Override
    public void writeFieldName(String name) throws IOException {
        if (!this.context.inObject()) {
            throw new IOException("Cannot write name outside object.");
        }
        this.context.currentName = name;
    }

    @Override
    public void writeFieldName(SerializableString name) throws IOException {
        this.writeFieldName(name.getValue());
    }

    public <T> void writeValue(T value) throws IOException {
        if (this.context.inObject()) {
            if (this.context.currentName == null) {
                throw new IOException("Cannot write value without field name.");
            }
            this.context.document.put(this.context.currentName, value);
            this.context.currentName = null;
            this.context.incIndex();
        } else if (this.context.inArray()) {
            this.context.array.add(value);
            this.context.incIndex();
        } else {
            throw new IOException("Cannot write value to root.");
        }
    }

    @Override
    public void writeString(String text) throws IOException {
        this.writeValue(text);
    }

    @Override
    public void writeString(char[] text, int offset, int len) throws IOException {
        this.writeString(new String(text, offset, len));
    }

    @Override
    public void writeString(SerializableString text) throws IOException {
        this.writeString(text.getValue());
    }

    @Override
    public void writeRawUTF8String(byte[] text, int offset, int length) throws IOException {
        this.writeString(new String(text, offset, length));
    }

    @Override
    public void writeUTF8String(byte[] text, int offset, int length) throws IOException {
        this.writeString(new String(text, offset, length));
    }

    @Override
    public void writeRaw(String text) throws IOException {
        this.writeString(text);
    }

    @Override
    public void writeRaw(String text, int offset, int len) throws IOException {
        this.writeString(text.substring(offset, offset + len));
    }

    @Override
    public void writeRaw(char[] text, int offset, int len) throws IOException {
        this.writeString(new String(text, offset, len));
    }

    @Override
    public void writeRaw(char c) throws IOException {
        this.writeString(Character.toString(c));
    }

    @Override
    public void writeRawValue(String text) throws IOException {
        this.writeString(text);
    }

    @Override
    public void writeRawValue(String text, int offset, int len) throws IOException {
        this.writeString(text.substring(offset, offset + len));
    }

    @Override
    public void writeRawValue(char[] text, int offset, int len) throws IOException {
        this.writeString(new String(text, offset, len));
    }

    @Override
    public void writeBinary(Base64Variant bv, byte[] data, int offset, int len) throws IOException {
        if (offset == 0 && len == data.length) {
            this.writeValue(data);
        } else {
            this.writeValue(Arrays.copyOfRange(data, offset, offset + len));
        }
    }

    @Override
    public int writeBinary(Base64Variant bv, InputStream data, int dataLength) throws IOException {
        byte[] bytes = new byte[dataLength];
        int len = data.read(bytes);
        this.writeBinary(bv, bytes, 0, len);
        return len;
    }

    @Override
    public void writeNumber(int v) throws IOException {
        this.writeValue(v);
    }

    @Override
    public void writeNumber(long v) throws IOException {
        this.writeValue(v);
    }

    @Override
    public void writeNumber(BigInteger v) throws IOException {
        this.writeValue(v);
    }

    @Override
    public void writeNumber(double d) throws IOException {
        this.writeValue(d);
    }

    @Override
    public void writeNumber(float f) throws IOException {
        this.writeValue(Float.valueOf(f));
    }

    @Override
    public void writeNumber(BigDecimal dec) throws IOException {
        this.writeValue(dec);
    }

    @Override
    public void writeNumber(String encodedValue) throws IOException {
        this.writeValue(encodedValue);
    }

    @Override
    public void writeBoolean(boolean state) throws IOException {
        this.writeValue(state);
    }

    @Override
    public void writeNull() throws IOException {
        this.writeValue(null);
    }

    @Override
    public void writeObject(Object pojo) throws IOException {
        this.writeValue(pojo);
    }

    @Override
    public void writeTree(TreeNode rootNode) throws IOException {
        this.writeValue(rootNode);
    }

    @Override
    public JsonStreamContext getOutputContext() {
        return this.context;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void close() throws IOException {
    }

    public Object getDocument() throws IOException {
        if (!this.context.inRoot()) {
            throw new IOException("Context is not root.");
        }
        if (this.context.document == null && this.context.array != null) {
            return this.context.array;
        }
        return this.context.document;
    }

    private class DocumentJsonWriteContext
    extends JsonStreamContext {
        private DocumentJsonWriteContext parent;
        private DocumentJsonWriteContext child;
        private String currentName = null;
        private Map document;
        private List array;

        private DocumentJsonWriteContext() {
            this(0, null);
        }

        private DocumentJsonWriteContext(int type, DocumentJsonWriteContext parent) {
            this._type = type;
            this.parent = parent;
        }

        protected DocumentJsonWriteContext reset(int type) {
            this._type = type;
            this.currentName = null;
            this.document = null;
            this.array = null;
            return this;
        }

        @Override
        public JsonStreamContext getParent() {
            return this.parent;
        }

        @Override
        public String getCurrentName() {
            return this.currentName;
        }

        public DocumentJsonWriteContext createChildArrayContext() {
            DocumentJsonWriteContext ctxt = this.child;
            if (this.child == null) {
                ctxt = this.child = new DocumentJsonWriteContext(1, this);
                ctxt.array = MapJsonGenerator.this.arraySupplier.get();
            } else {
                ctxt.reset(1);
                ctxt.array = MapJsonGenerator.this.arraySupplier.get();
            }
            return ctxt;
        }

        public DocumentJsonWriteContext createChildObjectContext() {
            DocumentJsonWriteContext ctxt = this.child;
            if (this.child == null) {
                ctxt = this.child = new DocumentJsonWriteContext(2, this);
                ctxt.document = MapJsonGenerator.this.mapSupplier.get();
            } else {
                ctxt.reset(2);
                ctxt.document = MapJsonGenerator.this.mapSupplier.get();
            }
            return ctxt;
        }

        public void incIndex() {
            ++this._index;
        }

        protected void appendDesc(StringBuilder sb) {
            if (this.inObject()) {
                sb.append('{');
                if (this.currentName != null) {
                    sb.append('\"');
                    sb.append(this.currentName);
                    sb.append('\"');
                } else {
                    sb.append('?');
                }
                sb.append('}');
            } else if (this.inArray()) {
                sb.append('[');
                sb.append(this.getCurrentIndex());
                sb.append(']');
            } else {
                sb.append("/");
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(64);
            this.appendDesc(sb);
            return sb.toString();
        }
    }
}

